/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.log;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;

final class LogListenerThread
extends Thread {
    private boolean m_stopping = false;
    private final List m_entriesToDeliver = new ArrayList();
    private final List m_listeners = new ArrayList();

    LogListenerThread() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEntry(LogEntry entry) {
        List list = this.m_entriesToDeliver;
        synchronized (list) {
            this.m_entriesToDeliver.add(entry);
            this.m_entriesToDeliver.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(LogListener listener) {
        List list = this.m_listeners;
        synchronized (list) {
            this.m_listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(LogListener listener) {
        List list = this.m_listeners;
        synchronized (list) {
            this.m_listeners.remove(listener);
        }
    }

    int getListenerCount() {
        return this.m_listeners.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        List list = this.m_entriesToDeliver;
        synchronized (list) {
            this.m_stopping = true;
            this.m_entriesToDeliver.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean stop = false;
        while (!stop) {
            List list = this.m_entriesToDeliver;
            synchronized (list) {
                if (!this.m_entriesToDeliver.isEmpty()) {
                    LogEntry entry = (LogEntry)this.m_entriesToDeliver.remove(0);
                    List list2 = this.m_listeners;
                    synchronized (list2) {
                        Iterator listenerIt = this.m_listeners.iterator();
                        while (listenerIt.hasNext()) {
                            try {
                                LogListener listener = (LogListener)listenerIt.next();
                                listener.logged(entry);
                            }
                            catch (Throwable t) {}
                        }
                    }
                }
                if (this.m_entriesToDeliver.isEmpty()) {
                    try {
                        this.m_entriesToDeliver.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (!this.m_stopping) continue;
            stop = true;
        }
    }
}

