/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.model.volatility;

import java.util.Collection;
import org.jquantlib.math.IntervalPrice;
import org.jquantlib.model.volatility.LocalVolatilityEstimator;
import org.jquantlib.util.Date;
import org.jquantlib.util.TimeSeries;
import org.jquantlib.util.TimeSeriesDouble;

public abstract class GarmanKlassAbstract
implements LocalVolatilityEstimator<IntervalPrice> {
    private final double yearFraction;

    public GarmanKlassAbstract(double y) {
        this.yearFraction = y;
    }

    @Override
    public TimeSeriesDouble calculate(TimeSeries<IntervalPrice> quoteSeries) {
        Date[] dates = quoteSeries.dates();
        Collection<IntervalPrice> values = quoteSeries.values();
        TimeSeriesDouble retval = new TimeSeriesDouble();
        int i = 0;
        for (IntervalPrice cur : values) {
            double s = Math.sqrt(Math.abs(this.calculatePoint(cur)) / this.yearFraction);
            retval.add(dates[i++], s);
        }
        return retval;
    }

    public double getYearFraction() {
        return this.yearFraction;
    }

    protected abstract double calculatePoint(IntervalPrice var1);
}

