/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments;

import org.joda.primitives.list.impl.ArrayDoubleList;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.Payoff;
import org.jquantlib.math.UnaryFunctionDouble;
import org.jquantlib.math.solvers1D.Brent;
import org.jquantlib.pricingengines.PricingEngine;
import org.jquantlib.pricingengines.arguments.Arguments;
import org.jquantlib.pricingengines.arguments.OneAssetOptionArguments;
import org.jquantlib.pricingengines.arguments.OptionArguments;
import org.jquantlib.pricingengines.results.Greeks;
import org.jquantlib.pricingengines.results.MoreGreeks;
import org.jquantlib.pricingengines.results.OneAssetOptionResults;
import org.jquantlib.pricingengines.results.Results;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;
import org.jquantlib.processes.StochasticProcess;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.termstructures.BlackVolTermStructure;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.volatilities.BlackConstantVol;

public class OneAssetOption
extends Option {
    private double delta;
    private double deltaForward;
    private double elasticity;
    private double gamma;
    private double theta;
    private double thetaPerDay;
    private double vega;
    private double rho;
    private double dividendRho;
    private double itmCashProbability;
    private StochasticProcess stochasticProcess;

    public OneAssetOption(StochasticProcess process, Payoff payoff, Exercise exercise, PricingEngine engine) {
        super(payoff, exercise, engine);
        this.stochasticProcess = process;
        this.stochasticProcess.addObserver(this);
    }

    public double delta() {
        this.calculate();
        if (Double.isNaN(this.delta)) {
            throw new IllegalArgumentException("delta not provided");
        }
        return this.delta;
    }

    public double deltaForward() {
        this.calculate();
        if (Double.isNaN(this.deltaForward)) {
            throw new IllegalArgumentException("forward delta not provided");
        }
        return this.deltaForward;
    }

    public double elasticity() {
        this.calculate();
        if (Double.isNaN(this.elasticity)) {
            throw new IllegalArgumentException("elasticity not provided");
        }
        return this.elasticity;
    }

    public double gamma() {
        this.calculate();
        if (Double.isNaN(this.gamma)) {
            throw new IllegalArgumentException("gamma not provided");
        }
        return this.gamma;
    }

    public double theta() {
        this.calculate();
        if (Double.isNaN(this.theta)) {
            throw new IllegalArgumentException("theta not provided");
        }
        return this.theta;
    }

    public double thetaPerDay() {
        this.calculate();
        if (Double.isNaN(this.thetaPerDay)) {
            throw new IllegalArgumentException("theta per-day not provided");
        }
        return this.thetaPerDay;
    }

    public double vega() {
        this.calculate();
        if (Double.isNaN(this.vega)) {
            throw new IllegalArgumentException("vega not provided");
        }
        return this.vega;
    }

    public double rho() {
        this.calculate();
        if (Double.isNaN(this.rho)) {
            throw new IllegalArgumentException("rho not provided");
        }
        return this.rho;
    }

    public double dividendRho() {
        this.calculate();
        if (Double.isNaN(this.dividendRho)) {
            throw new IllegalArgumentException("dividend rho not provided");
        }
        return this.dividendRho;
    }

    public double itmCashProbability() {
        this.calculate();
        if (Double.isNaN(this.itmCashProbability)) {
            throw new IllegalArgumentException("in-the-money cash probability not provided");
        }
        return this.itmCashProbability;
    }

    @Override
    public void setupArguments(Arguments arguments) {
        if (!OneAssetOptionArguments.class.isAssignableFrom(arguments.getClass())) {
            throw new ClassCastException(arguments.toString());
        }
        OneAssetOptionArguments oneAssetArguments = (OneAssetOptionArguments)arguments;
        OptionArguments optionArguments = (OptionArguments)arguments;
        oneAssetArguments.stochasticProcess = this.stochasticProcess;
        optionArguments.exercise = this.exercise;
        int n = this.exercise.size();
        ArrayDoubleList arr = new ArrayDoubleList(n);
        for (int i = 0; i < n; ++i) {
            arr.add(this.stochasticProcess.getTime(this.exercise.date(i)));
        }
        optionArguments.stoppingTimes = arr;
    }

    @Override
    public void fetchResults(Results results) {
        super.fetchResults(results);
        if (!MoreGreeks.class.isAssignableFrom(results.getClass())) {
            throw new ClassCastException(results.getClass().getName());
        }
        MoreGreeks moreGreeks = (MoreGreeks)results;
        Greeks greeks = (Greeks)results;
        this.delta = greeks.delta;
        this.gamma = greeks.gamma;
        this.theta = greeks.theta;
        this.vega = greeks.vega;
        this.rho = greeks.rho;
        this.dividendRho = greeks.dividendRho;
        this.deltaForward = moreGreeks.deltaForward;
        this.elasticity = moreGreeks.elasticity;
        this.thetaPerDay = moreGreeks.thetaPerDay;
        this.itmCashProbability = moreGreeks.itmCashProbability;
    }

    public double impliedVolatility(double targetValue) {
        return this.impliedVolatility(targetValue, 1.0E-4, 100, 1.0E-7, 4.0);
    }

    private final double impliedVolatility(double targetValue, double accuracy, int maxEvaluations, double minVol, double maxVol) {
        this.calculate();
        if (this.isExpired()) {
            throw new IllegalArgumentException("option expired");
        }
        double guess = (minVol + maxVol) / 2.0;
        ImpliedVolatilityHelper f = new ImpliedVolatilityHelper(this.engine, targetValue);
        Brent solver = new Brent();
        solver.setMaxEvaluations(maxEvaluations);
        double result = solver.solve(f, accuracy, guess, minVol, maxVol);
        return result;
    }

    @Override
    protected void setupExpired() {
        super.setupExpired();
        this.itmCashProbability = 0.0;
        this.dividendRho = 0.0;
        this.rho = 0.0;
        this.vega = 0.0;
        this.thetaPerDay = 0.0;
        this.theta = 0.0;
        this.gamma = 0.0;
        this.elasticity = 0.0;
        this.deltaForward = 0.0;
        this.delta = 0.0;
    }

    private static class ImpliedVolatilityHelper
    implements UnaryFunctionDouble {
        private final OneAssetOptionResults impliedResults;
        private PricingEngine impliedEngine;
        private Handle<Quote> vol;
        private double targetValue;

        public ImpliedVolatilityHelper(PricingEngine engine, double targetValue) {
            this.impliedEngine = engine;
            this.targetValue = targetValue;
            Arguments tmpArgs = this.impliedEngine.getArguments();
            if (!OneAssetOptionArguments.class.isAssignableFrom(tmpArgs.getClass())) {
                throw new ClassCastException(tmpArgs.getClass().getName());
            }
            OneAssetOptionArguments oneAssetArguments = (OneAssetOptionArguments)tmpArgs;
            GeneralizedBlackScholesProcess originalProcess = (GeneralizedBlackScholesProcess)oneAssetArguments.stochasticProcess;
            if (originalProcess == null) {
                throw new NullPointerException("Black-Scholes process required");
            }
            this.vol = new Handle<SimpleQuote>(new SimpleQuote(0.0));
            Handle<? extends Quote> stateVariable = originalProcess.stateVariable();
            Handle<YieldTermStructure> dividendYield = originalProcess.dividendYield();
            Handle<YieldTermStructure> riskFreeRate = originalProcess.riskFreeRate();
            Handle<BlackVolTermStructure> blackVol = originalProcess.blackVolatility();
            Handle<BlackVolTermStructure> volatility = new Handle<BlackVolTermStructure>(new BlackConstantVol(blackVol.getLink().referenceDate(), this.vol, blackVol.getLink().dayCounter()));
            GeneralizedBlackScholesProcess process = new GeneralizedBlackScholesProcess(stateVariable, dividendYield, riskFreeRate, volatility);
            oneAssetArguments.stochasticProcess = process;
            if (!OneAssetOptionResults.class.isAssignableFrom(this.impliedEngine.getResults().getClass())) {
                throw new ClassCastException(this.impliedEngine.getClass().getName());
            }
            this.impliedResults = (OneAssetOptionResults)this.impliedEngine.getResults();
        }

        @Override
        public final double evaluate(double x) {
            SimpleQuote quote = (SimpleQuote)this.vol.getLink();
            quote.setValue(x);
            this.impliedEngine.calculate();
            return this.impliedResults.value - this.targetValue;
        }
    }
}

