/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio;

import com.pi4j.concurrent.DefaultExecutorServiceFactory;
import com.pi4j.concurrent.ExecutorServiceFactory;
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.gpio.RaspiGpioProvider;
import com.pi4j.io.gpio.impl.GpioControllerImpl;

public class GpioFactory {
    private static GpioController controller = null;
    private static GpioProvider provider = null;
    private static ExecutorServiceFactory executorServiceFactory = null;

    private GpioFactory() {
    }

    public static GpioController getInstance() {
        if (controller == null) {
            controller = new GpioControllerImpl();
        }
        return controller;
    }

    public static GpioProvider getDefaultProvider() {
        if (provider == null) {
            provider = new RaspiGpioProvider();
        }
        return provider;
    }

    public static void setDefaultProvider(GpioProvider provider) {
        GpioFactory.provider = provider;
    }

    public static ExecutorServiceFactory getExecutorServiceFactory() {
        if (executorServiceFactory == null) {
            executorServiceFactory = new DefaultExecutorServiceFactory();
        }
        return executorServiceFactory;
    }

    public static void setExecutorServiceFactory(ExecutorServiceFactory executorServiceFactory) {
        GpioFactory.executorServiceFactory = executorServiceFactory;
    }
}

