/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.processes;

import org.jquantlib.processes.EulerDiscretization;
import org.jquantlib.processes.LinearDiscretization;
import org.jquantlib.processes.StochasticProcess1D;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.quotes.RelinkableHandle;
import org.jquantlib.termstructures.BlackVolTermStructure;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.termstructures.LocalVolTermStructure;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.volatilities.BlackConstantVol;
import org.jquantlib.termstructures.volatilities.BlackVarianceCurve;
import org.jquantlib.termstructures.volatilities.LocalConstantVol;
import org.jquantlib.termstructures.volatilities.LocalVolCurve;
import org.jquantlib.termstructures.volatilities.LocalVolSurface;
import org.jquantlib.time.Frequency;
import org.jquantlib.util.Date;
import org.jquantlib.util.Observable;

public class GeneralizedBlackScholesProcess
extends StochasticProcess1D {
    private Handle<? extends Quote> x0_;
    private Handle<YieldTermStructure> riskFreeRate_;
    private Handle<YieldTermStructure> dividendYield_;
    private Handle<BlackVolTermStructure> blackVolatility_;
    private RelinkableHandle<LocalVolTermStructure> localVolatility_;
    private boolean updated_;

    public GeneralizedBlackScholesProcess(Handle<? extends Quote> x0, Handle<YieldTermStructure> dividendTS, Handle<YieldTermStructure> riskFreeTS, Handle<BlackVolTermStructure> blackVolTS) {
        this(x0, dividendTS, riskFreeTS, blackVolTS, new EulerDiscretization());
    }

    public GeneralizedBlackScholesProcess(Handle<? extends Quote> x0, Handle<YieldTermStructure> dividendTS, Handle<YieldTermStructure> riskFreeTS, Handle<BlackVolTermStructure> blackVolTS, LinearDiscretization discretization) {
        super(discretization);
        this.x0_ = x0;
        this.riskFreeRate_ = riskFreeTS;
        this.dividendYield_ = dividendTS;
        this.blackVolatility_ = blackVolTS;
        this.localVolatility_ = new RelinkableHandle<Class<LocalVolTermStructure>>(LocalVolTermStructure.class);
        this.updated_ = false;
        this.x0_.addObserver(this);
        this.riskFreeRate_.addObserver(this);
        this.dividendYield_.addObserver(this);
        this.blackVolatility_.addObserver(this);
    }

    @Override
    public double x0() {
        return this.x0_.getLink().evaluate();
    }

    @Override
    public double drift(double t, double x) {
        double sigma = this.diffusion(t, x);
        double t1 = t + 1.0E-4;
        YieldTermStructure yts = this.riskFreeRate_.getLink();
        double r = yts.forwardRate(t, t1, Compounding.CONTINUOUS, Frequency.NO_FREQUENCY, true).rate();
        YieldTermStructure divTs = this.dividendYield_.getLink();
        double d = divTs.forwardRate(t, t1, Compounding.CONTINUOUS, Frequency.NO_FREQUENCY, true).rate();
        return r - d - 0.5 * sigma * sigma;
    }

    @Override
    public double diffusion(double t, double x) {
        double vol = this.localVolatility().getLink().localVol(t, x, true);
        return vol;
    }

    @Override
    public final double apply(double x0, double dx) {
        double result = x0 * Math.exp(dx);
        return result;
    }

    @Override
    public final double getTime(Date d) {
        YieldTermStructure yts = this.riskFreeRate_.getLink();
        return yts.dayCounter().yearFraction(yts.referenceDate(), d);
    }

    @Override
    public final void update(Observable o, Object arg) {
        this.updated_ = false;
        super.update(o, arg);
    }

    public final Handle<? extends Quote> stateVariable() {
        return this.x0_;
    }

    public final Handle<YieldTermStructure> dividendYield() {
        return this.dividendYield_;
    }

    public final Handle<YieldTermStructure> riskFreeRate() {
        return this.riskFreeRate_;
    }

    public final Handle<BlackVolTermStructure> blackVolatility() {
        return this.blackVolatility_;
    }

    public final Handle<LocalVolTermStructure> localVolatility() {
        if (!this.updated_) {
            Class<?> klass = this.blackVolatility_.getLink().getClass();
            if (BlackConstantVol.class.isAssignableFrom(klass)) {
                BlackConstantVol constVol = (BlackConstantVol)this.blackVolatility_.getLink();
                this.localVolatility_.setLink(new LocalConstantVol(constVol.referenceDate(), constVol.blackVol(0.0, this.x0_.getLink().evaluate()), constVol.dayCounter()));
                this.updated_ = true;
                return this.localVolatility_;
            }
            if (BlackVarianceCurve.class.isAssignableFrom(klass)) {
                Handle<BlackVarianceCurve> volCurve = new Handle<BlackVarianceCurve>((BlackVarianceCurve)this.blackVolatility().getLink());
                this.localVolatility_.setLink(new LocalVolCurve(volCurve));
                this.updated_ = true;
                return this.localVolatility_;
            }
            if (LocalVolSurface.class.isAssignableFrom(klass)) {
                this.localVolatility_.setLink(new LocalVolSurface(this.blackVolatility_, this.riskFreeRate_, this.dividendYield_, this.x0_));
                this.updated_ = true;
                return this.localVolatility_;
            }
            throw new UnsupportedOperationException();
        }
        return this.localVolatility_;
    }
}

