/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.CharConversionException;
import org.mozilla.jss.asn1.CharConverter;
import org.mozilla.jss.asn1.CharacterString;
import org.mozilla.jss.asn1.Tag;

public class IA5String
extends CharacterString {
    public static final Tag TAG = new Tag(Tag.Class.UNIVERSAL, 22L);
    private static final Template templateInstance = new Template();

    public IA5String(char[] chars) throws CharConversionException {
        super(chars);
    }

    public IA5String(String s) throws CharConversionException {
        super(s);
    }

    @Override
    CharConverter getCharConverter() {
        return new IA5Converter();
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    private static class IA5Converter
    implements CharConverter {
        private IA5Converter() {
        }

        @Override
        public char[] byteToChar(byte[] bytes, int offset, int len) throws CharConversionException {
            char[] chars = new char[len];
            int b = offset;
            for (int c = 0; c < len; ++c) {
                if ((bytes[b] & 0x80) != 0) {
                    throw new CharConversionException("Invalid character: " + bytes[b]);
                }
                chars[c] = (char)(bytes[b] & 0x7F);
                ++b;
            }
            return chars;
        }

        @Override
        public byte[] charToByte(char[] chars, int offset, int len) throws CharConversionException {
            byte[] bytes = new byte[len];
            int c = offset;
            for (int b = 0; b < len; ++b) {
                if ((chars[c] & 0x7F) != chars[c]) {
                    throw new CharConversionException("Invalid character: " + chars[c]);
                }
                bytes[b] = (byte)(chars[c] & 0x7F);
                ++c;
            }
            return bytes;
        }
    }

    public static class Template
    extends CharacterString.Template {
        @Override
        public Tag getTag() {
            return TAG;
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return tag.equals(TAG);
        }

        @Override
        protected CharConverter getCharConverter() {
            return new IA5Converter();
        }

        @Override
        protected CharacterString generateInstance(char[] chars) throws CharConversionException {
            return new IA5String(chars);
        }

        @Override
        protected String typeName() {
            return "IA5String";
        }
    }
}

