/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;

public class TaggedAttribute
implements ASN1Value {
    public static final INTEGER BODYIDMAX = new INTEGER("4294967295");
    private SEQUENCE sequence = new SEQUENCE();
    private INTEGER bodyPartID;
    private OBJECT_IDENTIFIER type;
    private SET values;
    public static final Tag TAG = SEQUENCE.TAG;
    private static Template templateInstance = new Template();

    public TaggedAttribute(INTEGER bodyPartID, OBJECT_IDENTIFIER type, SET values) {
        assert (bodyPartID.compareTo(BODYIDMAX) <= 0);
        this.bodyPartID = bodyPartID;
        this.sequence.addElement(bodyPartID);
        this.type = type;
        this.sequence.addElement(type);
        this.values = values;
        this.sequence.addElement(values);
    }

    public TaggedAttribute(INTEGER bodyPartID, OBJECT_IDENTIFIER type, ASN1Value value) {
        assert (bodyPartID.compareTo(BODYIDMAX) <= 0);
        this.bodyPartID = bodyPartID;
        this.sequence.addElement(bodyPartID);
        this.type = type;
        this.sequence.addElement(type);
        this.values = new SET();
        this.values.addElement(value);
        this.sequence.addElement(this.values);
    }

    public INTEGER getBodyPartID() {
        return this.bodyPartID;
    }

    public OBJECT_IDENTIFIER getType() {
        return this.type;
    }

    public SET getValues() {
        return this.values;
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    @Override
    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        this.sequence.encode(implicit, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(new OBJECT_IDENTIFIER.Template());
            this.seqt.addElement(new SET.OF_Template(new ANY.Template()));
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            assert (seq.size() == 3);
            return new TaggedAttribute((INTEGER)seq.elementAt(0), (OBJECT_IDENTIFIER)seq.elementAt(1), (SET)seq.elementAt(2));
        }
    }
}

