/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.OIDMap;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;

public class InvalidityDateExtension
extends Extension
implements CertAttrSet {
    private static final long serialVersionUID = 2191026017389643053L;
    public static final String NAME = "InvalidityDate";
    public static final String INVALIDITY_DATE = "value";
    public static final String OID = "2.5.29.24";
    private Date invalidityDate = null;

    private void encodeThis() throws IOException {
        if (this.invalidityDate == null) {
            throw new IOException("Unintialized invalidity date extension");
        }
        try (DerOutputStream os = new DerOutputStream();){
            os.putGeneralizedTime(this.invalidityDate);
            this.extensionValue = os.toByteArray();
        }
    }

    public InvalidityDateExtension(Date dateOfInvalidity) throws IOException {
        this.invalidityDate = dateOfInvalidity;
        this.extensionId = PKIXExtensions.InvalidityDate_Id;
        this.critical = false;
        this.encodeThis();
    }

    public InvalidityDateExtension(Boolean critical, Date dateOfInvalidity) throws IOException {
        this.invalidityDate = dateOfInvalidity;
        this.extensionId = PKIXExtensions.InvalidityDate_Id;
        this.critical = critical;
        this.encodeThis();
    }

    public InvalidityDateExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = PKIXExtensions.InvalidityDate_Id;
        this.critical = critical;
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        for (int i = 0; i < len; ++i) {
            extValue[i] = Array.getByte(value, i);
        }
        this.extensionValue = extValue;
        DerValue val = new DerValue(extValue);
        if (val.tag != 24) {
            throw new IOException("Invalid encoding for InvalidityDateExtension");
        }
        DerInputStream derInputStream = new DerInputStream(val.toByteArray());
        this.invalidityDate = derInputStream.getGeneralizedTime();
    }

    public Date getInvalidityDate() {
        return this.invalidityDate;
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (name.equalsIgnoreCase(INVALIDITY_DATE)) {
            if (!(obj instanceof Date)) {
                throw new IOException("Attribute must be of type Date.");
            }
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:InvalidityDate.");
        }
        this.invalidityDate = (Date)obj;
    }

    @Override
    public Object get(String name) throws IOException {
        if (name.equalsIgnoreCase(INVALIDITY_DATE)) {
            if (this.invalidityDate == null) {
                return null;
            }
            return this.invalidityDate;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:InvalidityDate.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (!name.equalsIgnoreCase(INVALIDITY_DATE)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:InvalidityDate.");
        }
        this.invalidityDate = null;
    }

    @Override
    public String toString() {
        String s = super.toString() + "Invalidity Date: " + (this.invalidityDate == null ? "" : this.invalidityDate.toString()) + "\n";
        return s;
    }

    @Override
    public void decode(InputStream in) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.InvalidityDate_Id;
            this.critical = true;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        Vector<String> elements = new Vector<String>();
        elements.addElement(INVALIDITY_DATE);
        return elements.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }

    static {
        try {
            OIDMap.addAttribute(InvalidityDateExtension.class.getName(), OID, NAME);
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
    }
}

