import { BaseTransport, TransportItem } from '@grafana/agent-core';
export interface FetchTransportRequestOptions extends Omit<RequestInit, 'body' | 'headers'> {
    headers?: Record<string, string>;
}
export interface FetchTransportOptions {
    url: string;
    apiKey?: string;
    debug?: boolean;
    requestOptions?: FetchTransportRequestOptions;
}
export declare class FetchTransport extends BaseTransport {
    private options;
    constructor(options: FetchTransportOptions);
    send(item: TransportItem): Promise<void>;
    getIgnoreUrls(): Array<string | RegExp>;
}
