import { BaseInstrumentation, VERSION } from '@grafana/agent-core';
import { registerOnerror } from './registerOnerror';
import { registerOnunhandledrejection } from './registerOnunhandledrejection';
export { parseStacktrace } from './stackFrames';
export class ErrorsInstrumentation extends BaseInstrumentation {
    constructor() {
        super(...arguments);
        this.version = VERSION;
        this.name = '@grafana/agent-web:instrumentation-errors';
    }
    initialize() {
        registerOnerror(this.agent);
        registerOnunhandledrejection(this.agent);
    }
}
//# sourceMappingURL=index.js.map