import { AuthSettings, BootData, BuildInfo, DataSourceInstanceSettings, FeatureToggles, GrafanaConfig, GrafanaTheme, GrafanaTheme2, LicenseInfo, MapLayerOptions, OAuthSettings, PanelPluginMeta, PreloadPlugin, SystemDateFormatSettings } from '@grafana/data';
export interface AzureSettings {
    cloud?: string;
    managedIdentityEnabled: boolean;
}
export declare class GrafanaBootConfig implements GrafanaConfig {
    isPublicDashboardView: boolean;
    datasources: {
        [str: string]: DataSourceInstanceSettings;
    };
    panels: {
        [key: string]: PanelPluginMeta;
    };
    auth: AuthSettings;
    minRefreshInterval: string;
    appUrl: string;
    appSubUrl: string;
    windowTitlePrefix: string;
    buildInfo: BuildInfo;
    newPanelTitle: string;
    bootData: BootData;
    externalUserMngLinkUrl: string;
    externalUserMngLinkName: string;
    externalUserMngInfo: string;
    allowOrgCreate: boolean;
    feedbackLinksEnabled: boolean;
    disableLoginForm: boolean;
    defaultDatasource: string;
    alertingEnabled: boolean;
    alertingErrorOrTimeout: string;
    alertingNoDataOrNullValues: string;
    alertingMinInterval: number;
    angularSupportEnabled: boolean;
    authProxyEnabled: boolean;
    exploreEnabled: boolean;
    queryHistoryEnabled: boolean;
    helpEnabled: boolean;
    profileEnabled: boolean;
    ldapEnabled: boolean;
    jwtHeaderName: string;
    jwtUrlLogin: boolean;
    sigV4AuthEnabled: boolean;
    azureAuthEnabled: boolean;
    samlEnabled: boolean;
    samlName: string;
    autoAssignOrg: boolean;
    verifyEmailEnabled: boolean;
    oauth: OAuthSettings;
    rbacEnabled: boolean;
    rbacBuiltInRoleAssignmentEnabled: boolean;
    disableUserSignUp: boolean;
    loginHint: string;
    passwordHint: string;
    loginError: undefined;
    navTree: undefined;
    viewersCanEdit: boolean;
    editorsCanAdmin: boolean;
    disableSanitizeHtml: boolean;
    liveEnabled: boolean;
    theme: GrafanaTheme;
    theme2: GrafanaTheme2;
    pluginsToPreload: PreloadPlugin[];
    featureToggles: FeatureToggles;
    licenseInfo: LicenseInfo;
    rendererAvailable: boolean;
    dashboardPreviews: {
        systemRequirements: {
            met: boolean;
            requiredImageRendererPluginVersion: string;
        };
        thumbnailsExist: boolean;
    };
    rendererVersion: string;
    secretsManagerPluginEnabled: boolean;
    http2Enabled: boolean;
    dateFormats?: SystemDateFormatSettings;
    sentry: {
        enabled: boolean;
        dsn: string;
        customEndpoint: string;
        sampleRate: number;
    };
    grafanaJavascriptAgent: {
        enabled: boolean;
        customEndpoint: string;
        apiKey: string;
        errorInstrumentalizationEnabled: boolean;
        consoleInstrumentalizationEnabled: boolean;
        webVitalsInstrumentalizationEnabled: boolean;
    };
    pluginCatalogURL: string;
    pluginAdminEnabled: boolean;
    pluginAdminExternalManageEnabled: boolean;
    pluginCatalogHiddenPlugins: string[];
    expressionsEnabled: boolean;
    customTheme?: undefined;
    awsAllowedAuthProviders: string[];
    awsAssumeRoleEnabled: boolean;
    azure: AzureSettings;
    caching: {
        enabled: boolean;
    };
    geomapDefaultBaseLayerConfig?: MapLayerOptions;
    geomapDisableCustomBaseLayer?: boolean;
    unifiedAlertingEnabled: boolean;
    unifiedAlerting: {
        minInterval: string;
    };
    applicationInsightsConnectionString?: string;
    applicationInsightsEndpointUrl?: string;
    recordedQueries: {
        enabled: boolean;
    };
    featureHighlights: {
        enabled: boolean;
    };
    reporting: {
        enabled: boolean;
    };
    googleAnalyticsId: undefined;
    rudderstackWriteKey: undefined;
    rudderstackDataPlaneUrl: undefined;
    rudderstackSdkUrl: undefined;
    rudderstackConfigUrl: undefined;
    constructor(options: GrafanaBootConfig);
}
/**
 * Use this to access the {@link GrafanaBootConfig} for the current running Grafana instance.
 *
 * @public
 */
export declare const config: GrafanaBootConfig;
