/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.crmf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.crmf.CertTemplate;
import org.mozilla.jss.pkix.primitive.AVA;

public class CertRequest
implements ASN1Value {
    private INTEGER certReqId;
    private CertTemplate certTemplate;
    private SEQUENCE controls;
    public static final Tag TAG = SEQUENCE.TAG;

    public CertRequest(INTEGER certReqId, CertTemplate certTemplate, SEQUENCE controls) {
        if (certReqId == null) {
            throw new NullPointerException("certReqId is null");
        }
        this.certReqId = certReqId;
        if (certTemplate == null) {
            throw new NullPointerException("certTemplate is null");
        }
        this.certTemplate = certTemplate;
        this.controls = controls;
    }

    public INTEGER getCertReqId() {
        return this.certReqId;
    }

    public CertTemplate getCertTemplate() {
        return this.certTemplate;
    }

    public SEQUENCE getControls() {
        return this.controls;
    }

    public int numControls() {
        if (this.controls == null) {
            return 0;
        }
        return this.controls.size();
    }

    public AVA controlAt(int i) {
        if (this.controls == null) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (AVA)this.controls.elementAt(i);
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    @Override
    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE sequence = new SEQUENCE();
        sequence.addElement(this.certReqId);
        sequence.addElement(this.certTemplate);
        if (this.controls != null) {
            sequence.addElement(this.controls);
        }
        sequence.encode(implicit, ostream);
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqTemplate = new SEQUENCE.Template();

        public Template() {
            this.seqTemplate.addElement(new INTEGER.Template());
            this.seqTemplate.addElement(new CertTemplate.Template());
            this.seqTemplate.addOptionalElement(new SEQUENCE.OF_Template(new AVA.Template()));
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqTemplate.decode(implicit, istream);
            return new CertRequest((INTEGER)seq.elementAt(0), (CertTemplate)seq.elementAt(1), (SEQUENCE)seq.elementAt(2));
        }
    }
}

