/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// RepositoriesOstreeAPIService RepositoriesOstreeAPI service
type RepositoriesOstreeAPIService service

type RepositoriesOstreeAPIRepositoriesOstreeOstreeCreateRequest struct {
	ctx context.Context
	ApiService *RepositoriesOstreeAPIService
	ostreeOstreeRepository *OstreeOstreeRepository
}

func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeCreateRequest) OstreeOstreeRepository(ostreeOstreeRepository OstreeOstreeRepository) RepositoriesOstreeAPIRepositoriesOstreeOstreeCreateRequest {
	r.ostreeOstreeRepository = &ostreeOstreeRepository
	return r
}

func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeCreateRequest) Execute() (*OstreeOstreeRepositoryResponse, *http.Response, error) {
	return r.ApiService.RepositoriesOstreeOstreeCreateExecute(r)
}

/*
RepositoriesOstreeOstreeCreate Create an ostree repository

A ViewSet class for OSTree repositories.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return RepositoriesOstreeAPIRepositoriesOstreeOstreeCreateRequest
*/
func (a *RepositoriesOstreeAPIService) RepositoriesOstreeOstreeCreate(ctx context.Context) RepositoriesOstreeAPIRepositoriesOstreeOstreeCreateRequest {
	return RepositoriesOstreeAPIRepositoriesOstreeOstreeCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return OstreeOstreeRepositoryResponse
func (a *RepositoriesOstreeAPIService) RepositoriesOstreeOstreeCreateExecute(r RepositoriesOstreeAPIRepositoriesOstreeOstreeCreateRequest) (*OstreeOstreeRepositoryResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *OstreeOstreeRepositoryResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesOstreeAPIService.RepositoriesOstreeOstreeCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/repositories/ostree/ostree/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.ostreeOstreeRepository == nil {
		return localVarReturnValue, nil, reportError("ostreeOstreeRepository is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.ostreeOstreeRepository
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesOstreeAPIRepositoriesOstreeOstreeDeleteRequest struct {
	ctx context.Context
	ApiService *RepositoriesOstreeAPIService
	ostreeOstreeRepositoryHref string
}

func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeDeleteRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesOstreeOstreeDeleteExecute(r)
}

/*
RepositoriesOstreeOstreeDelete Delete an ostree repository

Trigger an asynchronous delete task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ostreeOstreeRepositoryHref
 @return RepositoriesOstreeAPIRepositoriesOstreeOstreeDeleteRequest
*/
func (a *RepositoriesOstreeAPIService) RepositoriesOstreeOstreeDelete(ctx context.Context, ostreeOstreeRepositoryHref string) RepositoriesOstreeAPIRepositoriesOstreeOstreeDeleteRequest {
	return RepositoriesOstreeAPIRepositoriesOstreeOstreeDeleteRequest{
		ApiService: a,
		ctx: ctx,
		ostreeOstreeRepositoryHref: ostreeOstreeRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesOstreeAPIService) RepositoriesOstreeOstreeDeleteExecute(r RepositoriesOstreeAPIRepositoriesOstreeOstreeDeleteRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesOstreeAPIService.RepositoriesOstreeOstreeDelete")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ostree_ostree_repository_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"ostree_ostree_repository_href"+"}", parameterValueToString(r.ostreeOstreeRepositoryHref, "ostreeOstreeRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesOstreeAPIRepositoriesOstreeOstreeImportAllRequest struct {
	ctx context.Context
	ApiService *RepositoriesOstreeAPIService
	ostreeOstreeRepositoryHref string
	ostreeImportAll *OstreeImportAll
}

func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeImportAllRequest) OstreeImportAll(ostreeImportAll OstreeImportAll) RepositoriesOstreeAPIRepositoriesOstreeOstreeImportAllRequest {
	r.ostreeImportAll = &ostreeImportAll
	return r
}

func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeImportAllRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesOstreeOstreeImportAllExecute(r)
}

/*
RepositoriesOstreeOstreeImportAll Import refs and commits to a repository

Trigger an asynchronous task to import all refs and commits to a repository.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ostreeOstreeRepositoryHref
 @return RepositoriesOstreeAPIRepositoriesOstreeOstreeImportAllRequest
*/
func (a *RepositoriesOstreeAPIService) RepositoriesOstreeOstreeImportAll(ctx context.Context, ostreeOstreeRepositoryHref string) RepositoriesOstreeAPIRepositoriesOstreeOstreeImportAllRequest {
	return RepositoriesOstreeAPIRepositoriesOstreeOstreeImportAllRequest{
		ApiService: a,
		ctx: ctx,
		ostreeOstreeRepositoryHref: ostreeOstreeRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesOstreeAPIService) RepositoriesOstreeOstreeImportAllExecute(r RepositoriesOstreeAPIRepositoriesOstreeOstreeImportAllRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesOstreeAPIService.RepositoriesOstreeOstreeImportAll")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ostree_ostree_repository_href}import_all/"
	localVarPath = strings.Replace(localVarPath, "{"+"ostree_ostree_repository_href"+"}", parameterValueToString(r.ostreeOstreeRepositoryHref, "ostreeOstreeRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.ostreeImportAll == nil {
		return localVarReturnValue, nil, reportError("ostreeImportAll is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.ostreeImportAll
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesOstreeAPIRepositoriesOstreeOstreeImportCommitsRequest struct {
	ctx context.Context
	ApiService *RepositoriesOstreeAPIService
	ostreeOstreeRepositoryHref string
	ostreeImportCommitsToRef *OstreeImportCommitsToRef
}

func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeImportCommitsRequest) OstreeImportCommitsToRef(ostreeImportCommitsToRef OstreeImportCommitsToRef) RepositoriesOstreeAPIRepositoriesOstreeOstreeImportCommitsRequest {
	r.ostreeImportCommitsToRef = &ostreeImportCommitsToRef
	return r
}

func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeImportCommitsRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesOstreeOstreeImportCommitsExecute(r)
}

/*
RepositoriesOstreeOstreeImportCommits Append child commits to a repository

Trigger an asynchronous task to append child commits to a repository.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ostreeOstreeRepositoryHref
 @return RepositoriesOstreeAPIRepositoriesOstreeOstreeImportCommitsRequest
*/
func (a *RepositoriesOstreeAPIService) RepositoriesOstreeOstreeImportCommits(ctx context.Context, ostreeOstreeRepositoryHref string) RepositoriesOstreeAPIRepositoriesOstreeOstreeImportCommitsRequest {
	return RepositoriesOstreeAPIRepositoriesOstreeOstreeImportCommitsRequest{
		ApiService: a,
		ctx: ctx,
		ostreeOstreeRepositoryHref: ostreeOstreeRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesOstreeAPIService) RepositoriesOstreeOstreeImportCommitsExecute(r RepositoriesOstreeAPIRepositoriesOstreeOstreeImportCommitsRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesOstreeAPIService.RepositoriesOstreeOstreeImportCommits")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ostree_ostree_repository_href}import_commits/"
	localVarPath = strings.Replace(localVarPath, "{"+"ostree_ostree_repository_href"+"}", parameterValueToString(r.ostreeOstreeRepositoryHref, "ostreeOstreeRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.ostreeImportCommitsToRef == nil {
		return localVarReturnValue, nil, reportError("ostreeImportCommitsToRef is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.ostreeImportCommitsToRef
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest struct {
	ctx context.Context
	ApiService *RepositoriesOstreeAPIService
	latestWithContent *string
	limit *int32
	name *string
	nameContains *string
	nameIcontains *string
	nameIn *[]string
	nameStartswith *string
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	pulpLabelSelect *string
	remote *string
	retainRepoVersions *int32
	retainRepoVersionsGt *int32
	retainRepoVersionsGte *int32
	retainRepoVersionsIsnull *bool
	retainRepoVersionsLt *int32
	retainRepoVersionsLte *int32
	retainRepoVersionsNe *int32
	retainRepoVersionsRange *[]int32
	withContent *string
	fields *[]string
	excludeFields *[]string
}

// Content Unit referenced by HREF
func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest) LatestWithContent(latestWithContent string) RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest {
	r.latestWithContent = &latestWithContent
	return r
}

// Number of results to return per page.
func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest) Limit(limit int32) RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest {
	r.limit = &limit
	return r
}

// Filter results where name matches value
func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest) Name(name string) RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest {
	r.name = &name
	return r
}

// Filter results where name contains value
func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest) NameContains(nameContains string) RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest {
	r.nameContains = &nameContains
	return r
}

// Filter results where name contains value
func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest) NameIcontains(nameIcontains string) RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest {
	r.nameIcontains = &nameIcontains
	return r
}

// Filter results where name is in a comma-separated list of values
func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest) NameIn(nameIn []string) RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest {
	r.nameIn = &nameIn
	return r
}

// Filter results where name starts with value
func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest) NameStartswith(nameStartswith string) RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest {
	r.nameStartswith = &nameStartswith
	return r
}

// The initial index from which to return the results.
func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest) Offset(offset int32) RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;pulp_labels&#x60; - Pulp labels * &#x60;-pulp_labels&#x60; - Pulp labels (descending) * &#x60;description&#x60; - Description * &#x60;-description&#x60; - Description (descending) * &#x60;next_version&#x60; - Next version * &#x60;-next_version&#x60; - Next version (descending) * &#x60;retain_repo_versions&#x60; - Retain repo versions * &#x60;-retain_repo_versions&#x60; - Retain repo versions (descending) * &#x60;user_hidden&#x60; - User hidden * &#x60;-user_hidden&#x60; - User hidden (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest) Ordering(ordering []string) RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest) PulpHrefIn(pulpHrefIn []string) RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest) PulpIdIn(pulpIdIn []string) RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Filter labels by search string
func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest) PulpLabelSelect(pulpLabelSelect string) RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest {
	r.pulpLabelSelect = &pulpLabelSelect
	return r
}

// Foreign Key referenced by HREF
func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest) Remote(remote string) RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest {
	r.remote = &remote
	return r
}

// Filter results where retain_repo_versions matches value
func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest) RetainRepoVersions(retainRepoVersions int32) RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest {
	r.retainRepoVersions = &retainRepoVersions
	return r
}

// Filter results where retain_repo_versions is greater than value
func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest) RetainRepoVersionsGt(retainRepoVersionsGt int32) RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest {
	r.retainRepoVersionsGt = &retainRepoVersionsGt
	return r
}

// Filter results where retain_repo_versions is greater than or equal to value
func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest) RetainRepoVersionsGte(retainRepoVersionsGte int32) RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest {
	r.retainRepoVersionsGte = &retainRepoVersionsGte
	return r
}

// Filter results where retain_repo_versions has a null value
func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest) RetainRepoVersionsIsnull(retainRepoVersionsIsnull bool) RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest {
	r.retainRepoVersionsIsnull = &retainRepoVersionsIsnull
	return r
}

// Filter results where retain_repo_versions is less than value
func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest) RetainRepoVersionsLt(retainRepoVersionsLt int32) RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest {
	r.retainRepoVersionsLt = &retainRepoVersionsLt
	return r
}

// Filter results where retain_repo_versions is less than or equal to value
func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest) RetainRepoVersionsLte(retainRepoVersionsLte int32) RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest {
	r.retainRepoVersionsLte = &retainRepoVersionsLte
	return r
}

// Filter results where retain_repo_versions not equal to value
func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest) RetainRepoVersionsNe(retainRepoVersionsNe int32) RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest {
	r.retainRepoVersionsNe = &retainRepoVersionsNe
	return r
}

// Filter results where retain_repo_versions is between two comma separated values
func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest) RetainRepoVersionsRange(retainRepoVersionsRange []int32) RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest {
	r.retainRepoVersionsRange = &retainRepoVersionsRange
	return r
}

// Content Unit referenced by HREF
func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest) WithContent(withContent string) RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest {
	r.withContent = &withContent
	return r
}

// A list of fields to include in the response.
func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest) Fields(fields []string) RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest) ExcludeFields(excludeFields []string) RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest) Execute() (*PaginatedostreeOstreeRepositoryResponseList, *http.Response, error) {
	return r.ApiService.RepositoriesOstreeOstreeListExecute(r)
}

/*
RepositoriesOstreeOstreeList List ostree repositorys

A ViewSet class for OSTree repositories.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest
*/
func (a *RepositoriesOstreeAPIService) RepositoriesOstreeOstreeList(ctx context.Context) RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest {
	return RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedostreeOstreeRepositoryResponseList
func (a *RepositoriesOstreeAPIService) RepositoriesOstreeOstreeListExecute(r RepositoriesOstreeAPIRepositoriesOstreeOstreeListRequest) (*PaginatedostreeOstreeRepositoryResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedostreeOstreeRepositoryResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesOstreeAPIService.RepositoriesOstreeOstreeList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/repositories/ostree/ostree/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.latestWithContent != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "latest_with_content", r.latestWithContent, "")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.nameContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__contains", r.nameContains, "")
	}
	if r.nameIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__icontains", r.nameIcontains, "")
	}
	if r.nameIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__in", r.nameIn, "csv")
	}
	if r.nameStartswith != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__startswith", r.nameStartswith, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.pulpLabelSelect != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_label_select", r.pulpLabelSelect, "")
	}
	if r.remote != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "remote", r.remote, "")
	}
	if r.retainRepoVersions != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions", r.retainRepoVersions, "")
	}
	if r.retainRepoVersionsGt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__gt", r.retainRepoVersionsGt, "")
	}
	if r.retainRepoVersionsGte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__gte", r.retainRepoVersionsGte, "")
	}
	if r.retainRepoVersionsIsnull != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__isnull", r.retainRepoVersionsIsnull, "")
	}
	if r.retainRepoVersionsLt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__lt", r.retainRepoVersionsLt, "")
	}
	if r.retainRepoVersionsLte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__lte", r.retainRepoVersionsLte, "")
	}
	if r.retainRepoVersionsNe != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__ne", r.retainRepoVersionsNe, "")
	}
	if r.retainRepoVersionsRange != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__range", r.retainRepoVersionsRange, "csv")
	}
	if r.withContent != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "with_content", r.withContent, "")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesOstreeAPIRepositoriesOstreeOstreeModifyRequest struct {
	ctx context.Context
	ApiService *RepositoriesOstreeAPIService
	ostreeOstreeRepositoryHref string
	repositoryAddRemoveContent *RepositoryAddRemoveContent
}

func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeModifyRequest) RepositoryAddRemoveContent(repositoryAddRemoveContent RepositoryAddRemoveContent) RepositoriesOstreeAPIRepositoriesOstreeOstreeModifyRequest {
	r.repositoryAddRemoveContent = &repositoryAddRemoveContent
	return r
}

func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeModifyRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesOstreeOstreeModifyExecute(r)
}

/*
RepositoriesOstreeOstreeModify Modify repository

Trigger an asynchronous task to modify content.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ostreeOstreeRepositoryHref
 @return RepositoriesOstreeAPIRepositoriesOstreeOstreeModifyRequest
*/
func (a *RepositoriesOstreeAPIService) RepositoriesOstreeOstreeModify(ctx context.Context, ostreeOstreeRepositoryHref string) RepositoriesOstreeAPIRepositoriesOstreeOstreeModifyRequest {
	return RepositoriesOstreeAPIRepositoriesOstreeOstreeModifyRequest{
		ApiService: a,
		ctx: ctx,
		ostreeOstreeRepositoryHref: ostreeOstreeRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesOstreeAPIService) RepositoriesOstreeOstreeModifyExecute(r RepositoriesOstreeAPIRepositoriesOstreeOstreeModifyRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesOstreeAPIService.RepositoriesOstreeOstreeModify")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ostree_ostree_repository_href}modify/"
	localVarPath = strings.Replace(localVarPath, "{"+"ostree_ostree_repository_href"+"}", parameterValueToString(r.ostreeOstreeRepositoryHref, "ostreeOstreeRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.repositoryAddRemoveContent == nil {
		return localVarReturnValue, nil, reportError("repositoryAddRemoveContent is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.repositoryAddRemoveContent
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesOstreeAPIRepositoriesOstreeOstreePartialUpdateRequest struct {
	ctx context.Context
	ApiService *RepositoriesOstreeAPIService
	ostreeOstreeRepositoryHref string
	patchedostreeOstreeRepository *PatchedostreeOstreeRepository
}

func (r RepositoriesOstreeAPIRepositoriesOstreeOstreePartialUpdateRequest) PatchedostreeOstreeRepository(patchedostreeOstreeRepository PatchedostreeOstreeRepository) RepositoriesOstreeAPIRepositoriesOstreeOstreePartialUpdateRequest {
	r.patchedostreeOstreeRepository = &patchedostreeOstreeRepository
	return r
}

func (r RepositoriesOstreeAPIRepositoriesOstreeOstreePartialUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesOstreeOstreePartialUpdateExecute(r)
}

/*
RepositoriesOstreeOstreePartialUpdate Update an ostree repository

Trigger an asynchronous partial update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ostreeOstreeRepositoryHref
 @return RepositoriesOstreeAPIRepositoriesOstreeOstreePartialUpdateRequest
*/
func (a *RepositoriesOstreeAPIService) RepositoriesOstreeOstreePartialUpdate(ctx context.Context, ostreeOstreeRepositoryHref string) RepositoriesOstreeAPIRepositoriesOstreeOstreePartialUpdateRequest {
	return RepositoriesOstreeAPIRepositoriesOstreeOstreePartialUpdateRequest{
		ApiService: a,
		ctx: ctx,
		ostreeOstreeRepositoryHref: ostreeOstreeRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesOstreeAPIService) RepositoriesOstreeOstreePartialUpdateExecute(r RepositoriesOstreeAPIRepositoriesOstreeOstreePartialUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesOstreeAPIService.RepositoriesOstreeOstreePartialUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ostree_ostree_repository_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"ostree_ostree_repository_href"+"}", parameterValueToString(r.ostreeOstreeRepositoryHref, "ostreeOstreeRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.patchedostreeOstreeRepository == nil {
		return localVarReturnValue, nil, reportError("patchedostreeOstreeRepository is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.patchedostreeOstreeRepository
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesOstreeAPIRepositoriesOstreeOstreeReadRequest struct {
	ctx context.Context
	ApiService *RepositoriesOstreeAPIService
	ostreeOstreeRepositoryHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeReadRequest) Fields(fields []string) RepositoriesOstreeAPIRepositoriesOstreeOstreeReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeReadRequest) ExcludeFields(excludeFields []string) RepositoriesOstreeAPIRepositoriesOstreeOstreeReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeReadRequest) Execute() (*OstreeOstreeRepositoryResponse, *http.Response, error) {
	return r.ApiService.RepositoriesOstreeOstreeReadExecute(r)
}

/*
RepositoriesOstreeOstreeRead Inspect an ostree repository

A ViewSet class for OSTree repositories.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ostreeOstreeRepositoryHref
 @return RepositoriesOstreeAPIRepositoriesOstreeOstreeReadRequest
*/
func (a *RepositoriesOstreeAPIService) RepositoriesOstreeOstreeRead(ctx context.Context, ostreeOstreeRepositoryHref string) RepositoriesOstreeAPIRepositoriesOstreeOstreeReadRequest {
	return RepositoriesOstreeAPIRepositoriesOstreeOstreeReadRequest{
		ApiService: a,
		ctx: ctx,
		ostreeOstreeRepositoryHref: ostreeOstreeRepositoryHref,
	}
}

// Execute executes the request
//  @return OstreeOstreeRepositoryResponse
func (a *RepositoriesOstreeAPIService) RepositoriesOstreeOstreeReadExecute(r RepositoriesOstreeAPIRepositoriesOstreeOstreeReadRequest) (*OstreeOstreeRepositoryResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *OstreeOstreeRepositoryResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesOstreeAPIService.RepositoriesOstreeOstreeRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ostree_ostree_repository_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"ostree_ostree_repository_href"+"}", parameterValueToString(r.ostreeOstreeRepositoryHref, "ostreeOstreeRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesOstreeAPIRepositoriesOstreeOstreeSyncRequest struct {
	ctx context.Context
	ApiService *RepositoriesOstreeAPIService
	ostreeOstreeRepositoryHref string
	repositorySyncURL *RepositorySyncURL
}

func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeSyncRequest) RepositorySyncURL(repositorySyncURL RepositorySyncURL) RepositoriesOstreeAPIRepositoriesOstreeOstreeSyncRequest {
	r.repositorySyncURL = &repositorySyncURL
	return r
}

func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeSyncRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesOstreeOstreeSyncExecute(r)
}

/*
RepositoriesOstreeOstreeSync Sync from remote

Trigger an asynchronous task to sync content.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ostreeOstreeRepositoryHref
 @return RepositoriesOstreeAPIRepositoriesOstreeOstreeSyncRequest
*/
func (a *RepositoriesOstreeAPIService) RepositoriesOstreeOstreeSync(ctx context.Context, ostreeOstreeRepositoryHref string) RepositoriesOstreeAPIRepositoriesOstreeOstreeSyncRequest {
	return RepositoriesOstreeAPIRepositoriesOstreeOstreeSyncRequest{
		ApiService: a,
		ctx: ctx,
		ostreeOstreeRepositoryHref: ostreeOstreeRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesOstreeAPIService) RepositoriesOstreeOstreeSyncExecute(r RepositoriesOstreeAPIRepositoriesOstreeOstreeSyncRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesOstreeAPIService.RepositoriesOstreeOstreeSync")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ostree_ostree_repository_href}sync/"
	localVarPath = strings.Replace(localVarPath, "{"+"ostree_ostree_repository_href"+"}", parameterValueToString(r.ostreeOstreeRepositoryHref, "ostreeOstreeRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.repositorySyncURL == nil {
		return localVarReturnValue, nil, reportError("repositorySyncURL is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.repositorySyncURL
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesOstreeAPIRepositoriesOstreeOstreeUpdateRequest struct {
	ctx context.Context
	ApiService *RepositoriesOstreeAPIService
	ostreeOstreeRepositoryHref string
	ostreeOstreeRepository *OstreeOstreeRepository
}

func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeUpdateRequest) OstreeOstreeRepository(ostreeOstreeRepository OstreeOstreeRepository) RepositoriesOstreeAPIRepositoriesOstreeOstreeUpdateRequest {
	r.ostreeOstreeRepository = &ostreeOstreeRepository
	return r
}

func (r RepositoriesOstreeAPIRepositoriesOstreeOstreeUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesOstreeOstreeUpdateExecute(r)
}

/*
RepositoriesOstreeOstreeUpdate Update an ostree repository

Trigger an asynchronous update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ostreeOstreeRepositoryHref
 @return RepositoriesOstreeAPIRepositoriesOstreeOstreeUpdateRequest
*/
func (a *RepositoriesOstreeAPIService) RepositoriesOstreeOstreeUpdate(ctx context.Context, ostreeOstreeRepositoryHref string) RepositoriesOstreeAPIRepositoriesOstreeOstreeUpdateRequest {
	return RepositoriesOstreeAPIRepositoriesOstreeOstreeUpdateRequest{
		ApiService: a,
		ctx: ctx,
		ostreeOstreeRepositoryHref: ostreeOstreeRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesOstreeAPIService) RepositoriesOstreeOstreeUpdateExecute(r RepositoriesOstreeAPIRepositoriesOstreeOstreeUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesOstreeAPIService.RepositoriesOstreeOstreeUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ostree_ostree_repository_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"ostree_ostree_repository_href"+"}", parameterValueToString(r.ostreeOstreeRepositoryHref, "ostreeOstreeRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.ostreeOstreeRepository == nil {
		return localVarReturnValue, nil, reportError("ostreeOstreeRepository is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.ostreeOstreeRepository
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
