/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"os"
)

// checks if the CollectionOneShot type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &CollectionOneShot{}

// CollectionOneShot A serializer for the Collection One Shot Upload API.
type CollectionOneShot struct {
	// The Collection tarball.
	File *os.File `json:"file"`
	// An optional sha256 checksum of the uploaded file.
	Sha256 *string `json:"sha256,omitempty"`
	// The expected 'namespace' of the Collection to be verified against the metadata during import.
	ExpectedNamespace *string `json:"expected_namespace,omitempty"`
	// The expected 'name' of the Collection to be verified against the metadata during import.
	ExpectedName *string `json:"expected_name,omitempty"`
	// The expected version of the Collection to be verified against the metadata during import.
	ExpectedVersion *string `json:"expected_version,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _CollectionOneShot CollectionOneShot

// NewCollectionOneShot instantiates a new CollectionOneShot object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCollectionOneShot(file *os.File) *CollectionOneShot {
	this := CollectionOneShot{}
	this.File = file
	return &this
}

// NewCollectionOneShotWithDefaults instantiates a new CollectionOneShot object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCollectionOneShotWithDefaults() *CollectionOneShot {
	this := CollectionOneShot{}
	return &this
}

// GetFile returns the File field value
func (o *CollectionOneShot) GetFile() *os.File {
	if o == nil {
		var ret *os.File
		return ret
	}

	return o.File
}

// GetFileOk returns a tuple with the File field value
// and a boolean to check if the value has been set.
func (o *CollectionOneShot) GetFileOk() (**os.File, bool) {
	if o == nil {
		return nil, false
	}
	return &o.File, true
}

// SetFile sets field value
func (o *CollectionOneShot) SetFile(v *os.File) {
	o.File = v
}

// GetSha256 returns the Sha256 field value if set, zero value otherwise.
func (o *CollectionOneShot) GetSha256() string {
	if o == nil || IsNil(o.Sha256) {
		var ret string
		return ret
	}
	return *o.Sha256
}

// GetSha256Ok returns a tuple with the Sha256 field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CollectionOneShot) GetSha256Ok() (*string, bool) {
	if o == nil || IsNil(o.Sha256) {
		return nil, false
	}
	return o.Sha256, true
}

// HasSha256 returns a boolean if a field has been set.
func (o *CollectionOneShot) HasSha256() bool {
	if o != nil && !IsNil(o.Sha256) {
		return true
	}

	return false
}

// SetSha256 gets a reference to the given string and assigns it to the Sha256 field.
func (o *CollectionOneShot) SetSha256(v string) {
	o.Sha256 = &v
}

// GetExpectedNamespace returns the ExpectedNamespace field value if set, zero value otherwise.
func (o *CollectionOneShot) GetExpectedNamespace() string {
	if o == nil || IsNil(o.ExpectedNamespace) {
		var ret string
		return ret
	}
	return *o.ExpectedNamespace
}

// GetExpectedNamespaceOk returns a tuple with the ExpectedNamespace field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CollectionOneShot) GetExpectedNamespaceOk() (*string, bool) {
	if o == nil || IsNil(o.ExpectedNamespace) {
		return nil, false
	}
	return o.ExpectedNamespace, true
}

// HasExpectedNamespace returns a boolean if a field has been set.
func (o *CollectionOneShot) HasExpectedNamespace() bool {
	if o != nil && !IsNil(o.ExpectedNamespace) {
		return true
	}

	return false
}

// SetExpectedNamespace gets a reference to the given string and assigns it to the ExpectedNamespace field.
func (o *CollectionOneShot) SetExpectedNamespace(v string) {
	o.ExpectedNamespace = &v
}

// GetExpectedName returns the ExpectedName field value if set, zero value otherwise.
func (o *CollectionOneShot) GetExpectedName() string {
	if o == nil || IsNil(o.ExpectedName) {
		var ret string
		return ret
	}
	return *o.ExpectedName
}

// GetExpectedNameOk returns a tuple with the ExpectedName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CollectionOneShot) GetExpectedNameOk() (*string, bool) {
	if o == nil || IsNil(o.ExpectedName) {
		return nil, false
	}
	return o.ExpectedName, true
}

// HasExpectedName returns a boolean if a field has been set.
func (o *CollectionOneShot) HasExpectedName() bool {
	if o != nil && !IsNil(o.ExpectedName) {
		return true
	}

	return false
}

// SetExpectedName gets a reference to the given string and assigns it to the ExpectedName field.
func (o *CollectionOneShot) SetExpectedName(v string) {
	o.ExpectedName = &v
}

// GetExpectedVersion returns the ExpectedVersion field value if set, zero value otherwise.
func (o *CollectionOneShot) GetExpectedVersion() string {
	if o == nil || IsNil(o.ExpectedVersion) {
		var ret string
		return ret
	}
	return *o.ExpectedVersion
}

// GetExpectedVersionOk returns a tuple with the ExpectedVersion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CollectionOneShot) GetExpectedVersionOk() (*string, bool) {
	if o == nil || IsNil(o.ExpectedVersion) {
		return nil, false
	}
	return o.ExpectedVersion, true
}

// HasExpectedVersion returns a boolean if a field has been set.
func (o *CollectionOneShot) HasExpectedVersion() bool {
	if o != nil && !IsNil(o.ExpectedVersion) {
		return true
	}

	return false
}

// SetExpectedVersion gets a reference to the given string and assigns it to the ExpectedVersion field.
func (o *CollectionOneShot) SetExpectedVersion(v string) {
	o.ExpectedVersion = &v
}

func (o CollectionOneShot) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o CollectionOneShot) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["file"] = o.File
	if !IsNil(o.Sha256) {
		toSerialize["sha256"] = o.Sha256
	}
	if !IsNil(o.ExpectedNamespace) {
		toSerialize["expected_namespace"] = o.ExpectedNamespace
	}
	if !IsNil(o.ExpectedName) {
		toSerialize["expected_name"] = o.ExpectedName
	}
	if !IsNil(o.ExpectedVersion) {
		toSerialize["expected_version"] = o.ExpectedVersion
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *CollectionOneShot) UnmarshalJSON(bytes []byte) (err error) {
	varCollectionOneShot := _CollectionOneShot{}

	if err = json.Unmarshal(bytes, &varCollectionOneShot); err == nil {
		*o = CollectionOneShot(varCollectionOneShot)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "file")
		delete(additionalProperties, "sha256")
		delete(additionalProperties, "expected_namespace")
		delete(additionalProperties, "expected_name")
		delete(additionalProperties, "expected_version")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableCollectionOneShot struct {
	value *CollectionOneShot
	isSet bool
}

func (v NullableCollectionOneShot) Get() *CollectionOneShot {
	return v.value
}

func (v *NullableCollectionOneShot) Set(val *CollectionOneShot) {
	v.value = val
	v.isSet = true
}

func (v NullableCollectionOneShot) IsSet() bool {
	return v.isSet
}

func (v *NullableCollectionOneShot) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCollectionOneShot(val *CollectionOneShot) *NullableCollectionOneShot {
	return &NullableCollectionOneShot{value: val, isSet: true}
}

func (v NullableCollectionOneShot) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCollectionOneShot) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


