/*******************************************************************************
 * Copyright (C) 2022 Intel Corporation
 *
 * SPDX-License-Identifier: MIT
 ******************************************************************************/

#ifndef QPL_TEST_HUFFMAN_TABLE_HPP
#define QPL_TEST_HUFFMAN_TABLE_HPP

#include <cstdint>
#include "qpl/c_api/huffman_table.h"

namespace qpl::test
{
    static const uint32_t literals_match_table[286] = {
            0x69FBC, 0x7FF70, 0x69FBD, 0x400E4, 0x60FCA,
            0x7FF71, 0x7FF72, 0x7FF73, 0x7FF74, 0x503D8,
            0x7FF75, 0x7FF76, 0x7FF77, 0x60FCB, 0x7FF78,
            0x7FF79, 0x7FF7A, 0x587D4, 0x60FCC, 0x7FF7B,
            0x7FF7C, 0x7FF7D, 0x7FF7E, 0x503D9, 0x3806C,
            0x7FF7F, 0x3806D, 0x73FA6, 0x7FF80, 0x73FA7,
            0x587D5, 0x7FF81, 0x7FF82, 0x503DA, 0x7FF83,
            0x481DA, 0x400E5, 0x7FF84, 0x587D6, 0x7FF85,
            0x7FF86, 0x7FF87, 0x7FF88, 0x400E6, 0x69FBE,
            0x7FF89, 0x7FF8A, 0x7FF8B, 0x7FF8C, 0x7FF8D,
            0x7FF8E, 0x73FA8, 0x69FBF, 0x7FF8F, 0x20008,
            0x7FF90, 0x7FF91, 0x7FF92, 0x73FA9, 0x7FF93,
            0x7FF94, 0x400E7, 0x503DB, 0x30032, 0x7FF95,
            0x587D7, 0x481DB, 0x481DC, 0x69FC0, 0x30033,
            0x73FAA, 0x7FF96, 0x69FC1, 0x60FCD, 0x7FF97,
            0x69FC2, 0x60FCE, 0x7FF98, 0x587D8, 0x69FC3,
            0x7FF99, 0x587D9, 0x7FF9A, 0x7FF9B, 0x7FF9C,
            0x481DD, 0x7FF9D, 0x503DC, 0x587DA, 0x481DE,
            0x10000, 0x400E8, 0x7FF9E, 0x60FCF, 0x7FF9F,
            0x60FD0, 0x587DB, 0x7FFA0, 0x481DF, 0x69FC4,
            0x503DD, 0x3806E, 0x481E0, 0x503DE, 0x7FFA1,
            0x73FAB, 0x481E1, 0x69FC5, 0x60FD1, 0x7FFA2,
            0x7FFA3, 0x7FFA4, 0x7FFA5, 0x400E9, 0x69FC6,
            0x7FFA6, 0x7FFA7, 0x503DF, 0x7FFA8, 0x7FFA9,
            0x60FD2, 0x7FFAA, 0x7FFAB, 0x7FFAC, 0x7FFAD,
            0x60FD3, 0x7FFAE, 0x7FFAF, 0x400EA, 0x587DC,
            0x481E2, 0x587DD, 0x60FD4, 0x73FAC, 0x7FFB0,
            0x7FFB1, 0x18002, 0x7FFB2, 0x481E3, 0x7FFB3,
            0x481E4, 0x73FAD, 0x7FFB4, 0x20009, 0x7FFB5,
            0x28016, 0x73FAE, 0x30034, 0x587DE, 0x7FFB6,
            0x7FFB7, 0x7FFB8, 0x30035, 0x7FFB9, 0x7FFBA,
            0x7FFBB, 0x28017, 0x7FFBC, 0x7FFBD, 0x3806F,
            0x587DF, 0x7FFBE, 0x7FFBF, 0x481E5, 0x69FC7,
            0x7FFC0, 0x7FFC1, 0x7FFC2, 0x69FC8, 0x7FFC3,
            0x503E0, 0x69FC9, 0x73FAF, 0x73FB0, 0x7FFC4,
            0x587E0, 0x7FFC5, 0x503E1, 0x7FFC6, 0x7FFC7,
            0x69FCA, 0x7FFC8, 0x7FFC9, 0x7FFCA, 0x69FCB,
            0x69FCC, 0x7FFCB, 0x7FFCC, 0x7FFCD, 0x73FB1,
            0x503E2, 0x7FFCE, 0x69FCD, 0x503E3, 0x7FFCF,
            0x587E1, 0x400EB, 0x7FFD0, 0x400EC, 0x38070,
            0x7FFD1, 0x7FFD2, 0x69FCE, 0x73FB2, 0x7FFD3,
            0x7FFD4, 0x18003, 0x7FFD5, 0x7FFD6, 0x503E4,
            0x7FFD7, 0x7FFD8, 0x7FFD9, 0x481E6, 0x7FFDA,
            0x7FFDB, 0x73FB3, 0x7FFDC, 0x7FFDD, 0x69FCF,
            0x481E7, 0x503E5, 0x503E6, 0x481E8, 0x7FFDE,
            0x7FFDF, 0x7FFE0, 0x73FB4, 0x38071, 0x73FB5,
            0x69FD0, 0x60FD5, 0x481E9, 0x2000A, 0x60FD6,
            0x7FFE1, 0x7FFE2, 0x7FFE3, 0x587E2, 0x503E7,
            0x7FFE4, 0x69FD1, 0x60FD7, 0x7FFE5, 0x7FFE6,
            0x587E3, 0x73FB6, 0x7FFE7, 0x503E8, 0x73FB7,
            0x7FFE8, 0x7FFE9, 0x69FD2, 0x28018, 0x587E4,
            0x7FFEA, 0x60FD8, 0x7FFEB, 0x481EA, 0x503E9,
            0x60FD9, 0x60FDA, 0x60FDB, 0x481EB, 0x60FDC,
            0x60FDD, 0x7FFEC, 0x7FFED, 0x7FFEE, 0x7FFEF,
            0x7FFF0, 0x7FFF1, 0x7FFF2, 0x7FFF3, 0x7FFF4,
            0x7FFF5, 0x7FFF6, 0x7FFF7, 0x7FFF8, 0x7FFF9,
            0x7FFFA, 0x7FFFB, 0x7FFFC, 0x7FFFD, 0x7FFFE,
            0x7FFFF};

    static const uint32_t offsets_table[30] = {
            0x400FC, 0x73FFA, 0x503FE, 0x3003C,
            0x73FFB, 0x400FD, 0x18002, 0x69FFC,
            0x2000C, 0x18003, 0x587FE, 0x7FFF8,
            0x481FE, 0x18004, 0x2801C, 0x18005,
            0x7FFF9, 0x2000D, 0x3003D, 0x400FE,
            0x3807C, 0x2801D, 0x10000, 0x3807D,
            0x7FFFA, 0x7FFFB, 0x7FFFC, 0x7FFFD,
            0x7FFFE, 0x7FFFF};

    static const uint8_t deflate_header[218] = {
            0xEC, 0xFD, 0x0B, 0xA0, 0xA5, 0xE9,
            0x9E, 0xE6, 0x89, 0xB4, 0xDE, 0xE5,
            0x92, 0x28, 0x9C, 0x72, 0xC9, 0x65,
            0x8D, 0x39, 0xA4, 0xD8, 0x8E, 0xCB,
            0x6E, 0xD7, 0x69, 0x7F, 0x0C, 0x3B,
            0x3F, 0x27, 0xA2, 0xBF, 0xD1, 0xA5,
            0xCB, 0x69, 0x07, 0x21, 0x4F, 0xFC,
            0xB6, 0x52, 0x47, 0x74, 0xAE, 0x48,
            0x13, 0x5D, 0x2E, 0xBB, 0x49, 0xCA,
            0xA5, 0xD8, 0x27, 0x4E, 0x0D, 0x8F,
            0x10, 0xE3, 0xEF, 0x9D, 0xEF, 0xE0,
            0xC3, 0xCB, 0x3A, 0x44, 0xA3, 0x65,
            0xCF, 0x38, 0x92, 0x46, 0x37, 0x26,
            0x75, 0x3A, 0xDB, 0x5E, 0xF4, 0xF0,
            0x90, 0x08, 0x86, 0x8E, 0xCC, 0xC0,
            0xAC, 0xE9, 0x8A, 0x7F, 0xE1, 0xA4,
            0x2E, 0xCE, 0xC8, 0xA1, 0xDF, 0xA3,
            0x44, 0x56, 0x55, 0x54, 0xB9, 0xDF,
            0xEF, 0xF6, 0xE4, 0x37, 0xFB, 0xE9,
            0xFF, 0x73, 0xC4, 0xF3, 0x3E, 0xFE,
            0xDF, 0x5E, 0xEF, 0x6F, 0xB9, 0x02,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00};

    [[nodiscard]] qpl_status fill_compression_table(qpl_huffman_table_t table_ptr);
}

#endif //QPL_TEST_HUFFMAN_TABLE_HPP
