﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

#nullable enable

using System.Collections.Generic;
using Microsoft.CodeAnalysis.Host;

namespace Microsoft.CodeAnalysis.Execution
{
    /// <summary>
    /// This lets consumer to get to inner temporary storage that references use
    /// as its shadow copy storage
    /// </summary>
    internal interface ISupportTemporaryStorage
    {
        IEnumerable<ITemporaryStreamStorage>? GetStorages();
    }
}
