import React from 'react';
import PropTypes from 'prop-types';

const UilEnvelopeMinus = (props) => {
  const { color, size, ...otherProps } = props
  return React.createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React.createElement('path', {
    d: 'M21,8a1,1,0,0,0-1,1v8a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V7.41l5.88,5.88a3,3,0,0,0,4.24,0l3.59-3.58a1,1,0,0,0-1.42-1.42l-3.58,3.59a1,1,0,0,1-1.42,0L5.41,6H13a1,1,0,0,0,0-2H5A3,3,0,0,0,2,7V17a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V9A1,1,0,0,0,21,8ZM17,6h4a1,1,0,0,0,0-2H17a1,1,0,0,0,0,2Z'
  }));
};

UilEnvelopeMinus.propTypes = {
  color: PropTypes.string,
  size: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
};

UilEnvelopeMinus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

export default UilEnvelopeMinus;