"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImportAppender = void 0;
const tsdoc_1 = require("@microsoft/tsdoc");
const Utilities_1 = require("../../utils/Utilities");
const BoldTextAppender_1 = require("./BoldTextAppender");
class ImportAppender {
    constructor(configuration) {
        this._configuration = configuration;
        this._boldTextAppender = new BoldTextAppender_1.BoldTextAppender(configuration);
    }
    append(output, apiItem) {
        if (!this._isApiDeclaredItem(apiItem)) {
            return;
        }
        const code = this._importFromItem(apiItem);
        if (!code) {
            return;
        }
        this._boldTextAppender.append(output, 'Import');
        output.appendNode(new tsdoc_1.DocFencedCode({
            configuration: this._configuration,
            code,
            language: 'typescript'
        }));
    }
    _isApiDeclaredItem(apiItem) {
        const node = apiItem;
        return node && node.buildExcerpt !== undefined;
    }
    _importFromItem(apiItem) {
        const packageItem = apiItem.getAssociatedPackage();
        if (!packageItem) {
            return;
        }
        return apiItem.getScopedNameWithinPackage()
            .split('.')
            .map((value, index, all) => {
            if (index === 0) {
                return this._generateImport(value, packageItem.displayName);
            }
            return this._generateDestruct(value, all[index - 1]);
        })
            .join('\n');
    }
    _generateDestruct(path, displayName) {
        const escapedPath = Utilities_1.Utilities.getImportName(path);
        const escapedName = Utilities_1.Utilities.getImportName(displayName);
        return `const { ${escapedPath} } = ${escapedName};`;
    }
    _generateImport(path, displayName) {
        const escapedPath = Utilities_1.Utilities.getImportName(path);
        return `import { ${escapedPath} } from '${displayName}';`;
    }
}
exports.ImportAppender = ImportAppender;
;
//# sourceMappingURL=ImportAppender.js.map