"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SignatureAppender = void 0;
const tsdoc_1 = require("@microsoft/tsdoc");
const BoldTextAppender_1 = require("./BoldTextAppender");
class SignatureAppender {
    constructor(configuration) {
        this._configuration = configuration;
        this._boldTextAppender = new BoldTextAppender_1.BoldTextAppender(configuration);
    }
    append(output, apiItem) {
        if (!this._isApiDeclaredItem(apiItem)) {
            return;
        }
        if (apiItem.excerpt.text.length <= 0) {
            return;
        }
        const configuration = this._configuration;
        this._boldTextAppender.append(output, 'Signature');
        output.appendNode(new tsdoc_1.DocFencedCode({
            configuration,
            code: apiItem.getExcerptWithModifiers(),
            language: 'typescript'
        }));
    }
    _isApiDeclaredItem(apiItem) {
        const node = apiItem;
        return node && node.buildExcerpt !== undefined;
    }
}
exports.SignatureAppender = SignatureAppender;
;
//# sourceMappingURL=SignatureAppender.js.map