"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DocFrontMatter = void 0;
const GrafanaDocNode_1 = require("./GrafanaDocNode");
class DocFrontMatter extends GrafanaDocNode_1.GrafanaDocNode {
    constructor(parameters) {
        super(parameters);
        this._title = this._titleFromItem(parameters.apiItem);
        this._keywords = this._keywordsFromItem(parameters.apiItem);
        this._draft = parameters.draft || false;
    }
    get kind() {
        return DocFrontMatter.name;
    }
    writeTo(writer) {
        const keywords = this._keywords.map((kw) => `"${kw}"`).join(',');
        writer.writeLine(DocFrontMatter._tag);
        writer.writeLine('# -----------------------------------------------------------------------');
        writer.writeLine('# Do not edit this file. It is automatically generated by API Documenter.');
        writer.writeLine('# -----------------------------------------------------------------------');
        writer.writeLine(`title = "${this._title}"`);
        writer.writeLine(`keywords = [${keywords}]`);
        writer.writeLine(`type = "${DocFrontMatter._type}"`);
        writer.writeLine('disable_edit_link = true');
        if (this._draft) {
            writer.writeLine(`draft = ${this._draft}`);
        }
        writer.writeLine(DocFrontMatter._tag);
    }
    _titleFromItem(apiItem) {
        if (apiItem.kind === "Model" /* Model */) {
            return 'API Reference';
        }
        return apiItem.displayName;
    }
    _keywordsFromItem(apiItem) {
        const keywords = ['grafana', 'documentation', 'sdk'];
        const packageItem = apiItem.getAssociatedPackage();
        if (packageItem) {
            keywords.push(packageItem.name);
        }
        return keywords;
    }
}
exports.DocFrontMatter = DocFrontMatter;
DocFrontMatter._tag = '+++';
DocFrontMatter._type = 'docs';
//# sourceMappingURL=DocFrontMatter.js.map