/// <reference types="node" />
import type * as http from 'http';
import type * as https from 'https';
import { CollectorExporterBase } from '../../CollectorExporterBase';
import { CollectorExporterNodeConfigBase, CompressionAlgorithm } from './types';
import * as collectorTypes from '../../types';
/**
 * Collector Metric Exporter abstract base class
 */
export declare abstract class CollectorExporterNodeBase<ExportItem, ServiceRequest> extends CollectorExporterBase<CollectorExporterNodeConfigBase, ExportItem, ServiceRequest> {
    DEFAULT_HEADERS: Record<string, string>;
    headers: Record<string, string>;
    agent: http.Agent | https.Agent | undefined;
    compression: CompressionAlgorithm;
    constructor(config?: CollectorExporterNodeConfigBase);
    onInit(_config: CollectorExporterNodeConfigBase): void;
    send(objects: ExportItem[], onSuccess: () => void, onError: (error: collectorTypes.CollectorExporterError) => void): void;
    onShutdown(): void;
}
//# sourceMappingURL=CollectorExporterNodeBase.d.ts.map