"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.debug = void 0;
var tslib_1 = require("tslib");
var callsite_1 = tslib_1.__importDefault(require("callsite"));
var module_1 = tslib_1.__importDefault(require("module"));
var debugger_1 = require("./debugger");
var initialised = false;
function debug(options) {
    if (options === void 0) { options = {}; }
    if (options.enabled) {
        var _a = callsite_1.default(), caller = _a[1];
        if (!initialised) {
            init(options, caller);
            initialised = true;
        }
    }
}
exports.debug = debug;
function init(options, caller) {
    var d = new debugger_1.DebuggerΩ(options);
    Object.keys(require.cache).forEach(function (requirePath) {
        var module = require.cache[requirePath];
        var isCaller = requirePath === caller.getFileName();
        if (module && !isCaller && d.shouldWrap(requirePath)) {
            d.wrap(module.exports);
        }
    });
    var original = module_1.default.Module.prototype.require;
    var debugRequire = function (id) {
        var Module = module_1.default.Module;
        var requirePath = Module._resolveFilename(id, this);
        var module = original.apply(this, [id]);
        if (module && d.shouldWrap(requirePath)) {
            return d.wrap(module);
        }
        return module;
    };
    module_1.default.Module.prototype.require = Object.assign(debugRequire, original);
}
//# sourceMappingURL=debug.js.map