'use strict';

function spacerStr (len) {
    var str = '';
    for(var i = 0; i < len; i += 1) {
        str += ' ';
    }
    return str;
}

function StringWriter (config) {
    this.lines = [];
    this.lineSeparator = config.lineSeparator;
    this.regex = new RegExp(this.lineSeparator, 'g');
    this.spacer = spacerStr(config.outputOffset);
}

StringWriter.prototype.write = function (str) {
    this.lines.push(this.spacer + str.replace(this.regex, this.lineSeparator + this.spacer));
};

StringWriter.prototype.toString = function () {
    var str = this.lines.join(this.lineSeparator);
    this.lines.length = 0;
    return str;
};

module.exports = StringWriter;
