import "core-js/modules/es.array.slice.js";
import "core-js/modules/es.object.freeze.js";

var _templateObject, _templateObject2, _templateObject3, _templateObject4, _templateObject5;

import "regenerator-runtime/runtime.js";

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _taggedTemplateLiteral(strings, raw) { if (!raw) { raw = strings.slice(0); } return Object.freeze(Object.defineProperties(strings, { raw: { value: Object.freeze(raw) } })); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

import "core-js/modules/es.promise.js";
import "core-js/modules/es.object.to-string.js";
import "core-js/modules/es.object.keys.js";
import "core-js/modules/es.function.name.js";
import "core-js/modules/es.object.assign.js";
import "core-js/modules/es.array.includes.js";
import "core-js/modules/es.symbol.js";
import "core-js/modules/es.symbol.description.js";
import "core-js/modules/es.array.concat.js";
import deprecate from 'util-deprecate';
import dedent from 'ts-dedent';
import global from 'global';
import { SynchronousPromise } from 'synchronous-promise';
import Events, { IGNORED_EXCEPTION } from '@storybook/core-events';
import { logger } from '@storybook/client-logger';
import { addons } from '@storybook/addons';
import { StoryStore } from '@storybook/store';
import { UrlStore } from './UrlStore';
import { WebView } from './WebView';
var globalWindow = global.window,
    AbortController = global.AbortController,
    fetch = global.fetch;

function focusInInput(event) {
  var target = event.target;
  return /input|textarea/i.test(target.tagName) || target.getAttribute('contenteditable') !== null;
}

function createController() {
  if (AbortController) return new AbortController(); // Polyfill for IE11

  return {
    signal: {
      aborted: false
    },
    abort: function abort() {
      this.signal.aborted = true;
    }
  };
}

var STORY_INDEX_PATH = './stories.json';
export var PreviewWeb = /*#__PURE__*/function () {
  function PreviewWeb() {
    var _global$FEATURES,
        _this = this;

    _classCallCheck(this, PreviewWeb);

    this.channel = void 0;
    this.serverChannel = void 0;
    this.urlStore = void 0;
    this.storyStore = void 0;
    this.view = void 0;
    this.getStoryIndex = void 0;
    this.importFn = void 0;
    this.renderToDOM = void 0;
    this.previewEntryError = void 0;
    this.previousSelection = void 0;
    this.previousStory = void 0;
    this.previousCleanup = void 0;
    this.abortController = void 0;
    this.disableKeyListeners = void 0;
    this.channel = addons.getChannel();

    if ((_global$FEATURES = global.FEATURES) !== null && _global$FEATURES !== void 0 && _global$FEATURES.storyStoreV7 && addons.hasServerChannel()) {
      this.serverChannel = addons.getServerChannel();
    }

    this.view = new WebView();
    this.urlStore = new UrlStore();
    this.storyStore = new StoryStore(); // Add deprecated APIs for back-compat
    // @ts-ignore

    this.storyStore.getSelection = deprecate(function () {
      return _this.urlStore.selection;
    }, dedent(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n        `__STORYBOOK_STORY_STORE__.getSelection()` is deprecated and will be removed in 7.0.\n  \n        To get the current selection, use the `useStoryContext()` hook from `@storybook/addons`.\n      "], ["\n        \\`__STORYBOOK_STORY_STORE__.getSelection()\\` is deprecated and will be removed in 7.0.\n  \n        To get the current selection, use the \\`useStoryContext()\\` hook from \\`@storybook/addons\\`.\n      "]))));
  } // INITIALIZATION
  // NOTE: the reason that the preview and store's initialization code is written in a promise
  // style and not `async-await`, and the use of `SynchronousPromise`s is in order to allow
  // storyshots to immediately call `raw()` on the store without waiting for a later tick.
  // (Even simple things like `Promise.resolve()` and `await` involve the callback happening
  // in the next promise "tick").
  // See the comment in `storyshots-core/src/api/index.ts` for more detail.


  _createClass(PreviewWeb, [{
    key: "initialize",
    value: function initialize(_ref) {
      var _this2 = this;

      var getStoryIndex = _ref.getStoryIndex,
          importFn = _ref.importFn,
          getProjectAnnotations = _ref.getProjectAnnotations;
      // We save these two on initialization in case `getProjectAnnotations` errors,
      // in which case we may need them later when we recover.
      this.getStoryIndex = getStoryIndex;
      this.importFn = importFn;
      this.setupListeners();
      return this.getProjectAnnotationsOrRenderError(getProjectAnnotations).then(function (projectAnnotations) {
        return _this2.initializeWithProjectAnnotations(projectAnnotations);
      });
    }
  }, {
    key: "setupListeners",
    value: function setupListeners() {
      var _this$serverChannel;

      globalWindow.onkeydown = this.onKeydown.bind(this);
      (_this$serverChannel = this.serverChannel) === null || _this$serverChannel === void 0 ? void 0 : _this$serverChannel.on(Events.STORY_INDEX_INVALIDATED, this.onStoryIndexChanged.bind(this));
      this.channel.on(Events.SET_CURRENT_STORY, this.onSetCurrentStory.bind(this));
      this.channel.on(Events.UPDATE_QUERY_PARAMS, this.onUpdateQueryParams.bind(this));
      this.channel.on(Events.UPDATE_GLOBALS, this.onUpdateGlobals.bind(this));
      this.channel.on(Events.UPDATE_STORY_ARGS, this.onUpdateArgs.bind(this));
      this.channel.on(Events.RESET_STORY_ARGS, this.onResetArgs.bind(this));
    }
  }, {
    key: "getProjectAnnotationsOrRenderError",
    value: function getProjectAnnotationsOrRenderError(getProjectAnnotations) {
      var _this3 = this;

      return SynchronousPromise.resolve().then(getProjectAnnotations).then(function (projectAnnotations) {
        _this3.renderToDOM = projectAnnotations.renderToDOM;

        if (!_this3.renderToDOM) {
          throw new Error(dedent(_templateObject2 || (_templateObject2 = _taggedTemplateLiteral(["\n            Expected your framework's preset to export a `renderToDOM` field.\n\n            Perhaps it needs to be upgraded for Storybook 6.4?\n\n            More info: https://github.com/storybookjs/storybook/blob/next/MIGRATION.md#mainjs-framework-field          \n          "], ["\n            Expected your framework's preset to export a \\`renderToDOM\\` field.\n\n            Perhaps it needs to be upgraded for Storybook 6.4?\n\n            More info: https://github.com/storybookjs/storybook/blob/next/MIGRATION.md#mainjs-framework-field          \n          "]))));
        }

        return projectAnnotations;
      }).catch(function (err) {
        // This is an error extracting the projectAnnotations (i.e. evaluating the previewEntries) and
        // needs to be show to the user as a simple error
        _this3.renderPreviewEntryError('Error reading preview.js:', err);

        throw err;
      });
    } // If initialization gets as far as project annotations, this function runs.

  }, {
    key: "initializeWithProjectAnnotations",
    value: function initializeWithProjectAnnotations(projectAnnotations) {
      var _global$FEATURES2,
          _this4 = this;

      this.storyStore.setProjectAnnotations(projectAnnotations);
      this.setInitialGlobals();
      var storyIndexPromise;

      if ((_global$FEATURES2 = global.FEATURES) !== null && _global$FEATURES2 !== void 0 && _global$FEATURES2.storyStoreV7) {
        storyIndexPromise = this.getStoryIndexFromServer();
      } else {
        if (!this.getStoryIndex) {
          throw new Error('No `getStoryIndex` passed defined in v6 mode');
        }

        storyIndexPromise = SynchronousPromise.resolve().then(this.getStoryIndex);
      }

      return storyIndexPromise.then(function (storyIndex) {
        return _this4.initializeWithStoryIndex(storyIndex);
      }).catch(function (err) {
        _this4.renderPreviewEntryError('Error loading story index:', err);

        throw err;
      });
    }
  }, {
    key: "setInitialGlobals",
    value: function () {
      var _setInitialGlobals = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
        var _ref2, globals;

        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _ref2 = this.urlStore.selectionSpecifier || {}, globals = _ref2.globals;

                if (globals) {
                  this.storyStore.globals.updateFromPersisted(globals);
                }

                this.emitGlobals();

              case 3:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function setInitialGlobals() {
        return _setInitialGlobals.apply(this, arguments);
      }

      return setInitialGlobals;
    }()
  }, {
    key: "emitGlobals",
    value: function emitGlobals() {
      this.channel.emit(Events.SET_GLOBALS, {
        globals: this.storyStore.globals.get() || {},
        globalTypes: this.storyStore.projectAnnotations.globalTypes || {}
      });
    }
  }, {
    key: "getStoryIndexFromServer",
    value: function () {
      var _getStoryIndexFromServer = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
        var result;
        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                _context2.next = 2;
                return fetch(STORY_INDEX_PATH);

              case 2:
                result = _context2.sent;

                if (!(result.status === 200)) {
                  _context2.next = 5;
                  break;
                }

                return _context2.abrupt("return", result.json());

              case 5:
                _context2.t0 = Error;
                _context2.next = 8;
                return result.text();

              case 8:
                _context2.t1 = _context2.sent;
                throw new _context2.t0(_context2.t1);

              case 10:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2);
      }));

      function getStoryIndexFromServer() {
        return _getStoryIndexFromServer.apply(this, arguments);
      }

      return getStoryIndexFromServer;
    }() // If initialization gets as far as the story index, this function runs.

  }, {
    key: "initializeWithStoryIndex",
    value: function initializeWithStoryIndex(storyIndex) {
      var _global$FEATURES3,
          _this5 = this;

      return this.storyStore.initialize({
        storyIndex: storyIndex,
        importFn: this.importFn,
        cache: !((_global$FEATURES3 = global.FEATURES) !== null && _global$FEATURES3 !== void 0 && _global$FEATURES3.storyStoreV7)
      }).then(function () {
        var _global$FEATURES4;

        if (!((_global$FEATURES4 = global.FEATURES) !== null && _global$FEATURES4 !== void 0 && _global$FEATURES4.storyStoreV7)) {
          _this5.channel.emit(Events.SET_STORIES, _this5.storyStore.getSetStoriesPayload());
        }

        return _this5.selectSpecifiedStory();
      });
    } // Use the selection specifier to choose a story, then render it

  }, {
    key: "selectSpecifiedStory",
    value: function () {
      var _selectSpecifiedStory = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3() {
        var _this$urlStore$select, storySpecifier, viewMode, args, storyId;

        return regeneratorRuntime.wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                if (this.urlStore.selectionSpecifier) {
                  _context3.next = 3;
                  break;
                }

                this.renderMissingStory();
                return _context3.abrupt("return");

              case 3:
                _this$urlStore$select = this.urlStore.selectionSpecifier, storySpecifier = _this$urlStore$select.storySpecifier, viewMode = _this$urlStore$select.viewMode, args = _this$urlStore$select.args;
                storyId = this.storyStore.storyIndex.storyIdFromSpecifier(storySpecifier);

                if (storyId) {
                  _context3.next = 8;
                  break;
                }

                if (storySpecifier === '*') {
                  this.renderStoryLoadingException(storySpecifier, new Error(dedent(_templateObject3 || (_templateObject3 = _taggedTemplateLiteral(["\n            Couldn't find any stories in your Storybook.\n            - Please check your stories field of your main.js config.\n            - Also check the browser console and terminal for error messages.\n          "])))));
                } else {
                  this.renderStoryLoadingException(storySpecifier, new Error(dedent(_templateObject4 || (_templateObject4 = _taggedTemplateLiteral(["\n            Couldn't find story matching '", "'.\n            - Are you sure a story with that id exists?\n            - Please check your stories field of your main.js config.\n            - Also check the browser console and terminal for error messages.\n          "])), storySpecifier)));
                }

                return _context3.abrupt("return");

              case 8:
                this.urlStore.setSelection({
                  storyId: storyId,
                  viewMode: viewMode
                });
                this.channel.emit(Events.STORY_SPECIFIED, this.urlStore.selection);
                this.channel.emit(Events.CURRENT_STORY_WAS_SET, this.urlStore.selection);
                _context3.next = 13;
                return this.renderSelection({
                  persistedArgs: args
                });

              case 13:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3, this);
      }));

      function selectSpecifiedStory() {
        return _selectSpecifiedStory.apply(this, arguments);
      }

      return selectSpecifiedStory;
    }() // EVENT HANDLERS
    // This happens when a config file gets reloaded

  }, {
    key: "onGetProjectAnnotationsChanged",
    value: function () {
      var _onGetProjectAnnotationsChanged = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4(_ref3) {
        var getProjectAnnotations, projectAnnotations;
        return regeneratorRuntime.wrap(function _callee4$(_context4) {
          while (1) {
            switch (_context4.prev = _context4.next) {
              case 0:
                getProjectAnnotations = _ref3.getProjectAnnotations;
                delete this.previewEntryError;
                _context4.next = 4;
                return this.getProjectAnnotationsOrRenderError(getProjectAnnotations);

              case 4:
                projectAnnotations = _context4.sent;

                if (this.storyStore.projectAnnotations) {
                  _context4.next = 9;
                  break;
                }

                _context4.next = 8;
                return this.initializeWithProjectAnnotations(projectAnnotations);

              case 8:
                return _context4.abrupt("return");

              case 9:
                _context4.next = 11;
                return this.storyStore.setProjectAnnotations(projectAnnotations);

              case 11:
                this.emitGlobals();
                this.renderSelection();

              case 13:
              case "end":
                return _context4.stop();
            }
          }
        }, _callee4, this);
      }));

      function onGetProjectAnnotationsChanged(_x) {
        return _onGetProjectAnnotationsChanged.apply(this, arguments);
      }

      return onGetProjectAnnotationsChanged;
    }()
  }, {
    key: "onStoryIndexChanged",
    value: function () {
      var _onStoryIndexChanged = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee5() {
        var storyIndex;
        return regeneratorRuntime.wrap(function _callee5$(_context5) {
          while (1) {
            switch (_context5.prev = _context5.next) {
              case 0:
                delete this.previewEntryError;

                if (this.storyStore.projectAnnotations) {
                  _context5.next = 3;
                  break;
                }

                return _context5.abrupt("return");

              case 3:
                _context5.prev = 3;
                _context5.next = 6;
                return this.getStoryIndexFromServer();

              case 6:
                storyIndex = _context5.sent;

                if (this.storyStore.storyIndex) {
                  _context5.next = 10;
                  break;
                }

                _context5.next = 10;
                return this.initializeWithStoryIndex(storyIndex);

              case 10:
                _context5.next = 12;
                return this.onStoriesChanged({
                  storyIndex: storyIndex
                });

              case 12:
                _context5.next = 18;
                break;

              case 14:
                _context5.prev = 14;
                _context5.t0 = _context5["catch"](3);
                this.renderPreviewEntryError('Error loading story index:', _context5.t0);
                throw _context5.t0;

              case 18:
              case "end":
                return _context5.stop();
            }
          }
        }, _callee5, this, [[3, 14]]);
      }));

      function onStoryIndexChanged() {
        return _onStoryIndexChanged.apply(this, arguments);
      }

      return onStoryIndexChanged;
    }() // This happens when a glob gets HMR-ed

  }, {
    key: "onStoriesChanged",
    value: function () {
      var _onStoriesChanged = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee6(_ref4) {
        var _global$FEATURES5;

        var importFn, storyIndex;
        return regeneratorRuntime.wrap(function _callee6$(_context6) {
          while (1) {
            switch (_context6.prev = _context6.next) {
              case 0:
                importFn = _ref4.importFn, storyIndex = _ref4.storyIndex;
                _context6.next = 3;
                return this.storyStore.onStoriesChanged({
                  importFn: importFn,
                  storyIndex: storyIndex
                });

              case 3:
                if ((_global$FEATURES5 = global.FEATURES) !== null && _global$FEATURES5 !== void 0 && _global$FEATURES5.storyStoreV7) {
                  _context6.next = 10;
                  break;
                }

                _context6.t0 = this.channel;
                _context6.t1 = Events.SET_STORIES;
                _context6.next = 8;
                return this.storyStore.getSetStoriesPayload();

              case 8:
                _context6.t2 = _context6.sent;

                _context6.t0.emit.call(_context6.t0, _context6.t1, _context6.t2);

              case 10:
                if (!this.urlStore.selection) {
                  _context6.next = 15;
                  break;
                }

                _context6.next = 13;
                return this.renderSelection();

              case 13:
                _context6.next = 17;
                break;

              case 15:
                _context6.next = 17;
                return this.selectSpecifiedStory();

              case 17:
              case "end":
                return _context6.stop();
            }
          }
        }, _callee6, this);
      }));

      function onStoriesChanged(_x2) {
        return _onStoriesChanged.apply(this, arguments);
      }

      return onStoriesChanged;
    }()
  }, {
    key: "onKeydown",
    value: function onKeydown(event) {
      if (!this.disableKeyListeners && !focusInInput(event)) {
        // We have to pick off the keys of the event that we need on the other side
        var altKey = event.altKey,
            ctrlKey = event.ctrlKey,
            metaKey = event.metaKey,
            shiftKey = event.shiftKey,
            key = event.key,
            code = event.code,
            keyCode = event.keyCode;
        this.channel.emit(Events.PREVIEW_KEYDOWN, {
          event: {
            altKey: altKey,
            ctrlKey: ctrlKey,
            metaKey: metaKey,
            shiftKey: shiftKey,
            key: key,
            code: code,
            keyCode: keyCode
          }
        });
      }
    }
  }, {
    key: "onSetCurrentStory",
    value: function onSetCurrentStory(selection) {
      this.urlStore.setSelection(selection);
      this.channel.emit(Events.CURRENT_STORY_WAS_SET, this.urlStore.selection);
      this.renderSelection();
    }
  }, {
    key: "onUpdateQueryParams",
    value: function onUpdateQueryParams(queryParams) {
      this.urlStore.setQueryParams(queryParams);
    }
  }, {
    key: "onUpdateGlobals",
    value: function onUpdateGlobals(_ref5) {
      var globals = _ref5.globals;
      this.storyStore.globals.update(globals);
      this.channel.emit(Events.GLOBALS_UPDATED, {
        globals: this.storyStore.globals.get(),
        initialGlobals: this.storyStore.globals.initialGlobals
      });
    }
  }, {
    key: "onUpdateArgs",
    value: function onUpdateArgs(_ref6) {
      var storyId = _ref6.storyId,
          updatedArgs = _ref6.updatedArgs;
      this.storyStore.args.update(storyId, updatedArgs);
      this.channel.emit(Events.STORY_ARGS_UPDATED, {
        storyId: storyId,
        args: this.storyStore.args.get(storyId)
      });
    }
  }, {
    key: "onResetArgs",
    value: function () {
      var _onResetArgs = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee7(_ref7) {
        var storyId, argNames, _ref8, initialArgs, argNamesToReset, updatedArgs;

        return regeneratorRuntime.wrap(function _callee7$(_context7) {
          while (1) {
            switch (_context7.prev = _context7.next) {
              case 0:
                storyId = _ref7.storyId, argNames = _ref7.argNames;

                if (!(storyId === this.previousStory.id)) {
                  _context7.next = 5;
                  break;
                }

                _context7.t0 = this.previousStory;
                _context7.next = 8;
                break;

              case 5:
                _context7.next = 7;
                return this.storyStore.loadStory({
                  storyId: storyId
                });

              case 7:
                _context7.t0 = _context7.sent;

              case 8:
                _ref8 = _context7.t0;
                initialArgs = _ref8.initialArgs;
                argNamesToReset = argNames || Object.keys(this.storyStore.args.get(storyId));
                updatedArgs = argNamesToReset.reduce(function (acc, argName) {
                  acc[argName] = initialArgs[argName];
                  return acc;
                }, {});
                this.onUpdateArgs({
                  storyId: storyId,
                  updatedArgs: updatedArgs
                });

              case 13:
              case "end":
                return _context7.stop();
            }
          }
        }, _callee7, this);
      }));

      function onResetArgs(_x3) {
        return _onResetArgs.apply(this, arguments);
      }

      return onResetArgs;
    }() // RENDERING
    // We can either have:
    // - a story selected in "story" viewMode,
    //     in which case we render it to the root element, OR
    // - a story selected in "docs" viewMode,
    //     in which case we render the docsPage for that story

  }, {
    key: "renderSelection",
    value: function () {
      var _renderSelection = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee8() {
        var _this$previousSelecti, _this$previousSelecti2, _global$FEATURES6;

        var _ref9,
            persistedArgs,
            selection,
            storyId,
            storyIdChanged,
            viewModeChanged,
            story,
            implementationChanged,
            _this$storyStore$getS,
            parameters,
            initialArgs,
            argTypes,
            args,
            _args8 = arguments;

        return regeneratorRuntime.wrap(function _callee8$(_context8) {
          while (1) {
            switch (_context8.prev = _context8.next) {
              case 0:
                _ref9 = _args8.length > 0 && _args8[0] !== undefined ? _args8[0] : {}, persistedArgs = _ref9.persistedArgs;
                selection = this.urlStore.selection;

                if (selection) {
                  _context8.next = 4;
                  break;
                }

                throw new Error('Cannot render story as no selection was made');

              case 4:
                storyId = selection.storyId;
                storyIdChanged = ((_this$previousSelecti = this.previousSelection) === null || _this$previousSelecti === void 0 ? void 0 : _this$previousSelecti.storyId) !== storyId;
                viewModeChanged = ((_this$previousSelecti2 = this.previousSelection) === null || _this$previousSelecti2 === void 0 ? void 0 : _this$previousSelecti2.viewMode) !== selection.viewMode; // Show a spinner while we load the next story

                if (selection.viewMode === 'story') {
                  this.view.showPreparingStory();
                } else {
                  this.view.showPreparingDocs();
                }

                _context8.prev = 8;
                _context8.next = 11;
                return this.storyStore.loadStory({
                  storyId: storyId
                });

              case 11:
                story = _context8.sent;
                _context8.next = 21;
                break;

              case 14:
                _context8.prev = 14;
                _context8.t0 = _context8["catch"](8);
                _context8.next = 18;
                return this.cleanupPreviousRender();

              case 18:
                this.previousStory = null;
                this.renderStoryLoadingException(storyId, _context8.t0);
                return _context8.abrupt("return");

              case 21:
                implementationChanged = !storyIdChanged && this.previousStory && story !== this.previousStory;

                if (persistedArgs) {
                  this.storyStore.args.updateFromPersisted(story, persistedArgs);
                } // Don't re-render the story if nothing has changed to justify it


                if (!(this.previousStory && !storyIdChanged && !implementationChanged && !viewModeChanged)) {
                  _context8.next = 27;
                  break;
                }

                this.channel.emit(Events.STORY_UNCHANGED, storyId);
                this.view.showMain();
                return _context8.abrupt("return");

              case 27:
                _context8.next = 29;
                return this.cleanupPreviousRender({
                  unmountDocs: viewModeChanged
                });

              case 29:
                // If we are rendering something new (as opposed to re-rendering the same or first story), emit
                if (this.previousSelection && (storyIdChanged || viewModeChanged)) {
                  this.channel.emit(Events.STORY_CHANGED, storyId);
                } // Record the previous selection *before* awaiting the rendering, in cases things change before it is done.


                this.previousSelection = selection;
                this.previousStory = story;
                _this$storyStore$getS = this.storyStore.getStoryContext(story), parameters = _this$storyStore$getS.parameters, initialArgs = _this$storyStore$getS.initialArgs, argTypes = _this$storyStore$getS.argTypes, args = _this$storyStore$getS.args;

                if ((_global$FEATURES6 = global.FEATURES) !== null && _global$FEATURES6 !== void 0 && _global$FEATURES6.storyStoreV7) {
                  this.channel.emit(Events.STORY_PREPARED, {
                    id: storyId,
                    parameters: parameters,
                    initialArgs: initialArgs,
                    argTypes: argTypes,
                    args: args
                  });
                } // For v6 mode / compatibility
                // If the implementation changed, or args were persisted, the args may have changed,
                // and the STORY_PREPARED event above may not be respected.


                if (implementationChanged || persistedArgs) {
                  this.channel.emit(Events.STORY_ARGS_UPDATED, {
                    storyId: storyId,
                    args: args
                  });
                }

                if (!(selection.viewMode === 'docs' || story.parameters.docsOnly)) {
                  _context8.next = 41;
                  break;
                }

                _context8.next = 38;
                return this.renderDocs({
                  story: story
                });

              case 38:
                this.previousCleanup = _context8.sent;
                _context8.next = 42;
                break;

              case 41:
                this.previousCleanup = this.renderStory({
                  story: story
                });

              case 42:
              case "end":
                return _context8.stop();
            }
          }
        }, _callee8, this, [[8, 14]]);
      }));

      function renderSelection() {
        return _renderSelection.apply(this, arguments);
      }

      return renderSelection;
    }()
  }, {
    key: "renderDocs",
    value: function () {
      var _renderDocs = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee11(_ref10) {
        var _this6 = this,
            _global$FEATURES8;

        var story, id, title, name, csfFile, docsContext, render;
        return regeneratorRuntime.wrap(function _callee11$(_context11) {
          while (1) {
            switch (_context11.prev = _context11.next) {
              case 0:
                story = _ref10.story;
                id = story.id, title = story.title, name = story.name;
                _context11.next = 4;
                return this.storyStore.loadCSFFileByStoryId(id);

              case 4:
                csfFile = _context11.sent;
                docsContext = {
                  id: id,
                  title: title,
                  name: name,
                  // NOTE: these two functions are *sync* so cannot access stories from other CSF files
                  storyById: function storyById(storyId) {
                    return _this6.storyStore.storyFromCSFFile({
                      storyId: storyId,
                      csfFile: csfFile
                    });
                  },
                  componentStories: function componentStories() {
                    return _this6.storyStore.componentStoriesFromCSFFile({
                      csfFile: csfFile
                    });
                  },
                  loadStory: function loadStory(storyId) {
                    return _this6.storyStore.loadStory({
                      storyId: storyId
                    });
                  },
                  renderStoryToElement: this.renderStoryToElement.bind(this),
                  getStoryContext: function getStoryContext(renderedStory) {
                    return Object.assign({}, _this6.storyStore.getStoryContext(renderedStory), {
                      viewMode: 'docs'
                    });
                  }
                };

                render = /*#__PURE__*/function () {
                  var _ref11 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee9() {
                    var _global$FEATURES7;

                    var fullDocsContext, renderer, element;
                    return regeneratorRuntime.wrap(function _callee9$(_context9) {
                      while (1) {
                        switch (_context9.prev = _context9.next) {
                          case 0:
                            fullDocsContext = Object.assign({}, docsContext, !((_global$FEATURES7 = global.FEATURES) !== null && _global$FEATURES7 !== void 0 && _global$FEATURES7.breakingChangesV7) && _this6.storyStore.getStoryContext(story));
                            _context9.next = 3;
                            return import('./renderDocs');

                          case 3:
                            renderer = _context9.sent;
                            element = _this6.view.prepareForDocs();
                            renderer.renderDocs(story, fullDocsContext, element, function () {
                              return _this6.channel.emit(Events.DOCS_RENDERED, id);
                            });

                          case 6:
                          case "end":
                            return _context9.stop();
                        }
                      }
                    }, _callee9);
                  }));

                  return function render() {
                    return _ref11.apply(this, arguments);
                  };
                }(); // Initially render right away


                render(); // Listen to events and re-render
                // NOTE: we aren't checking to see the story args are targetted at the "right" story.
                // This is because we may render >1 story on the page and there is no easy way to keep track
                // of which ones were rendered by the docs page.
                // However, in `modernInlineRender`, the individual stories track their own events as they
                // each call `renderStoryToElement` below.

                if (!((_global$FEATURES8 = global.FEATURES) !== null && _global$FEATURES8 !== void 0 && _global$FEATURES8.modernInlineRender)) {
                  this.channel.on(Events.UPDATE_GLOBALS, render);
                  this.channel.on(Events.UPDATE_STORY_ARGS, render);
                  this.channel.on(Events.RESET_STORY_ARGS, render);
                }

                return _context11.abrupt("return", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee10() {
                  var _global$FEATURES9;

                  return regeneratorRuntime.wrap(function _callee10$(_context10) {
                    while (1) {
                      switch (_context10.prev = _context10.next) {
                        case 0:
                          if (!((_global$FEATURES9 = global.FEATURES) !== null && _global$FEATURES9 !== void 0 && _global$FEATURES9.modernInlineRender)) {
                            _this6.channel.off(Events.UPDATE_GLOBALS, render);

                            _this6.channel.off(Events.UPDATE_STORY_ARGS, render);

                            _this6.channel.off(Events.RESET_STORY_ARGS, render);
                          }

                        case 1:
                        case "end":
                          return _context10.stop();
                      }
                    }
                  }, _callee10);
                })));

              case 10:
              case "end":
                return _context11.stop();
            }
          }
        }, _callee11, this);
      }));

      function renderDocs(_x4) {
        return _renderDocs.apply(this, arguments);
      }

      return renderDocs;
    }()
  }, {
    key: "renderStory",
    value: function renderStory(_ref13) {
      var _this7 = this;

      var story = _ref13.story;
      var element = this.view.prepareForStory(story);
      var id = story.id,
          componentId = story.componentId,
          title = story.title,
          name = story.name;
      var renderContext = {
        componentId: componentId,
        title: title,
        kind: title,
        id: id,
        name: name,
        story: name,
        showMain: function showMain() {
          return _this7.view.showMain();
        },
        showError: function showError(err) {
          return _this7.renderError(id, err);
        },
        showException: function showException(err) {
          return _this7.renderException(id, err);
        }
      };
      return this.renderStoryToElement({
        story: story,
        renderContext: renderContext,
        element: element,
        viewMode: 'story'
      });
    } // Render a story into a given element and watch for the events that would trigger us
    // to re-render it (plus deal sensibly with things like changing story mid-way through).

  }, {
    key: "renderStoryToElement",
    value: function renderStoryToElement(_ref14) {
      var _this8 = this;

      var story = _ref14.story,
          renderContextWithoutStoryContext = _ref14.renderContext,
          canvasElement = _ref14.element,
          viewMode = _ref14.viewMode;
      var id = story.id,
          applyLoaders = story.applyLoaders,
          unboundStoryFn = story.unboundStoryFn,
          playFunction = story.playFunction;
      var notYetRendered = true;
      var phase;

      var isPending = function isPending() {
        return ['rendering', 'playing'].includes(phase);
      };

      this.abortController = createController();

      var render = /*#__PURE__*/function () {
        var _ref15 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee14() {
          var _ref16,
              _ref16$initial,
              initial,
              _ref16$forceRemount,
              forceRemount,
              abortSignal,
              runPhase,
              loadedContext,
              renderStoryContext,
              renderContext,
              _args14 = arguments;

          return regeneratorRuntime.wrap(function _callee14$(_context14) {
            while (1) {
              switch (_context14.prev = _context14.next) {
                case 0:
                  _ref16 = _args14.length > 0 && _args14[0] !== undefined ? _args14[0] : {}, _ref16$initial = _ref16.initial, initial = _ref16$initial === void 0 ? false : _ref16$initial, _ref16$forceRemount = _ref16.forceRemount, forceRemount = _ref16$forceRemount === void 0 ? false : _ref16$forceRemount;

                  if (forceRemount && !initial) {
                    _this8.abortController.abort();

                    _this8.abortController = createController();
                  }

                  abortSignal = _this8.abortController.signal; // we need a stable reference to the signal

                  runPhase = /*#__PURE__*/function () {
                    var _ref17 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee12(phaseName, phaseFn) {
                      return regeneratorRuntime.wrap(function _callee12$(_context12) {
                        while (1) {
                          switch (_context12.prev = _context12.next) {
                            case 0:
                              phase = phaseName;

                              _this8.channel.emit(Events.STORY_RENDER_PHASE_CHANGED, {
                                newPhase: phase,
                                storyId: id
                              });

                              if (!phaseFn) {
                                _context12.next = 5;
                                break;
                              }

                              _context12.next = 5;
                              return phaseFn();

                            case 5:
                              if (abortSignal.aborted) {
                                phase = 'aborted';

                                _this8.channel.emit(Events.STORY_RENDER_PHASE_CHANGED, {
                                  newPhase: phase,
                                  storyId: id
                                });
                              }

                            case 6:
                            case "end":
                              return _context12.stop();
                          }
                        }
                      }, _callee12);
                    }));

                    return function runPhase(_x5, _x6) {
                      return _ref17.apply(this, arguments);
                    };
                  }();

                  _context14.prev = 4;
                  _context14.next = 7;
                  return runPhase('loading', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee13() {
                    return regeneratorRuntime.wrap(function _callee13$(_context13) {
                      while (1) {
                        switch (_context13.prev = _context13.next) {
                          case 0:
                            _context13.next = 2;
                            return applyLoaders(Object.assign({}, _this8.storyStore.getStoryContext(story), {
                              viewMode: viewMode
                            }));

                          case 2:
                            loadedContext = _context13.sent;

                          case 3:
                          case "end":
                            return _context13.stop();
                        }
                      }
                    }, _callee13);
                  })));

                case 7:
                  if (!abortSignal.aborted) {
                    _context14.next = 9;
                    break;
                  }

                  return _context14.abrupt("return");

                case 9:
                  renderStoryContext = Object.assign({}, loadedContext, _this8.storyStore.getStoryContext(story), {
                    abortSignal: abortSignal,
                    canvasElement: canvasElement
                  });
                  renderContext = Object.assign({}, renderContextWithoutStoryContext, {
                    forceRemount: forceRemount || notYetRendered,
                    storyContext: renderStoryContext,
                    storyFn: function storyFn() {
                      return unboundStoryFn(renderStoryContext);
                    },
                    unboundStoryFn: unboundStoryFn
                  });
                  _context14.next = 13;
                  return runPhase('rendering', function () {
                    return _this8.renderToDOM(renderContext, canvasElement);
                  });

                case 13:
                  notYetRendered = false;

                  if (!abortSignal.aborted) {
                    _context14.next = 16;
                    break;
                  }

                  return _context14.abrupt("return");

                case 16:
                  if (!(forceRemount && playFunction)) {
                    _context14.next = 25;
                    break;
                  }

                  _this8.disableKeyListeners = true;
                  _context14.next = 20;
                  return runPhase('playing', function () {
                    return playFunction(renderContext.storyContext);
                  });

                case 20:
                  _context14.next = 22;
                  return runPhase('played');

                case 22:
                  _this8.disableKeyListeners = false;

                  if (!abortSignal.aborted) {
                    _context14.next = 25;
                    break;
                  }

                  return _context14.abrupt("return");

                case 25:
                  _context14.next = 27;
                  return runPhase('completed', function () {
                    return _this8.channel.emit(Events.STORY_RENDERED, id);
                  });

                case 27:
                  _context14.next = 32;
                  break;

                case 29:
                  _context14.prev = 29;
                  _context14.t0 = _context14["catch"](4);
                  renderContextWithoutStoryContext.showException(_context14.t0);

                case 32:
                case "end":
                  return _context14.stop();
              }
            }
          }, _callee14, null, [[4, 29]]);
        }));

        return function render() {
          return _ref15.apply(this, arguments);
        };
      }(); // Start the first (initial) render. We don't await here because we need to return the "cleanup"
      // function below right away, so if the user changes story during the first render we can cancel
      // it without having to first wait for it to finish.
      // Whenever the selection changes we want to force the component to be remounted.


      render({
        initial: true,
        forceRemount: true
      });

      var remountStoryIfMatches = function remountStoryIfMatches(_ref19) {
        var storyId = _ref19.storyId;
        if (storyId === story.id) render({
          forceRemount: true
        });
      };

      var rerenderStoryIfMatches = function rerenderStoryIfMatches(_ref20) {
        var storyId = _ref20.storyId;
        if (storyId === story.id) render();
      }; // Listen to events and re-render story
      // Don't forget to unsubscribe on cleanup


      this.channel.on(Events.UPDATE_GLOBALS, render);
      this.channel.on(Events.FORCE_RE_RENDER, render);
      this.channel.on(Events.FORCE_REMOUNT, remountStoryIfMatches);
      this.channel.on(Events.UPDATE_STORY_ARGS, rerenderStoryIfMatches);
      this.channel.on(Events.RESET_STORY_ARGS, rerenderStoryIfMatches); // Cleanup / teardown function invoked on next render (via `cleanupPreviousRender`)

      return /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee15() {
        return regeneratorRuntime.wrap(function _callee15$(_context15) {
          while (1) {
            switch (_context15.prev = _context15.next) {
              case 0:
                // If the story is torn down (either a new story is rendered or the docs page removes it)
                // we need to consider the fact that the initial render may not be finished
                // (possibly the loaders or the play function are still running). We use the controller
                // as a method to abort them, ASAP, but this is not foolproof as we cannot control what
                // happens inside the user's code.
                _this8.abortController.abort();

                _this8.storyStore.cleanupStory(story);

                _this8.channel.off(Events.UPDATE_GLOBALS, render);

                _this8.channel.off(Events.FORCE_RE_RENDER, render);

                _this8.channel.off(Events.FORCE_REMOUNT, remountStoryIfMatches);

                _this8.channel.off(Events.UPDATE_STORY_ARGS, rerenderStoryIfMatches);

                _this8.channel.off(Events.RESET_STORY_ARGS, rerenderStoryIfMatches); // Check if we're done rendering/playing. If not, we may have to reload the page.


                if (isPending()) {
                  _context15.next = 9;
                  break;
                }

                return _context15.abrupt("return");

              case 9:
                _context15.next = 11;
                return new Promise(function (resolve) {
                  return setTimeout(resolve, 0);
                });

              case 11:
                if (isPending()) {
                  _context15.next = 13;
                  break;
                }

                return _context15.abrupt("return");

              case 13:
                _context15.next = 15;
                return new Promise(function (resolve) {
                  return setTimeout(resolve, 0);
                });

              case 15:
                if (isPending()) {
                  _context15.next = 17;
                  break;
                }

                return _context15.abrupt("return");

              case 17:
                _context15.next = 19;
                return new Promise(function (resolve) {
                  return setTimeout(resolve, 0);
                });

              case 19:
                if (isPending()) {
                  _context15.next = 21;
                  break;
                }

                return _context15.abrupt("return");

              case 21:
                // If we still haven't completed, reload the page (iframe) to ensure we have a clean slate
                // for the next render. Since the reload can take a brief moment to happen, we want to stop
                // further rendering by awaiting a never-resolving promise (which is destroyed on reload).
                global.window.location.reload();
                _context15.next = 24;
                return new Promise(function () {});

              case 24:
              case "end":
                return _context15.stop();
            }
          }
        }, _callee15);
      }));
    } // API

  }, {
    key: "extract",
    value: function () {
      var _extract = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee16(options) {
        var _global$FEATURES10;

        return regeneratorRuntime.wrap(function _callee16$(_context16) {
          while (1) {
            switch (_context16.prev = _context16.next) {
              case 0:
                if (!this.previewEntryError) {
                  _context16.next = 2;
                  break;
                }

                throw this.previewEntryError;

              case 2:
                if (this.storyStore.projectAnnotations) {
                  _context16.next = 4;
                  break;
                }

                throw new Error(dedent(_templateObject5 || (_templateObject5 = _taggedTemplateLiteral(["Failed to initialize Storybook.\n      \n      Do you have an error in your `preview.js`? Check your Storybook's browser console for errors."], ["Failed to initialize Storybook.\n      \n      Do you have an error in your \\`preview.js\\`? Check your Storybook's browser console for errors."]))));

              case 4:
                if (!((_global$FEATURES10 = global.FEATURES) !== null && _global$FEATURES10 !== void 0 && _global$FEATURES10.storyStoreV7)) {
                  _context16.next = 7;
                  break;
                }

                _context16.next = 7;
                return this.storyStore.cacheAllCSFFiles();

              case 7:
                return _context16.abrupt("return", this.storyStore.extract(options));

              case 8:
              case "end":
                return _context16.stop();
            }
          }
        }, _callee16, this);
      }));

      function extract(_x7) {
        return _extract.apply(this, arguments);
      }

      return extract;
    }() // UTILITIES

  }, {
    key: "cleanupPreviousRender",
    value: function () {
      var _cleanupPreviousRender = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee17() {
        var _this$previousStory, _this$previousStory$p, _this$previousSelecti3;

        var _ref22,
            _ref22$unmountDocs,
            unmountDocs,
            previousViewMode,
            _args17 = arguments;

        return regeneratorRuntime.wrap(function _callee17$(_context17) {
          while (1) {
            switch (_context17.prev = _context17.next) {
              case 0:
                _ref22 = _args17.length > 0 && _args17[0] !== undefined ? _args17[0] : {}, _ref22$unmountDocs = _ref22.unmountDocs, unmountDocs = _ref22$unmountDocs === void 0 ? true : _ref22$unmountDocs;
                previousViewMode = (_this$previousStory = this.previousStory) !== null && _this$previousStory !== void 0 && (_this$previousStory$p = _this$previousStory.parameters) !== null && _this$previousStory$p !== void 0 && _this$previousStory$p.docsOnly ? 'docs' : (_this$previousSelecti3 = this.previousSelection) === null || _this$previousSelecti3 === void 0 ? void 0 : _this$previousSelecti3.viewMode;

                if (!(unmountDocs && previousViewMode === 'docs')) {
                  _context17.next = 6;
                  break;
                }

                _context17.next = 5;
                return import('./renderDocs');

              case 5:
                _context17.sent.unmountDocs(this.view.docsRoot());

              case 6:
                if (!this.previousCleanup) {
                  _context17.next = 9;
                  break;
                }

                _context17.next = 9;
                return this.previousCleanup();

              case 9:
              case "end":
                return _context17.stop();
            }
          }
        }, _callee17, this);
      }));

      function cleanupPreviousRender() {
        return _cleanupPreviousRender.apply(this, arguments);
      }

      return cleanupPreviousRender;
    }()
  }, {
    key: "renderPreviewEntryError",
    value: function renderPreviewEntryError(reason, err) {
      this.previewEntryError = err;
      logger.error(reason);
      logger.error(err);
      this.view.showErrorDisplay(err);
      this.channel.emit(Events.CONFIG_ERROR, err);
    }
  }, {
    key: "renderMissingStory",
    value: function renderMissingStory() {
      this.view.showNoPreview();
      this.channel.emit(Events.STORY_MISSING);
    }
  }, {
    key: "renderStoryLoadingException",
    value: function renderStoryLoadingException(storySpecifier, err) {
      logger.error("Unable to load story '".concat(storySpecifier, "':"));
      logger.error(err);
      this.view.showErrorDisplay(err);
      this.channel.emit(Events.STORY_MISSING, storySpecifier);
    } // renderException is used if we fail to render the story and it is uncaught by the app layer

  }, {
    key: "renderException",
    value: function renderException(storyId, err) {
      this.channel.emit(Events.STORY_THREW_EXCEPTION, err);
      this.channel.emit(Events.STORY_RENDER_PHASE_CHANGED, {
        newPhase: 'errored',
        storyId: storyId
      }); // Ignored exceptions exist for control flow purposes, and are typically handled elsewhere.

      if (err !== IGNORED_EXCEPTION) {
        this.view.showErrorDisplay(err);
        logger.error("Error rendering story '".concat(storyId, "':"));
        logger.error(err);
      }
    } // renderError is used by the various app layers to inform the user they have done something
    // wrong -- for instance returned the wrong thing from a story

  }, {
    key: "renderError",
    value: function renderError(storyId, _ref23) {
      var title = _ref23.title,
          description = _ref23.description;
      logger.error("Error rendering story ".concat(title, ": ").concat(description));
      this.channel.emit(Events.STORY_ERRORED, {
        title: title,
        description: description
      });
      this.channel.emit(Events.STORY_RENDER_PHASE_CHANGED, {
        newPhase: 'errored',
        storyId: storyId
      });
      this.view.showErrorDisplay({
        message: title,
        stack: description
      });
    }
  }]);

  return PreviewWeb;
}();