"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.registerExtensions = exports.TS_EXTENSION = exports.RESULTS_EXTENSION = exports.JS_EXTENSION = void 0;
exports.JS_EXTENSION = '.js';
exports.RESULTS_EXTENSION = '.results';
exports.TS_EXTENSION = '.ts';
let isRegistered = false;
async function registerExtensions(tsconfigPath) {
    if (isRegistered) {
        return;
    }
    isRegistered = true;
    // Need to do this so that webpack doesn't remove it
    // during the extension bundle...
    const EXTENSIONS = eval(`require.extensions`);
    // Get the original JS module require:
    const JS = EXTENSIONS[exports.JS_EXTENSION];
    if (!EXTENSIONS[exports.TS_EXTENSION]) {
        await registerTypeScript(tsconfigPath);
    }
    // Force `.betterer.results` files to be loaded as JS:
    EXTENSIONS[exports.RESULTS_EXTENSION] = (m, filePath) => {
        JS(m, filePath);
    };
}
exports.registerExtensions = registerExtensions;
async function registerTypeScript(tsconfigPath) {
    let tsNode;
    try {
        await Promise.resolve().then(() => __importStar(require('typescript')));
        tsNode = await Promise.resolve().then(() => __importStar(require('ts-node')));
    }
    catch (_a) {
        // Environment doesn't have TypeScript available, move on!
        return;
    }
    // Use TS-Node register to allow `.betterer.ts` config files:
    const tsRegisterOptions = {
        transpileOnly: true,
        compilerOptions: {
            module: 'commonjs'
        }
    };
    if (tsconfigPath) {
        tsRegisterOptions.project = tsconfigPath;
    }
    tsNode.register(tsRegisterOptions);
}
//# sourceMappingURL=register.js.map