"use strict";
// Copyright (c) Microsoft Corporation. All rights reserved. Licensed under the MIT license.
// See LICENSE in the project root for license information.
Object.defineProperty(exports, "__esModule", { value: true });
exports.FolderConstants = exports.FileConstants = void 0;
/**
 * String constants for common filenames and parts of filenames.
 *
 * @public
 */
var FileConstants;
(function (FileConstants) {
    /**
     * "package.json" - the configuration file that defines an NPM package
     */
    FileConstants["PackageJson"] = "package.json";
})(FileConstants = exports.FileConstants || (exports.FileConstants = {}));
/**
 * String constants for common folder names.
 *
 * @public
 */
var FolderConstants;
(function (FolderConstants) {
    /**
     * ".git" - the data storage for a Git working folder
     */
    FolderConstants["Git"] = ".git";
    /**
     * "node_modules" - the folder where package managers install their files
     */
    FolderConstants["NodeModules"] = "node_modules";
})(FolderConstants = exports.FolderConstants || (exports.FolderConstants = {}));
//# sourceMappingURL=Constants.js.map