/**
 * Just a lil state logger
 *
 * @param state
 * @param DEBUG
 */
export declare function useStateLogger(state: string, DEBUG?: boolean): void;
/**
 * When in dev mode, checks that styles for a given `@reach` package are loaded.
 *
 * @param packageName Name of the package to check.
 * @example checkStyles("dialog") will check for styles for @reach/dialog
 */
export declare function checkStyles(packageName: string): void;
/**
 * When in dev mode, checks that styles for a given `@reach` package are loaded.
 *
 * @param packageName Name of the package to check.
 * @example useCheckStyles("dialog") will check for styles for @reach/dialog
 */
export declare function useCheckStyles(packageName: string): void;
/**
 * Logs a warning in dev mode when a component switches from controlled to
 * uncontrolled, or vice versa
 *
 * A single prop should typically be used to determine whether or not a
 * component is controlled or not.
 *
 * @param controlledValue
 * @param controlledPropName
 * @param componentName
 */
export declare function useControlledSwitchWarning(controlledValue: any, controlledPropName: string, componentName: string): void;
