/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Paravirtualized DMA operations that offers DMA inspection between the guest
 * and the host.
 *
 * Copyright (C) 2020 Alibaba Cloud. or its affiliates. All Rights Reserved.
 */
#ifndef _PVDMA_H
#define _PVDMA_H

#include <linux/dma-mapping.h>
#include <linux/dma-direct.h>
#include <linux/platform_device.h>

extern bool pvdma_is_enabled;
extern const struct dma_map_ops *mmio_dma_ops;

void pv_dma_map(phys_addr_t gpa, size_t size, bool map);
void pv_dma_map_sg(struct scatterlist *sgl, int nents, bool map);

void pvdma_pci_enable(void);
void pvdma_pci_disable(void);

dma_addr_t pvdma_direct_map_page(struct device *dev,
	struct page *page, unsigned long offset, size_t size,
	enum dma_data_direction dir, unsigned long attrs);

void pvdma_direct_unmap_page(struct device *dev, dma_addr_t addr,
	size_t size, enum dma_data_direction dir, unsigned long attrs);

void dma_direct_unmap_sg(struct device *dev, struct scatterlist *sgl,
	int nents, enum dma_data_direction dir, unsigned long attrs);

int dma_direct_map_sg(struct device *dev, struct scatterlist *sgl, int nents,
	enum dma_data_direction dir, unsigned long attrs);
#endif /* _PVDMA_H */
