// Code generated by interstellar. DO NOT EDIT.
// Compatible with leonis RTL tag 0710

#ifndef NBL_UPRBAC_H
#define NBL_UPRBAC_H 1

#include <linux/types.h>

#define NBL_UPRBAC_BASE (0x0000C000)

#define NBL_UPRBAC_INT_STATUS_ADDR  (0xc000)
#define NBL_UPRBAC_INT_STATUS_DEPTH (1)
#define NBL_UPRBAC_INT_STATUS_WIDTH (32)
#define NBL_UPRBAC_INT_STATUS_DWLEN (1)
union uprbac_int_status_u {
	struct uprbac_int_status {
		u32 fatal_err:1;         /* [0] Default:0x0 RWC */
		u32 fifo_underflow:1;    /* [1] Default:0x0 RWC */
		u32 fifo_overflow:1;     /* [2] Default:0x0 RWC */
		u32 cif_err:1;           /* [3] Default:0x0 RWC */
		u32 cfg_err:1;           /* [4] Default:0x0 RWC */
		u32 ucor_err:1;          /* [5] Default:0x0 RWC */
		u32 cor_err:1;           /* [6] Default:0x0 RWC */
		u32 soft_lifetime:1;     /* [7] Default:0x0 RWC */
		u32 hard_lifetime:1;     /* [8] Default:0x0 RWC */
		u32 esn_replay:1;        /* [9] Default:0x0 RWC */
		u32 rsv:22;              /* [31:10] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_INT_STATUS_DWLEN];
} __packed;

#define NBL_UPRBAC_INT_MASK_ADDR  (0xc004)
#define NBL_UPRBAC_INT_MASK_DEPTH (1)
#define NBL_UPRBAC_INT_MASK_WIDTH (32)
#define NBL_UPRBAC_INT_MASK_DWLEN (1)
union uprbac_int_mask_u {
	struct uprbac_int_mask {
		u32 fatal_err:1;         /* [0] Default:0x0 RW */
		u32 fifo_underflow:1;    /* [1] Default:0x0 RW */
		u32 fifo_overflow:1;     /* [2] Default:0x0 RW */
		u32 cif_err:1;           /* [3] Default:0x0 RW */
		u32 cfg_err:1;           /* [4] Default:0x0 RW */
		u32 ucor_err:1;          /* [5] Default:0x0 RW */
		u32 cor_err:1;           /* [6] Default:0x0 RW */
		u32 soft_lifetime:1;     /* [7] Default:0x0 RW */
		u32 hard_lifetime:1;     /* [8] Default:0x0 RW */
		u32 esn_replay:1;        /* [9] Default:0x0 RW */
		u32 rsv:22;              /* [31:10] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_INT_MASK_DWLEN];
} __packed;

#define NBL_UPRBAC_INT_SET_ADDR  (0xc008)
#define NBL_UPRBAC_INT_SET_DEPTH (1)
#define NBL_UPRBAC_INT_SET_WIDTH (32)
#define NBL_UPRBAC_INT_SET_DWLEN (1)
union uprbac_int_set_u {
	struct uprbac_int_set {
		u32 fatal_err:1;         /* [0] Default:0x0 WO */
		u32 fifo_underflow:1;    /* [1] Default:0x0 WO */
		u32 fifo_overflow:1;     /* [2] Default:0x0 WO */
		u32 cif_err:1;           /* [3] Default:0x0 WO */
		u32 cfg_err:1;           /* [4] Default:0x0 WO */
		u32 ucor_err:1;          /* [5] Default:0x0 WO */
		u32 cor_err:1;           /* [6] Default:0x0 WO */
		u32 soft_lifetime:1;     /* [7] Default:0x0 WO */
		u32 hard_lifetime:1;     /* [8] Default:0x0 WO */
		u32 esn_replay:1;        /* [9] Default:0x0 WO */
		u32 rsv:22;              /* [31:10] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_INT_SET_DWLEN];
} __packed;

#define NBL_UPRBAC_LIFETIME_INFO_ADDR  (0xc014)
#define NBL_UPRBAC_LIFETIME_INFO_DEPTH (1)
#define NBL_UPRBAC_LIFETIME_INFO_WIDTH (32)
#define NBL_UPRBAC_LIFETIME_INFO_DWLEN (1)
union uprbac_lifetime_info_u {
	struct uprbac_lifetime_info {
		u32 soft_sad_index:11;   /* [10:0] Default:0x0 RO */
		u32 rsv1:5;              /* [15:11] Default:0x0 RO */
		u32 hard_sad_index:11;   /* [26:16] Default:0x0 RO */
		u32 rsv:5;               /* [31:27] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_LIFETIME_INFO_DWLEN];
} __packed;

#define NBL_UPRBAC_UCOR_ERR_INFO_ADDR  (0xc024)
#define NBL_UPRBAC_UCOR_ERR_INFO_DEPTH (1)
#define NBL_UPRBAC_UCOR_ERR_INFO_WIDTH (32)
#define NBL_UPRBAC_UCOR_ERR_INFO_DWLEN (1)
union uprbac_ucor_err_info_u {
	struct uprbac_ucor_err_info {
		u32 addr:16;             /* [15:0] Default:0x0 RO */
		u32 id:6;                /* [21:16] Default:0x0 RO */
		u32 rsv:10;              /* [31:22] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_UCOR_ERR_INFO_DWLEN];
} __packed;

#define NBL_UPRBAC_COR_ERR_INFO_ADDR  (0xc02c)
#define NBL_UPRBAC_COR_ERR_INFO_DEPTH (1)
#define NBL_UPRBAC_COR_ERR_INFO_WIDTH (32)
#define NBL_UPRBAC_COR_ERR_INFO_DWLEN (1)
union uprbac_cor_err_info_u {
	struct uprbac_cor_err_info {
		u32 addr:16;             /* [15:0] Default:0x0 RO */
		u32 id:6;                /* [21:16] Default:0x0 RO */
		u32 rsv:10;              /* [31:22] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_COR_ERR_INFO_DWLEN];
} __packed;

#define NBL_UPRBAC_CFG_ERR_INFO_ADDR  (0xc034)
#define NBL_UPRBAC_CFG_ERR_INFO_DEPTH (1)
#define NBL_UPRBAC_CFG_ERR_INFO_WIDTH (32)
#define NBL_UPRBAC_CFG_ERR_INFO_DWLEN (1)
union uprbac_cfg_err_info_u {
	struct uprbac_cfg_err_info {
		u32 addr:16;             /* [15:0] Default:0x0 RO */
		u32 id:6;                /* [21:16] Default:0x0 RO */
		u32 rsv:10;              /* [31:22] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_CFG_ERR_INFO_DWLEN];
} __packed;

#define NBL_UPRBAC_CIF_ERR_INFO_ADDR  (0xc040)
#define NBL_UPRBAC_CIF_ERR_INFO_DEPTH (1)
#define NBL_UPRBAC_CIF_ERR_INFO_WIDTH (32)
#define NBL_UPRBAC_CIF_ERR_INFO_DWLEN (1)
union uprbac_cif_err_info_u {
	struct uprbac_cif_err_info {
		u32 addr:30;             /* [29:0] Default:0x0 RO */
		u32 wr_err:1;            /* [30] Default:0x0 RO */
		u32 ucor_err:1;          /* [31] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_CIF_ERR_INFO_DWLEN];
} __packed;

#define NBL_UPRBAC_CAR_CTRL_ADDR  (0xc100)
#define NBL_UPRBAC_CAR_CTRL_DEPTH (1)
#define NBL_UPRBAC_CAR_CTRL_WIDTH (32)
#define NBL_UPRBAC_CAR_CTRL_DWLEN (1)
union uprbac_car_ctrl_u {
	struct uprbac_car_ctrl {
		u32 sctr_car:1;          /* [0] Default:0x1 RW */
		u32 rctr_car:1;          /* [1] Default:0x1 RW */
		u32 rc_car:1;            /* [2] Default:0x1 RW */
		u32 tbl_rc_car:1;        /* [3] Default:0x1 RW */
		u32 rsv:28;              /* [31:4] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_CAR_CTRL_DWLEN];
} __packed;

#define NBL_UPRBAC_MODE_ADDR  (0xc110)
#define NBL_UPRBAC_MODE_DEPTH (1)
#define NBL_UPRBAC_MODE_WIDTH (32)
#define NBL_UPRBAC_MODE_DWLEN (1)
union uprbac_mode_u {
	struct uprbac_mode {
		u32 work_mode:1;         /* [0] Default:0x1 RW */
		u32 rsv:31;              /* [31:1] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_MODE_DWLEN];
} __packed;

#define NBL_UPRBAC_ENABLE_ADDR  (0xc114)
#define NBL_UPRBAC_ENABLE_DEPTH (1)
#define NBL_UPRBAC_ENABLE_WIDTH (32)
#define NBL_UPRBAC_ENABLE_DWLEN (1)
union uprbac_enable_u {
	struct uprbac_enable {
		u32 prbac:1;             /* [0] Default:0x0 RW */
		u32 padding_check:1;     /* [1] Default:0x1 RW */
		u32 pa_am:1;             /* [2] Default:0x0 RW */
		u32 dm_am:1;             /* [3] Default:0x0 RW */
		u32 icv_err:1;           /* [4] Default:0x1 RW */
		u32 pad_err:1;           /* [5] Default:0x1 RW */
		u32 ipv6_nat_csm0:1;     /* [6] Default:0x0 RW */
		u32 rsv:25;              /* [31:7] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_ENABLE_DWLEN];
} __packed;

#define NBL_UPRBAC_CLK_GATE_ADDR  (0xc118)
#define NBL_UPRBAC_CLK_GATE_DEPTH (1)
#define NBL_UPRBAC_CLK_GATE_WIDTH (32)
#define NBL_UPRBAC_CLK_GATE_DWLEN (1)
union uprbac_clk_gate_u {
	struct uprbac_clk_gate {
		u32 clk_en:1;            /* [0] Default:0x0 RW */
		u32 rsv:31;              /* [31:1] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_CLK_GATE_DWLEN];
} __packed;

#define NBL_UPRBAC_INIT_START_ADDR  (0xc124)
#define NBL_UPRBAC_INIT_START_DEPTH (1)
#define NBL_UPRBAC_INIT_START_WIDTH (32)
#define NBL_UPRBAC_INIT_START_DWLEN (1)
union uprbac_init_start_u {
	struct uprbac_init_start {
		u32 start:1;             /* [0] Default:0x0 WO */
		u32 rsv:31;              /* [31:1] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_INIT_START_DWLEN];
} __packed;

#define NBL_UPRBAC_INIT_DONE_ADDR  (0xc128)
#define NBL_UPRBAC_INIT_DONE_DEPTH (1)
#define NBL_UPRBAC_INIT_DONE_WIDTH (32)
#define NBL_UPRBAC_INIT_DONE_DWLEN (1)
union uprbac_init_done_u {
	struct uprbac_init_done {
		u32 done:1;              /* [0] Default:0x0 RO */
		u32 rsv:31;              /* [31:1] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_INIT_DONE_DWLEN];
} __packed;

#define NBL_UPRBAC_NAT_ADDR  (0xc12c)
#define NBL_UPRBAC_NAT_DEPTH (1)
#define NBL_UPRBAC_NAT_WIDTH (32)
#define NBL_UPRBAC_NAT_DWLEN (1)
union uprbac_nat_u {
	struct uprbac_nat {
		u32 enable:1;            /* [0] Default:0x0 RW */
		u32 rsv:15;              /* [15:1] Default:0x0 RO */
		u32 dport:16;            /* [31:16] Default:4500 RW */
	} __packed info;
	u32 data[NBL_UPRBAC_NAT_DWLEN];
} __packed;

#define NBL_UPRBAC_VLAN_TYPE0_ADDR  (0xc130)
#define NBL_UPRBAC_VLAN_TYPE0_DEPTH (1)
#define NBL_UPRBAC_VLAN_TYPE0_WIDTH (32)
#define NBL_UPRBAC_VLAN_TYPE0_DWLEN (1)
union uprbac_vlan_type0_u {
	struct uprbac_vlan_type0 {
		u32 tpid0:16;            /* [15:0] Default:0x88A8 RW */
		u32 tpid1:16;            /* [31:16] Default:0x9100 RW */
	} __packed info;
	u32 data[NBL_UPRBAC_VLAN_TYPE0_DWLEN];
} __packed;

#define NBL_UPRBAC_VLAN_TYPE1_ADDR  (0xc134)
#define NBL_UPRBAC_VLAN_TYPE1_DEPTH (1)
#define NBL_UPRBAC_VLAN_TYPE1_WIDTH (32)
#define NBL_UPRBAC_VLAN_TYPE1_DWLEN (1)
union uprbac_vlan_type1_u {
	struct uprbac_vlan_type1 {
		u32 tpid2:16;            /* [15:0] Default:0x0 RW */
		u32 tpid3:16;            /* [31:16] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_UPRBAC_VLAN_TYPE1_DWLEN];
} __packed;

#define NBL_UPRBAC_VLAN_ENABLE_ADDR  (0xc140)
#define NBL_UPRBAC_VLAN_ENABLE_DEPTH (1)
#define NBL_UPRBAC_VLAN_ENABLE_WIDTH (32)
#define NBL_UPRBAC_VLAN_ENABLE_DWLEN (1)
union uprbac_vlan_enable_u {
	struct uprbac_vlan_enable {
		u32 tpid0:1;             /* [0] Default:0x1 RW */
		u32 tpid1:1;             /* [1] Default:0x1 RW */
		u32 tpid2:1;             /* [2] Default:0x0 RW */
		u32 tpid3:1;             /* [3] Default:0x0 RW */
		u32 rsv:28;              /* [31:4] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_VLAN_ENABLE_DWLEN];
} __packed;

#define NBL_UPRBAC_DROP_ADDR  (0xc180)
#define NBL_UPRBAC_DROP_DEPTH (1)
#define NBL_UPRBAC_DROP_WIDTH (32)
#define NBL_UPRBAC_DROP_DWLEN (1)
union uprbac_drop_u {
	struct uprbac_drop {
		u32 prbac_bp:1;          /* [0] Default:0x1 RW */
		u32 prbac_err:1;         /* [1] Default:0x1 RW */
		u32 prbac_replay:1;      /* [2] Default:0x1 RW */
		u32 md_drop:1;           /* [3] Default:0x1 RW */
		u32 md_errcode:1;        /* [4] Default:0x1 RW */
		u32 rsv:27;              /* [31:5] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_DROP_DWLEN];
} __packed;

#define NBL_UPRBAC_WRR_WT_ADDR  (0xc200)
#define NBL_UPRBAC_WRR_WT_DEPTH (1)
#define NBL_UPRBAC_WRR_WT_WIDTH (32)
#define NBL_UPRBAC_WRR_WT_DWLEN (1)
union uprbac_wrr_wt_u {
	struct uprbac_wrr_wt {
		u32 eth0:4;              /* [3:0] Default:0x1 RW */
		u32 eth1:4;              /* [7:4] Default:0x1 RW */
		u32 eth2:4;              /* [11:8] Default:0x1 RW */
		u32 eth3:4;              /* [15:12] Default:0x1 RW */
		u32 normal:8;            /* [23:16] Default:12 RW */
		u32 rsv:8;               /* [31:24] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_WRR_WT_DWLEN];
} __packed;

#define NBL_UPRBAC_SAD_LIFETIME_ADDR  (0xc204)
#define NBL_UPRBAC_SAD_LIFETIME_DEPTH (1)
#define NBL_UPRBAC_SAD_LIFETIME_WIDTH (32)
#define NBL_UPRBAC_SAD_LIFETIME_DWLEN (1)
union uprbac_sad_lifetime_u {
	struct uprbac_sad_lifetime {
		u32 sad_index:11;        /* [10:0] Default:0x0 RW */
		u32 rsv2:5;              /* [15:11] Default:0x0 RW */
		u32 msb_value:1;         /* [16] Default:0x1 RW */
		u32 flag_value:1;        /* [17] Default:0x1 RW */
		u32 rsv1:2;              /* [19:18] Default:0x0 RO */
		u32 msb_wen:1;           /* [20] Default:0x0 RWW */
		u32 flag_wen:1;          /* [21] Default:0x0 RWW */
		u32 rsv:10;              /* [31:22] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_SAD_LIFETIME_DWLEN];
} __packed;

#define NBL_UPRBAC_LIFETIME_DIFF_ADDR  (0xc208)
#define NBL_UPRBAC_LIFETIME_DIFF_DEPTH (1)
#define NBL_UPRBAC_LIFETIME_DIFF_WIDTH (32)
#define NBL_UPRBAC_LIFETIME_DIFF_DWLEN (1)
union uprbac_lifetime_diff_u {
	struct uprbac_lifetime_diff {
		u32 value:32;            /* [31:0] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_UPRBAC_LIFETIME_DIFF_DWLEN];
} __packed;

#define NBL_UPRBAC_ERRCODE_ADDR  (0xc20c)
#define NBL_UPRBAC_ERRCODE_DEPTH (1)
#define NBL_UPRBAC_ERRCODE_WIDTH (32)
#define NBL_UPRBAC_ERRCODE_DWLEN (1)
union uprbac_errcode_u {
	struct uprbac_errcode {
		u32 icv_err:4;           /* [3:0] Default:6 RW */
		u32 pad_err:4;           /* [7:4] Default:7 RW */
		u32 rsv:24;              /* [31:8] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_ERRCODE_DWLEN];
} __packed;

#define NBL_UPRBAC_PADDING_DAT0_ADDR  (0xc300)
#define NBL_UPRBAC_PADDING_DAT0_DEPTH (1)
#define NBL_UPRBAC_PADDING_DAT0_WIDTH (32)
#define NBL_UPRBAC_PADDING_DAT0_DWLEN (1)
union uprbac_padding_dat0_u {
	struct uprbac_padding_dat0 {
		u32 data:32;             /* [31:0] Default:0x01020304 RW */
	} __packed info;
	u32 data[NBL_UPRBAC_PADDING_DAT0_DWLEN];
} __packed;

#define NBL_UPRBAC_PADDING_DAT1_ADDR  (0xc304)
#define NBL_UPRBAC_PADDING_DAT1_DEPTH (1)
#define NBL_UPRBAC_PADDING_DAT1_WIDTH (32)
#define NBL_UPRBAC_PADDING_DAT1_DWLEN (1)
union uprbac_padding_dat1_u {
	struct uprbac_padding_dat1 {
		u32 data:32;             /* [31:0] Default:0x05060708 RW */
	} __packed info;
	u32 data[NBL_UPRBAC_PADDING_DAT1_DWLEN];
} __packed;

#define NBL_UPRBAC_PADDING_DAT2_ADDR  (0xc308)
#define NBL_UPRBAC_PADDING_DAT2_DEPTH (1)
#define NBL_UPRBAC_PADDING_DAT2_WIDTH (32)
#define NBL_UPRBAC_PADDING_DAT2_DWLEN (1)
union uprbac_padding_dat2_u {
	struct uprbac_padding_dat2 {
		u32 data:32;             /* [31:0] Default:0x090a0b0c RW */
	} __packed info;
	u32 data[NBL_UPRBAC_PADDING_DAT2_DWLEN];
} __packed;

#define NBL_UPRBAC_PADDING_DAT3_ADDR  (0xc30c)
#define NBL_UPRBAC_PADDING_DAT3_DEPTH (1)
#define NBL_UPRBAC_PADDING_DAT3_WIDTH (32)
#define NBL_UPRBAC_PADDING_DAT3_DWLEN (1)
union uprbac_padding_dat3_u {
	struct uprbac_padding_dat3 {
		u32 data:32;             /* [31:0] Default:0x0d0e0f10 RW */
	} __packed info;
	u32 data[NBL_UPRBAC_PADDING_DAT3_DWLEN];
} __packed;

#define NBL_UPRBAC_ACTION_PRI0_ADDR  (0xc310)
#define NBL_UPRBAC_ACTION_PRI0_DEPTH (1)
#define NBL_UPRBAC_ACTION_PRI0_WIDTH (32)
#define NBL_UPRBAC_ACTION_PRI0_DWLEN (1)
union uprbac_action_pri0_u {
	struct uprbac_action_pri0 {
		u32 id3:2;               /* [1:0] Default:0x0 RW */
		u32 id4:2;               /* [3:2] Default:0x0 RW */
		u32 id5:2;               /* [5:4] Default:0x0 RW */
		u32 id6:2;               /* [7:6] Default:0x0 RW */
		u32 id7:2;               /* [9:8] Default:0x0 RW */
		u32 id8:2;               /* [11:10] Default:0x0 RW */
		u32 id9:2;               /* [13:12] Default:0x0 RW */
		u32 id10:2;              /* [15:14] Default:0x0 RW */
		u32 id11:2;              /* [17:16] Default:0x0 RW */
		u32 id12:2;              /* [19:18] Default:0x0 RW */
		u32 id13:2;              /* [21:20] Default:0x0 RW */
		u32 id14:2;              /* [23:22] Default:0x0 RW */
		u32 id15:2;              /* [25:24] Default:0x0 RW */
		u32 id16:2;              /* [27:26] Default:0x0 RW */
		u32 id17:2;              /* [29:28] Default:0x3 RW */
		u32 id18:2;              /* [31:30] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_UPRBAC_ACTION_PRI0_DWLEN];
} __packed;

#define NBL_UPRBAC_ACTION_PRI1_ADDR  (0xc314)
#define NBL_UPRBAC_ACTION_PRI1_DEPTH (1)
#define NBL_UPRBAC_ACTION_PRI1_WIDTH (32)
#define NBL_UPRBAC_ACTION_PRI1_DWLEN (1)
union uprbac_action_pri1_u {
	struct uprbac_action_pri1 {
		u32 id19:2;              /* [1:0] Default:0x0 RW */
		u32 id20:2;              /* [3:2] Default:0x0 RW */
		u32 id21:2;              /* [5:4] Default:0x0 RW */
		u32 id22:2;              /* [7:6] Default:0x0 RW */
		u32 id23:2;              /* [9:8] Default:0x0 RW */
		u32 id24:2;              /* [11:10] Default:0x0 RW */
		u32 id25:2;              /* [13:12] Default:0x0 RW */
		u32 id26:2;              /* [15:14] Default:0x0 RW */
		u32 id27:2;              /* [17:16] Default:0x0 RW */
		u32 id28:2;              /* [19:18] Default:0x0 RW */
		u32 id29:2;              /* [21:20] Default:0x0 RW */
		u32 id30:2;              /* [23:22] Default:0x0 RW */
		u32 id31:2;              /* [25:24] Default:0x0 RW */
		u32 id32:2;              /* [27:26] Default:0x0 RW */
		u32 id33:2;              /* [29:28] Default:0x0 RW */
		u32 id34:2;              /* [31:30] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_UPRBAC_ACTION_PRI1_DWLEN];
} __packed;

#define NBL_UPRBAC_ACTION_PRI2_ADDR  (0xc318)
#define NBL_UPRBAC_ACTION_PRI2_DEPTH (1)
#define NBL_UPRBAC_ACTION_PRI2_WIDTH (32)
#define NBL_UPRBAC_ACTION_PRI2_DWLEN (1)
union uprbac_action_pri2_u {
	struct uprbac_action_pri2 {
		u32 id35:2;              /* [1:0] Default:0x0 RW */
		u32 id36:2;              /* [3:2] Default:0x0 RW */
		u32 id37:2;              /* [5:4] Default:0x0 RW */
		u32 id38:2;              /* [7:6] Default:0x0 RW */
		u32 id39:2;              /* [9:8] Default:0x0 RW */
		u32 id40:2;              /* [11:10] Default:0x0 RW */
		u32 id41:2;              /* [13:12] Default:0x0 RW */
		u32 id42:2;              /* [15:14] Default:0x0 RW */
		u32 id43:2;              /* [17:16] Default:0x0 RW */
		u32 id44:2;              /* [19:18] Default:0x0 RW */
		u32 id45:2;              /* [21:20] Default:0x0 RW */
		u32 id46:2;              /* [23:22] Default:0x0 RW */
		u32 id47:2;              /* [25:24] Default:0x0 RW */
		u32 id48:2;              /* [27:26] Default:0x0 RW */
		u32 id49:2;              /* [29:28] Default:0x0 RW */
		u32 id50:2;              /* [31:30] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_UPRBAC_ACTION_PRI2_DWLEN];
} __packed;

#define NBL_UPRBAC_ACTION_PRI3_ADDR  (0xc31c)
#define NBL_UPRBAC_ACTION_PRI3_DEPTH (1)
#define NBL_UPRBAC_ACTION_PRI3_WIDTH (32)
#define NBL_UPRBAC_ACTION_PRI3_DWLEN (1)
union uprbac_action_pri3_u {
	struct uprbac_action_pri3 {
		u32 id51:2;              /* [1:0] Default:0x0 RW */
		u32 id52:2;              /* [3:2] Default:0x0 RW */
		u32 id53:2;              /* [5:4] Default:0x0 RW */
		u32 id54:2;              /* [7:6] Default:0x0 RW */
		u32 id55:2;              /* [9:8] Default:0x0 RW */
		u32 id56:2;              /* [11:10] Default:0x0 RW */
		u32 id57:2;              /* [13:12] Default:0x0 RW */
		u32 id58:2;              /* [15:14] Default:0x0 RW */
		u32 id59:2;              /* [17:16] Default:0x0 RW */
		u32 id60:2;              /* [19:18] Default:0x0 RW */
		u32 id61:2;              /* [21:20] Default:0x0 RW */
		u32 id62:2;              /* [23:22] Default:0x0 RW */
		u32 rsv:8;               /* [31:24] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_UPRBAC_ACTION_PRI3_DWLEN];
} __packed;

#define NBL_UPRBAC_ACTION0_ADDR  (0xc328)
#define NBL_UPRBAC_ACTION0_DEPTH (1)
#define NBL_UPRBAC_ACTION0_WIDTH (32)
#define NBL_UPRBAC_ACTION0_DWLEN (1)
union uprbac_action0_u {
	struct uprbac_action0 {
		u32 action:22;           /* [21:0] Default:0x0 RW */
		u32 rsv:10;              /* [31:22] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_ACTION0_DWLEN];
} __packed;

#define NBL_UPRBAC_ACTION1_ADDR  (0xc32c)
#define NBL_UPRBAC_ACTION1_DEPTH (1)
#define NBL_UPRBAC_ACTION1_WIDTH (32)
#define NBL_UPRBAC_ACTION1_DWLEN (1)
union uprbac_action1_u {
	struct uprbac_action1 {
		u32 action:22;           /* [21:0] Default:0x0 RW */
		u32 rsv:10;              /* [31:22] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_ACTION1_DWLEN];
} __packed;

#define NBL_UPRBAC_ACTION2_ADDR  (0xc330)
#define NBL_UPRBAC_ACTION2_DEPTH (1)
#define NBL_UPRBAC_ACTION2_WIDTH (32)
#define NBL_UPRBAC_ACTION2_DWLEN (1)
union uprbac_action2_u {
	struct uprbac_action2 {
		u32 action:22;           /* [21:0] Default:0x110000 RW */
		u32 rsv:10;              /* [31:22] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_ACTION2_DWLEN];
} __packed;

#define NBL_UPRBAC_PRBAC_SET_FLAG_ADDR  (0xc334)
#define NBL_UPRBAC_PRBAC_SET_FLAG_DEPTH (1)
#define NBL_UPRBAC_PRBAC_SET_FLAG_WIDTH (32)
#define NBL_UPRBAC_PRBAC_SET_FLAG_DWLEN (1)
union uprbac_prbac_set_flag_u {
	struct uprbac_prbac_set_flag {
		u32 flag:32;             /* [31:0] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_UPRBAC_PRBAC_SET_FLAG_DWLEN];
} __packed;

#define NBL_UPRBAC_PRBAC_CLR_FLAG_ADDR  (0xc338)
#define NBL_UPRBAC_PRBAC_CLR_FLAG_DEPTH (1)
#define NBL_UPRBAC_PRBAC_CLR_FLAG_WIDTH (32)
#define NBL_UPRBAC_PRBAC_CLR_FLAG_DWLEN (1)
union uprbac_prbac_clr_flag_u {
	struct uprbac_prbac_clr_flag {
		u32 flag:32;             /* [31:0] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_UPRBAC_PRBAC_CLR_FLAG_DWLEN];
} __packed;

#define NBL_UPRBAC_NORMAL_SET_FLAG_ADDR  (0xc33c)
#define NBL_UPRBAC_NORMAL_SET_FLAG_DEPTH (1)
#define NBL_UPRBAC_NORMAL_SET_FLAG_WIDTH (32)
#define NBL_UPRBAC_NORMAL_SET_FLAG_DWLEN (1)
union uprbac_normal_set_flag_u {
	struct uprbac_normal_set_flag {
		u32 flag:32;             /* [31:0] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_UPRBAC_NORMAL_SET_FLAG_DWLEN];
} __packed;

#define NBL_UPRBAC_NORMAL_CLR_FLAG_ADDR  (0xc340)
#define NBL_UPRBAC_NORMAL_CLR_FLAG_DEPTH (1)
#define NBL_UPRBAC_NORMAL_CLR_FLAG_WIDTH (32)
#define NBL_UPRBAC_NORMAL_CLR_FLAG_DWLEN (1)
union uprbac_normal_clr_flag_u {
	struct uprbac_normal_clr_flag {
		u32 flag:32;             /* [31:0] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_UPRBAC_NORMAL_CLR_FLAG_DWLEN];
} __packed;

#define NBL_UPRBAC_UPCALL_ENABLE_ADDR  (0xc380)
#define NBL_UPRBAC_UPCALL_ENABLE_DEPTH (1)
#define NBL_UPRBAC_UPCALL_ENABLE_WIDTH (32)
#define NBL_UPRBAC_UPCALL_ENABLE_DWLEN (1)
union uprbac_upcall_enable_u {
	struct uprbac_upcall_enable {
		u32 enable:1;            /* [0] Default:0x0 RW */
		u32 rsv:31;              /* [31:1] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_UPCALL_ENABLE_DWLEN];
} __packed;

#define NBL_UPRBAC_HT_ACCESS_CTRL_ADDR  (0xc3a0)
#define NBL_UPRBAC_HT_ACCESS_CTRL_DEPTH (1)
#define NBL_UPRBAC_HT_ACCESS_CTRL_WIDTH (32)
#define NBL_UPRBAC_HT_ACCESS_CTRL_DWLEN (1)
union uprbac_ht_access_ctrl_u {
	struct uprbac_ht_access_ctrl {
		u32 ptr:2;               /* [1:0] Default:0x0 RW */
		u32 rsv1:2;              /* [3:2] Default:0x0 RO */
		u32 choice:1;            /* [4] Default:0x1 RW */
		u32 rsv:27;              /* [31:5] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_HT_ACCESS_CTRL_DWLEN];
} __packed;

#define NBL_UPRBAC_CPU_INSERT_SEARCH_CTRL_ADDR  (0xc3a4)
#define NBL_UPRBAC_CPU_INSERT_SEARCH_CTRL_DEPTH (1)
#define NBL_UPRBAC_CPU_INSERT_SEARCH_CTRL_WIDTH (32)
#define NBL_UPRBAC_CPU_INSERT_SEARCH_CTRL_DWLEN (1)
union uprbac_cpu_insert_search_ctrl_u {
	struct uprbac_cpu_insert_search_ctrl {
		u32 rsv:31;              /* [30:0] Default:0x0 RO */
		u32 start:1;             /* [31] Default:0x0 WO */
	} __packed info;
	u32 data[NBL_UPRBAC_CPU_INSERT_SEARCH_CTRL_DWLEN];
} __packed;

#define NBL_UPRBAC_CPU_INSERT_SEARCH_ACK_ADDR  (0xc3a8)
#define NBL_UPRBAC_CPU_INSERT_SEARCH_ACK_DEPTH (1)
#define NBL_UPRBAC_CPU_INSERT_SEARCH_ACK_WIDTH (32)
#define NBL_UPRBAC_CPU_INSERT_SEARCH_ACK_DWLEN (1)
union uprbac_cpu_insert_search_ack_u {
	struct uprbac_cpu_insert_search_ack {
		u32 done:1;              /* [0] Default:0x0 RC */
		u32 status:2;            /* [2:1] Default:0x0 RWW */
		u32 rsv:29;              /* [31:3] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_CPU_INSERT_SEARCH_ACK_DWLEN];
} __packed;

#define NBL_UPRBAC_CPU_INSERT_SEARCH_DATA_ADDR  (0xc3b0)
#define NBL_UPRBAC_CPU_INSERT_SEARCH_DATA_DEPTH (5)
#define NBL_UPRBAC_CPU_INSERT_SEARCH_DATA_WIDTH (32)
#define NBL_UPRBAC_CPU_INSERT_SEARCH_DATA_DWLEN (1)
union uprbac_cpu_insert_search_data_u {
	struct uprbac_cpu_insert_search_data {
		u32 data:32;             /* [31:0] Default:0x0 RWW */
	} __packed info;
	u32 data[NBL_UPRBAC_CPU_INSERT_SEARCH_DATA_DWLEN];
} __packed;
#define NBL_UPRBAC_CPU_INSERT_SEARCH_DATA_REG(r) (NBL_UPRBAC_CPU_INSERT_SEARCH_DATA_ADDR + \
		(NBL_UPRBAC_CPU_INSERT_SEARCH_DATA_DWLEN * 4) * (r))

#define NBL_UPRBAC_XOFF_TO_URMUX_ADDR  (0xc430)
#define NBL_UPRBAC_XOFF_TO_URMUX_DEPTH (1)
#define NBL_UPRBAC_XOFF_TO_URMUX_WIDTH (32)
#define NBL_UPRBAC_XOFF_TO_URMUX_DWLEN (1)
union uprbac_xoff_to_urmux_u {
	struct uprbac_xoff_to_urmux {
		u32 bp_set:1;            /* [0] Default:0x0 RW */
		u32 bp_mask:1;           /* [1] Default:0x0 RW */
		u32 rsv:30;              /* [31:2] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_XOFF_TO_URMUX_DWLEN];
} __packed;

#define NBL_UPRBAC_XOFF_FROM_UPA_ADDR  (0xc434)
#define NBL_UPRBAC_XOFF_FROM_UPA_DEPTH (1)
#define NBL_UPRBAC_XOFF_FROM_UPA_WIDTH (32)
#define NBL_UPRBAC_XOFF_FROM_UPA_DWLEN (1)
union uprbac_xoff_from_upa_u {
	struct uprbac_xoff_from_upa {
		u32 bp_set:1;            /* [0] Default:0x0 RW */
		u32 bp_mask:1;           /* [1] Default:0x0 RW */
		u32 rsv:30;              /* [31:2] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_XOFF_FROM_UPA_DWLEN];
} __packed;

#define NBL_UPRBAC_WIDE_TABLE_TIME_ADDR  (0xd000)
#define NBL_UPRBAC_WIDE_TABLE_TIME_DEPTH (1)
#define NBL_UPRBAC_WIDE_TABLE_TIME_WIDTH (32)
#define NBL_UPRBAC_WIDE_TABLE_TIME_DWLEN (1)
union uprbac_wide_table_time_u {
	struct uprbac_wide_table_time {
		u32 xoff_th:8;           /* [7:0] Default:0x80 RW */
		u32 rsv:24;              /* [31:8] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_WIDE_TABLE_TIME_DWLEN];
} __packed;

#define NBL_UPRBAC_EM_PROFILE_TABLE_ADDR  (0xe000)
#define NBL_UPRBAC_EM_PROFILE_TABLE_DEPTH (1)
#define NBL_UPRBAC_EM_PROFILE_TABLE_WIDTH (64)
#define NBL_UPRBAC_EM_PROFILE_TABLE_DWLEN (2)
union uprbac_em_profile_table_u {
	struct uprbac_em_profile_table {
		u32 pp_cmd_type:1;       /* [0] Default:0x0 RW */
		u32 key_size:1;          /* [1] Default:0x0 RW */
		u32 mask_btm_l:32;       /* [41:2] Default:0x0 RW */
		u32 mask_btm_h:8;        /* [41:2] Default:0x0 RW */
		u32 hash_sel0:2;         /* [43:42] Default:0x0 RW */
		u32 hash_sel1:2;         /* [45:44] Default:0x0 RW */
		u32 action0:1;           /* [46] Default:0x0 RW */
		u32 act_num:4;           /* [50:47] Default:0x0 RW */
		u32 vld:1;               /* [51] Default:0x0 RW */
		u32 rsv:12;              /* [63:52] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_EM_PROFILE_TABLE_DWLEN];
} __packed;

#define NBL_UPRBAC_EM_TCAM_TABLE_ADDR  (0xe800)
#define NBL_UPRBAC_EM_TCAM_TABLE_DEPTH (64)
#define NBL_UPRBAC_EM_TCAM_TABLE_WIDTH (128)
#define NBL_UPRBAC_EM_TCAM_TABLE_DWLEN (4)
union uprbac_em_tcam_table_u {
	struct uprbac_em_tcam_table {
		u32 key_dat:16;          /* [79:0] Default:0x0 RW */
		u32 key_dat_arr[2];      /* [79:0] Default:0x0 RW */
		u32 key_vld:1;           /* [80] Default:0x0 RW */
		u32 key_size:1;          /* [81] Default:0x0 RW */
		u32 rsv_l:32;            /* [127:82] Default:0x0 RO */
		u32 rsv_h:14;            /* [127:82] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_EM_TCAM_TABLE_DWLEN];
} __packed;
#define NBL_UPRBAC_EM_TCAM_TABLE_REG(r) (NBL_UPRBAC_EM_TCAM_TABLE_ADDR + \
		(NBL_UPRBAC_EM_TCAM_TABLE_DWLEN * 4) * (r))

#define NBL_UPRBAC_EM_AD_TABLE_ADDR  (0xf000)
#define NBL_UPRBAC_EM_AD_TABLE_DEPTH (64)
#define NBL_UPRBAC_EM_AD_TABLE_WIDTH (32)
#define NBL_UPRBAC_EM_AD_TABLE_DWLEN (1)
union uprbac_em_ad_table_u {
	struct uprbac_em_ad_table {
		u32 sad_index:11;        /* [10:0] Default:0x0 RW */
		u32 rsv:21;              /* [31:11] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_EM_AD_TABLE_DWLEN];
} __packed;
#define NBL_UPRBAC_EM_AD_TABLE_REG(r) (NBL_UPRBAC_EM_AD_TABLE_ADDR + \
		(NBL_UPRBAC_EM_AD_TABLE_DWLEN * 4) * (r))

#define NBL_UPRBAC_HT0_TABLE_ADDR  (0x10000)
#define NBL_UPRBAC_HT0_TABLE_DEPTH (512)
#define NBL_UPRBAC_HT0_TABLE_WIDTH (128)
#define NBL_UPRBAC_HT0_TABLE_DWLEN (4)
union uprbac_ht0_table_u {
	struct uprbac_ht0_table {
		u32 table:20;            /* [83:0] Default:0x0 RW */
		u32 table_arr[2];        /* [83:0] Default:0x0 RW */
		u32 rsv_l:32;            /* [127:84] Default:0x0 RO */
		u32 rsv_h:12;            /* [127:84] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_HT0_TABLE_DWLEN];
} __packed;
#define NBL_UPRBAC_HT0_TABLE_REG(r) (NBL_UPRBAC_HT0_TABLE_ADDR + \
		(NBL_UPRBAC_HT0_TABLE_DWLEN * 4) * (r))

#define NBL_UPRBAC_HT1_TABLE_ADDR  (0x14000)
#define NBL_UPRBAC_HT1_TABLE_DEPTH (512)
#define NBL_UPRBAC_HT1_TABLE_WIDTH (128)
#define NBL_UPRBAC_HT1_TABLE_DWLEN (4)
union uprbac_ht1_table_u {
	struct uprbac_ht1_table {
		u32 table:20;            /* [83:0] Default:0x0 RW */
		u32 table_arr[2];        /* [83:0] Default:0x0 RW */
		u32 rsv_l:32;            /* [127:84] Default:0x0 RO */
		u32 rsv_h:12;            /* [127:84] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_HT1_TABLE_DWLEN];
} __packed;
#define NBL_UPRBAC_HT1_TABLE_REG(r) (NBL_UPRBAC_HT1_TABLE_ADDR + \
		(NBL_UPRBAC_HT1_TABLE_DWLEN * 4) * (r))

#define NBL_UPRBAC_KT_TABLE_ADDR  (0x1c000)
#define NBL_UPRBAC_KT_TABLE_DEPTH (2048)
#define NBL_UPRBAC_KT_TABLE_WIDTH (256)
#define NBL_UPRBAC_KT_TABLE_DWLEN (8)
union uprbac_kt_table_u {
	struct uprbac_kt_table {
		u32 key:32;              /* [159:0] Default:0x0 RW */
		u32 key_arr[4];          /* [159:0] Default:0x0 RW */
		u32 sad_index:11;        /* [170:160] Default:0x0 RW */
		u32 rsv:21;              /* [255:171] Default:0x0 RO */
		u32 rsv_arr[2];          /* [255:171] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_KT_TABLE_DWLEN];
} __packed;
#define NBL_UPRBAC_KT_TABLE_REG(r) (NBL_UPRBAC_KT_TABLE_ADDR + \
		(NBL_UPRBAC_KT_TABLE_DWLEN * 4) * (r))

#define NBL_UPRBAC_SAD_BOTTOM_TABLE_ADDR  (0x2c000)
#define NBL_UPRBAC_SAD_BOTTOM_TABLE_DEPTH (2048)
#define NBL_UPRBAC_SAD_BOTTOM_TABLE_WIDTH (128)
#define NBL_UPRBAC_SAD_BOTTOM_TABLE_DWLEN (4)
union uprbac_sad_bottom_table_u {
	struct uprbac_sad_bottom_table {
		u32 sn:32;               /* [31:0] Default:0x0 RW */
		u32 esn:32;              /* [63:32] Default:0x0 RW */
		u32 esn_overlap:1;       /* [64] Default:0x0 RW */
		u32 esn_enable:1;        /* [65] Default:0x0 RW */
		u32 rsv_l:32;            /* [127:66] Default:0x0 RO */
		u32 rsv_h:30;            /* [127:66] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_SAD_BOTTOM_TABLE_DWLEN];
} __packed;
#define NBL_UPRBAC_SAD_BOTTOM_TABLE_REG(r) (NBL_UPRBAC_SAD_BOTTOM_TABLE_ADDR + \
		(NBL_UPRBAC_SAD_BOTTOM_TABLE_DWLEN * 4) * (r))

#define NBL_UPRBAC_SAD_LIFETIME_TABLE_ADDR  (0x3c000)
#define NBL_UPRBAC_SAD_LIFETIME_TABLE_DEPTH (2048)
#define NBL_UPRBAC_SAD_LIFETIME_TABLE_WIDTH (128)
#define NBL_UPRBAC_SAD_LIFETIME_TABLE_DWLEN (4)
union uprbac_sad_lifetime_table_u {
	struct uprbac_sad_lifetime_table {
		u32 diff:32;             /* [31:0] Default:0x0 RW */
		u32 cnt:32;              /* [63:32] Default:0x0 RW */
		u32 flag:1;              /* [64] Default:0x0 RW */
		u32 unit:1;              /* [65] Default:0x0 RW */
		u32 enable:1;            /* [66] Default:0x0 RW */
		u32 rsv_l:32;            /* [127:67] Default:0x0 RO */
		u32 rsv_h:29;            /* [127:67] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_SAD_LIFETIME_TABLE_DWLEN];
} __packed;
#define NBL_UPRBAC_SAD_LIFETIME_TABLE_REG(r) (NBL_UPRBAC_SAD_LIFETIME_TABLE_ADDR + \
		(NBL_UPRBAC_SAD_LIFETIME_TABLE_DWLEN * 4) * (r))

#define NBL_UPRBAC_SAD_CRYPTO_INFO_TABLE_ADDR  (0x4c000)
#define NBL_UPRBAC_SAD_CRYPTO_INFO_TABLE_DEPTH (2048)
#define NBL_UPRBAC_SAD_CRYPTO_INFO_TABLE_WIDTH (512)
#define NBL_UPRBAC_SAD_CRYPTO_INFO_TABLE_DWLEN (16)
union uprbac_sad_crypto_info_table_u {
	struct uprbac_sad_crypto_info_table {
		u32 key_arr[8];          /* [255:0] Default:0x0 RW */
		u32 salt:32;             /* [287:256] Default:0x0 RW */
		u32 crypto_type:3;       /* [290:288] Default:0x0 RW */
		u32 tunnel_mode:1;       /* [291] Default:0x0 RW */
		u32 icv_len:2;           /* [293:292] Default:0x0 RW */
		u32 rsv:26;              /* [511:294] Default:0x0 RO */
		u32 rsv_arr[6];          /* [511:294] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_SAD_CRYPTO_INFO_TABLE_DWLEN];
} __packed;
#define NBL_UPRBAC_SAD_CRYPTO_INFO_TABLE_REG(r) (NBL_UPRBAC_SAD_CRYPTO_INFO_TABLE_ADDR + \
		(NBL_UPRBAC_SAD_CRYPTO_INFO_TABLE_DWLEN * 4) * (r))

#define NBL_UPRBAC_SAD_SLIDE_WINDOW_TABLE_ADDR  (0x6c000)
#define NBL_UPRBAC_SAD_SLIDE_WINDOW_TABLE_DEPTH (2048)
#define NBL_UPRBAC_SAD_SLIDE_WINDOW_TABLE_WIDTH (512)
#define NBL_UPRBAC_SAD_SLIDE_WINDOW_TABLE_DWLEN (16)
union uprbac_sad_slide_window_table_u {
	struct uprbac_sad_slide_window_table {
		u32 bitmap_arr[8];       /* [255:0] Default:0x0 RW */
		u32 choice:2;            /* [257:256] Default:0x0 RW */
		u32 enable:1;            /* [258] Default:0x0 RW */
		u32 rsv_l:32;            /* [511:259] Default:0x0 RO */
		u32 rsv_h:29;            /* [511:259] Default:0x0 RO */
		u32 rsv_arr[6];          /* [511:259] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPRBAC_SAD_SLIDE_WINDOW_TABLE_DWLEN];
} __packed;
#define NBL_UPRBAC_SAD_SLIDE_WINDOW_TABLE_REG(r) (NBL_UPRBAC_SAD_SLIDE_WINDOW_TABLE_ADDR + \
		(NBL_UPRBAC_SAD_SLIDE_WINDOW_TABLE_DWLEN * 4) * (r))

#endif
