/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime.loongarch64;

import sun.jvm.hotspot.code.CodeBlob;
import sun.jvm.hotspot.code.NMethod;
import sun.jvm.hotspot.compiler.OopMapSet;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.Metadata;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.runtime.BasicObjectLock;
import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.runtime.JavaCallWrapper;
import sun.jvm.hotspot.runtime.RegisterMap;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMReg;
import sun.jvm.hotspot.runtime.loongarch64.LOONGARCH64JavaCallWrapper;
import sun.jvm.hotspot.runtime.loongarch64.LOONGARCH64RegisterMap;
import sun.jvm.hotspot.utilities.AddressOps;
import sun.jvm.hotspot.utilities.Assert;

public class LOONGARCH64Frame
extends Frame {
    private static final boolean DEBUG = System.getProperty("sun.jvm.hotspot.runtime.loongarch64.LOONGARCH64Frame.DEBUG") != null;
    private static final int JAVA_FRAME_LINK_OFFSET = 0;
    private static final int JAVA_FRAME_RETURN_ADDR_OFFSET = 1;
    private static final int JAVA_FRAME_SENDER_SP_OFFSET = 2;
    private static final int NATIVE_FRAME_LINK_OFFSET = -2;
    private static final int NATIVE_FRAME_RETURN_ADDR_OFFSET = -1;
    private static final int NATIVE_FRAME_SENDER_SP_OFFSET = 0;
    private static final int INTERPRETER_FRAME_MIRROR_OFFSET = 2;
    private static final int INTERPRETER_FRAME_SENDER_SP_OFFSET = -1;
    private static final int INTERPRETER_FRAME_LAST_SP_OFFSET = -2;
    private static final int INTERPRETER_FRAME_LOCALS_OFFSET = -3;
    private static final int INTERPRETER_FRAME_METHOD_OFFSET = -4;
    private static final int INTERPRETER_FRAME_MDX_OFFSET = 1;
    private static final int INTERPRETER_FRAME_CACHE_OFFSET = 0;
    private static final int INTERPRETER_FRAME_BCX_OFFSET = -1;
    private static final int INTERPRETER_FRAME_INITIAL_SP_OFFSET = -2;
    private static final int INTERPRETER_FRAME_MONITOR_BLOCK_TOP_OFFSET = -2;
    private static final int INTERPRETER_FRAME_MONITOR_BLOCK_BOTTOM_OFFSET = -2;
    private static final int ENTRY_FRAME_CALL_WRAPPER_OFFSET = -9;
    private static final int NATIVE_FRAME_INITIAL_PARAM_OFFSET = 2;
    private static VMReg fp = new VMReg(44);
    Address raw_fp;
    private Address raw_unextendedSP;

    private LOONGARCH64Frame() {
    }

    private void adjustForDeopt() {
        NMethod nm;
        CodeBlob cb;
        if (this.pc != null && (cb = VM.getVM().getCodeCache().findBlob(this.pc)) != null && cb.isJavaMethod() && this.pc.equals((nm = (NMethod)cb).deoptHandlerBegin())) {
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(this.getUnextendedSP() != null, "null SP in Java frame");
            }
            this.pc = this.getUnextendedSP().getAddressAt(nm.origPCOffset());
            this.deoptimized = true;
        }
    }

    public LOONGARCH64Frame(Address raw_sp, Address raw_fp, Address pc) {
        this.raw_sp = raw_sp;
        this.raw_unextendedSP = raw_sp;
        this.raw_fp = raw_fp;
        this.pc = pc;
        this.adjustUnextendedSP();
        this.adjustForDeopt();
        if (DEBUG) {
            System.out.println("LOONGARCH64Frame(sp, fp, pc): " + this);
            this.dumpStack();
        }
    }

    public LOONGARCH64Frame(Address raw_sp, Address raw_fp) {
        this.raw_sp = raw_sp;
        this.raw_unextendedSP = raw_sp;
        this.raw_fp = raw_fp;
        this.pc = raw_fp.getAddressAt(1L * VM.getVM().getAddressSize());
        this.adjustUnextendedSP();
        this.adjustForDeopt();
        if (DEBUG) {
            System.out.println("LOONGARCH64Frame(sp, fp): " + this);
            this.dumpStack();
        }
    }

    public LOONGARCH64Frame(Address raw_sp, Address raw_unextendedSp, Address raw_fp, Address pc) {
        this.raw_sp = raw_sp;
        this.raw_unextendedSP = raw_unextendedSp;
        this.raw_fp = raw_fp;
        this.pc = pc;
        this.adjustUnextendedSP();
        this.adjustForDeopt();
        if (DEBUG) {
            System.out.println("LOONGARCH64Frame(sp, unextendedSP, fp, pc): " + this);
            this.dumpStack();
        }
    }

    @Override
    public Object clone() {
        LOONGARCH64Frame frame = new LOONGARCH64Frame();
        frame.raw_sp = this.raw_sp;
        frame.raw_unextendedSP = this.raw_unextendedSP;
        frame.raw_fp = this.raw_fp;
        frame.pc = this.pc;
        frame.deoptimized = this.deoptimized;
        return frame;
    }

    @Override
    public boolean equals(Object arg) {
        if (arg == null) {
            return false;
        }
        if (!(arg instanceof LOONGARCH64Frame)) {
            return false;
        }
        LOONGARCH64Frame other = (LOONGARCH64Frame)arg;
        return AddressOps.equal(this.getSP(), other.getSP()) && AddressOps.equal(this.getUnextendedSP(), other.getUnextendedSP()) && AddressOps.equal(this.getFP(), other.getFP()) && AddressOps.equal(this.getPC(), other.getPC());
    }

    public int hashCode() {
        if (this.raw_sp == null) {
            return 0;
        }
        return this.raw_sp.hashCode();
    }

    public String toString() {
        return "sp: " + (this.getSP() == null ? "null" : this.getSP().toString()) + ", unextendedSP: " + (this.getUnextendedSP() == null ? "null" : this.getUnextendedSP().toString()) + ", fp: " + (this.getFP() == null ? "null" : this.getFP().toString()) + ", pc: " + (this.pc == null ? "null" : this.pc.toString());
    }

    @Override
    public Address getFP() {
        return this.raw_fp;
    }

    @Override
    public Address getSP() {
        return this.raw_sp;
    }

    @Override
    public Address getID() {
        return this.raw_sp;
    }

    @Override
    public boolean isSignalHandlerFrameDbg() {
        return false;
    }

    @Override
    public int getSignalNumberDbg() {
        return 0;
    }

    @Override
    public String getSignalNameDbg() {
        return null;
    }

    @Override
    public boolean isInterpretedFrameValid() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isInterpretedFrame(), "Not an interpreted frame");
        }
        if (this.getFP() == null || this.getFP().andWithMask(3L) != null) {
            return false;
        }
        if (this.getSP() == null || this.getSP().andWithMask(3L) != null) {
            return false;
        }
        if (this.getFP().addOffsetTo(-2L * VM.getVM().getAddressSize()).lessThan(this.getSP())) {
            return false;
        }
        if (this.getFP().lessThanOrEqual(this.getSP())) {
            return false;
        }
        return this.getFP().minus(this.getSP()) <= 4096L * VM.getVM().getAddressSize();
    }

    @Override
    public Frame sender(RegisterMap regMap, CodeBlob cb) {
        LOONGARCH64RegisterMap map = (LOONGARCH64RegisterMap)regMap;
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(map != null, "map must be set");
        }
        map.setIncludeArgumentOops(false);
        if (this.isEntryFrame()) {
            return this.senderForEntryFrame(map);
        }
        if (this.isInterpretedFrame()) {
            return this.senderForInterpreterFrame(map);
        }
        if (cb == null) {
            cb = VM.getVM().getCodeCache().findBlob(this.getPC());
        } else if (Assert.ASSERTS_ENABLED) {
            Assert.that(cb.equals(VM.getVM().getCodeCache().findBlob(this.getPC())), "Must be the same");
        }
        if (cb != null) {
            return this.senderForCompiledFrame(map, cb);
        }
        return new LOONGARCH64Frame(this.getSenderSP(), this.getLink(), this.getSenderPC());
    }

    private Frame senderForEntryFrame(LOONGARCH64RegisterMap map) {
        if (DEBUG) {
            System.out.println("senderForEntryFrame");
        }
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(map != null, "map must be set");
        }
        LOONGARCH64JavaCallWrapper jcw = (LOONGARCH64JavaCallWrapper)this.getEntryFrameCallWrapper();
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(!this.entryFrameIsFirst(), "next Java fp must be non zero");
            Assert.that(jcw.getLastJavaSP().greaterThan(this.getSP()), "must be above this frame on stack");
        }
        LOONGARCH64Frame fr = jcw.getLastJavaPC() != null ? new LOONGARCH64Frame(jcw.getLastJavaSP(), jcw.getLastJavaFP(), jcw.getLastJavaPC()) : new LOONGARCH64Frame(jcw.getLastJavaSP(), jcw.getLastJavaFP());
        map.clear();
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(map.getIncludeArgumentOops(), "should be set by clear");
        }
        return fr;
    }

    private void adjustUnextendedSP() {
        NMethod senderNm;
        CodeBlob cb = this.cb();
        NMethod nMethod = senderNm = cb == null ? null : cb.asNMethodOrNull();
        if (senderNm == null || senderNm.isDeoptEntry(this.getPC()) || senderNm.isDeoptMhEntry(this.getPC())) {
            // empty if block
        }
    }

    private Frame senderForInterpreterFrame(LOONGARCH64RegisterMap map) {
        if (DEBUG) {
            System.out.println("senderForInterpreterFrame");
        }
        Address unextendedSP = this.addressOfStackSlot(-1).getAddressAt(0L);
        Address sp = this.getSenderSP();
        if (map.getUpdateMap()) {
            this.updateMapWithSavedLink(map, this.addressOfStackSlot(0));
        }
        return new LOONGARCH64Frame(sp, unextendedSP, this.getLink(), this.getSenderPC());
    }

    private void updateMapWithSavedLink(RegisterMap map, Address savedFPAddr) {
        map.setLocation(fp, savedFPAddr);
    }

    private Frame senderForCompiledFrame(LOONGARCH64RegisterMap map, CodeBlob cb) {
        if (DEBUG) {
            System.out.println("senderForCompiledFrame");
        }
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(map != null, "map must be set");
        }
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(cb.getFrameSize() >= 0L, "must have non-zero frame size");
        }
        Address senderSP = this.getUnextendedSP().addOffsetTo(cb.getFrameSize());
        Address senderPC = senderSP.getAddressAt(-1L * VM.getVM().getAddressSize());
        Address savedFPAddr = senderSP.addOffsetTo(-2L * VM.getVM().getAddressSize());
        if (map.getUpdateMap()) {
            map.setIncludeArgumentOops(cb.callerMustGCArguments());
            if (cb.getOopMaps() != null) {
                OopMapSet.updateRegisterMap(this, cb, map, true);
            }
            this.updateMapWithSavedLink(map, savedFPAddr);
        }
        return new LOONGARCH64Frame(senderSP, savedFPAddr.getAddressAt(0L), senderPC);
    }

    @Override
    protected boolean hasSenderPD() {
        return true;
    }

    @Override
    public long frameSize() {
        return this.getSenderSP().minus(this.getSP()) / VM.getVM().getAddressSize();
    }

    @Override
    public Address getLink() {
        if (this.isJavaFrame()) {
            return this.addressOfStackSlot(0).getAddressAt(0L);
        }
        return this.addressOfStackSlot(-2).getAddressAt(0L);
    }

    @Override
    public Address getUnextendedSP() {
        return this.raw_unextendedSP;
    }

    public Address getSenderPCAddr() {
        if (this.isJavaFrame()) {
            return this.addressOfStackSlot(1);
        }
        return this.addressOfStackSlot(-1);
    }

    @Override
    public Address getSenderPC() {
        return this.getSenderPCAddr().getAddressAt(0L);
    }

    @Override
    public Address getSenderSP() {
        if (this.isJavaFrame()) {
            return this.addressOfStackSlot(2);
        }
        return this.addressOfStackSlot(0);
    }

    public Address getNativeParamAddr(int idx) {
        return this.addressOfStackSlot(2 + idx);
    }

    @Override
    public Address addressOfInterpreterFrameLocals() {
        return this.addressOfStackSlot(-3);
    }

    private Address addressOfInterpreterFrameBCX() {
        return this.addressOfStackSlot(-1);
    }

    @Override
    public int getInterpreterFrameBCI() {
        Address bcp = this.addressOfInterpreterFrameBCX().getAddressAt(0L);
        Address methodHandle = this.addressOfInterpreterFrameMethod().getAddressAt(0L);
        Method method = (Method)Metadata.instantiateWrapperFor(methodHandle);
        return this.bcpToBci(bcp, method);
    }

    public Address addressOfInterpreterFrameMDX() {
        return this.addressOfStackSlot(1);
    }

    @Override
    public Address addressOfInterpreterFrameExpressionStack() {
        Address monitorEnd = this.interpreterFrameMonitorEnd().address();
        return monitorEnd.addOffsetTo(-1L * VM.getVM().getAddressSize());
    }

    @Override
    public int getInterpreterFrameExpressionStackDirection() {
        return -1;
    }

    @Override
    public Address addressOfInterpreterFrameTOS() {
        return this.getSP();
    }

    @Override
    public Address addressOfInterpreterFrameTOSAt(int slot) {
        return this.addressOfInterpreterFrameTOS().addOffsetTo((long)slot * VM.getVM().getAddressSize());
    }

    @Override
    public Address getInterpreterFrameSenderSP() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isInterpretedFrame(), "interpreted frame expected");
        }
        return this.addressOfStackSlot(-1).getAddressAt(0L);
    }

    @Override
    public BasicObjectLock interpreterFrameMonitorBegin() {
        return new BasicObjectLock(this.addressOfStackSlot(-2));
    }

    @Override
    public BasicObjectLock interpreterFrameMonitorEnd() {
        Address result = this.addressOfStackSlot(-2).getAddressAt(0L);
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(AddressOps.gt(this.getFP(), result), "result must <  than frame pointer");
            Assert.that(AddressOps.lte(this.getSP(), result), "result must >= than stack pointer");
        }
        return new BasicObjectLock(result);
    }

    @Override
    public int interpreterFrameMonitorSize() {
        return BasicObjectLock.size();
    }

    @Override
    public Address addressOfInterpreterFrameMethod() {
        return this.addressOfStackSlot(-4);
    }

    @Override
    public Address addressOfInterpreterFrameCPCache() {
        return this.addressOfStackSlot(0);
    }

    @Override
    public JavaCallWrapper getEntryFrameCallWrapper() {
        return new LOONGARCH64JavaCallWrapper(this.addressOfStackSlot(-9).getAddressAt(0L));
    }

    @Override
    protected Address addressOfSavedOopResult() {
        return this.getSP().addOffsetTo((long)(VM.getVM().isClientCompiler() ? 2 : 3) * VM.getVM().getAddressSize());
    }

    @Override
    protected Address addressOfSavedReceiver() {
        return this.getSP().addOffsetTo(-4L * VM.getVM().getAddressSize());
    }

    private void dumpStack() {
        if (this.getFP() != null) {
            Address addr = this.getSP().addOffsetTo(-5L * VM.getVM().getAddressSize());
            while (AddressOps.lte(addr, this.getFP().addOffsetTo(5L * VM.getVM().getAddressSize()))) {
                System.out.println(addr + ": " + addr.getAddressAt(0L));
                addr = addr.addOffsetTo(VM.getVM().getAddressSize());
            }
        } else {
            Address addr = this.getSP().addOffsetTo(-5L * VM.getVM().getAddressSize());
            while (AddressOps.lte(addr, this.getSP().addOffsetTo(20L * VM.getVM().getAddressSize()))) {
                System.out.println(addr + ": " + addr.getAddressAt(0L));
                addr = addr.addOffsetTo(VM.getVM().getAddressSize());
            }
        }
    }
}

