/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoInternalException;
import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernException;
import com.mongodb.WriteConcernResult;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.connection.ByteBufferBsonOutput;
import com.mongodb.connection.CommandMessage;
import com.mongodb.connection.CommandResultBaseCallback;
import com.mongodb.connection.InternalConnection;
import com.mongodb.connection.MessageSettings;
import com.mongodb.connection.Protocol;
import com.mongodb.connection.ProtocolHelper;
import com.mongodb.connection.ReplyMessage;
import com.mongodb.connection.RequestMessage;
import com.mongodb.connection.ResponseBuffers;
import com.mongodb.connection.SendMessageCallback;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.event.CommandListener;
import java.util.Collections;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;
import org.bson.io.OutputBuffer;

abstract class WriteProtocol
implements Protocol<WriteConcernResult> {
    private final MongoNamespace namespace;
    private final boolean ordered;
    private final WriteConcern writeConcern;
    private CommandListener commandListener;

    public WriteProtocol(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern) {
        this.namespace = namespace;
        this.ordered = ordered;
        this.writeConcern = writeConcern;
    }

    @Override
    public void setCommandListener(CommandListener commandListener) {
        this.commandListener = commandListener;
    }

    @Override
    public WriteConcernResult execute(InternalConnection connection) {
        RequestMessage.EncodingMetadata encodingMetadata;
        WriteConcernResult writeConcernResult = null;
        RequestMessage requestMessage = null;
        do {
            int messageId;
            long startTimeNanos = System.nanoTime();
            boolean sentCommandStartedEvent = false;
            ByteBufferBsonOutput bsonOutput = new ByteBufferBsonOutput(connection);
            try {
                if (requestMessage == null) {
                    requestMessage = this.createRequestMessage(ProtocolHelper.getMessageSettings(connection.getDescription()));
                }
                encodingMetadata = requestMessage.encodeWithMetadata(bsonOutput);
                this.sendStartedEvent(connection, requestMessage, encodingMetadata, bsonOutput);
                sentCommandStartedEvent = true;
                messageId = requestMessage.getId();
                if (this.shouldAcknowledge(encodingMetadata.getNextMessage())) {
                    CommandMessage getLastErrorMessage = new CommandMessage(new MongoNamespace(this.getNamespace().getDatabaseName(), "$cmd").getFullName(), this.createGetLastErrorCommandDocument(), false, ProtocolHelper.getMessageSettings(connection.getDescription()));
                    getLastErrorMessage.encode(bsonOutput);
                    messageId = getLastErrorMessage.getId();
                }
                connection.sendMessage(bsonOutput.getByteBuffers(), messageId);
            }
            catch (RuntimeException e) {
                this.sendFailedEvent(connection, requestMessage, sentCommandStartedEvent, e, startTimeNanos);
                throw e;
            }
            finally {
                bsonOutput.close();
            }
            if (this.shouldAcknowledge(encodingMetadata.getNextMessage())) {
                ResponseBuffers responseBuffers = null;
                try {
                    responseBuffers = connection.receiveMessage(messageId);
                    ReplyMessage<BsonDocument> replyMessage = new ReplyMessage<BsonDocument>(responseBuffers, new BsonDocumentCodec(), messageId);
                    writeConcernResult = ProtocolHelper.getWriteResult(replyMessage.getDocuments().get(0), connection.getDescription().getServerAddress());
                }
                catch (WriteConcernException e) {
                    this.sendSucceededEvent(connection, requestMessage, encodingMetadata.getNextMessage(), e, startTimeNanos);
                    if (this.writeConcern.isAcknowledged()) {
                        throw e;
                    }
                    if (this.ordered) {
                        break;
                    }
                }
                catch (RuntimeException e) {
                    this.sendFailedEvent(connection, requestMessage, sentCommandStartedEvent, e, startTimeNanos);
                    throw e;
                }
                finally {
                    if (responseBuffers != null) {
                        responseBuffers.close();
                    }
                }
            }
            this.sendSucceededEvent(connection, requestMessage, encodingMetadata.getNextMessage(), writeConcernResult, startTimeNanos);
        } while ((requestMessage = encodingMetadata.getNextMessage()) != null);
        return this.writeConcern.isAcknowledged() ? writeConcernResult : WriteConcernResult.unacknowledged();
    }

    protected abstract void appendToWriteCommandResponseDocument(RequestMessage var1, RequestMessage var2, WriteConcernResult var3, BsonDocument var4);

    @Override
    public void executeAsync(InternalConnection connection, SingleResultCallback<WriteConcernResult> callback) {
        this.executeAsync(this.createRequestMessage(ProtocolHelper.getMessageSettings(connection.getDescription())), connection, callback);
    }

    private void executeAsync(RequestMessage requestMessage, InternalConnection connection, SingleResultCallback<WriteConcernResult> callback) {
        long startTimeNanos = System.nanoTime();
        boolean sentCommandStartedEvent = false;
        try {
            ByteBufferBsonOutput bsonOutput = new ByteBufferBsonOutput(connection);
            RequestMessage.EncodingMetadata encodingMetadata = ProtocolHelper.encodeMessageWithMetadata(requestMessage, bsonOutput);
            this.sendStartedEvent(connection, requestMessage, encodingMetadata, bsonOutput);
            sentCommandStartedEvent = true;
            if (this.shouldAcknowledge(encodingMetadata.getNextMessage())) {
                CommandMessage getLastErrorMessage = new CommandMessage(new MongoNamespace(this.getNamespace().getDatabaseName(), "$cmd").getFullName(), this.createGetLastErrorCommandDocument(), false, ProtocolHelper.getMessageSettings(connection.getDescription()));
                ProtocolHelper.encodeMessage(getLastErrorMessage, bsonOutput);
                WriteResultCallback receiveCallback = new WriteResultCallback(callback, new BsonDocumentCodec(), requestMessage, encodingMetadata.getNextMessage(), getLastErrorMessage.getId(), connection, startTimeNanos);
                connection.sendMessageAsync(bsonOutput.getByteBuffers(), getLastErrorMessage.getId(), new SendMessageCallback<WriteConcernResult>(connection, bsonOutput, requestMessage, getLastErrorMessage.getId(), this.getCommandName(requestMessage), startTimeNanos, this.commandListener, callback, receiveCallback));
            } else {
                connection.sendMessageAsync(bsonOutput.getByteBuffers(), requestMessage.getId(), new UnacknowledgedWriteResultCallback(callback, requestMessage, encodingMetadata.getNextMessage(), bsonOutput, connection, startTimeNanos));
            }
        }
        catch (Throwable t) {
            this.sendFailedEvent(connection, requestMessage, sentCommandStartedEvent, t, startTimeNanos);
            callback.onResult(null, t);
        }
    }

    protected abstract BsonDocument getAsWriteCommand(ByteBufferBsonOutput var1, int var2);

    protected BsonDocument getBaseCommandDocument(String commandName) {
        BsonDocument baseCommandDocument = new BsonDocument(commandName, new BsonString(this.getNamespace().getCollectionName())).append("ordered", BsonBoolean.valueOf(this.isOrdered()));
        if (!this.writeConcern.isServerDefault()) {
            baseCommandDocument.append("writeConcern", this.writeConcern.asDocument());
        }
        return baseCommandDocument;
    }

    protected String getCommandName(RequestMessage message) {
        switch (message.getOpCode()) {
            case OP_INSERT: {
                return "insert";
            }
            case OP_UPDATE: {
                return "update";
            }
            case OP_DELETE: {
                return "delete";
            }
        }
        throw new MongoInternalException("Unexpected op code for write: " + (Object)((Object)message.getOpCode()));
    }

    private void sendStartedEvent(InternalConnection connection, RequestMessage message, RequestMessage.EncodingMetadata encodingMetadata, ByteBufferBsonOutput bsonOutput) {
        if (this.commandListener != null) {
            ProtocolHelper.sendCommandStartedEvent(message, this.namespace.getDatabaseName(), this.getCommandName(message), this.getAsWriteCommand(bsonOutput, encodingMetadata.getFirstDocumentPosition()), connection.getDescription(), this.commandListener);
        }
    }

    private void sendSucceededEvent(InternalConnection connection, RequestMessage message, RequestMessage nextMessage, WriteConcernException e, long startTimeNanos) {
        if (this.commandListener != null) {
            this.sendSucceededEvent(connection, message, this.getResponseDocument(message, nextMessage, e.getWriteConcernResult(), e), startTimeNanos);
        }
    }

    private void sendSucceededEvent(InternalConnection connection, RequestMessage message, RequestMessage nextMessage, WriteConcernResult writeConcernResult, long startTimeNanos) {
        if (this.commandListener != null) {
            this.sendSucceededEvent(connection, message, this.getResponseDocument(message, nextMessage, writeConcernResult, null), startTimeNanos);
        }
    }

    private void sendSucceededEvent(InternalConnection connection, RequestMessage message, BsonDocument responseDocument, long startTimeNanos) {
        if (this.commandListener != null) {
            ProtocolHelper.sendCommandSucceededEvent(message, this.getCommandName(message), responseDocument, connection.getDescription(), startTimeNanos, this.commandListener);
        }
    }

    private void sendFailedEvent(InternalConnection connection, RequestMessage message, boolean sentCommandStartedEvent, Throwable t, long startTimeNanos) {
        if (this.commandListener != null && sentCommandStartedEvent) {
            ProtocolHelper.sendCommandFailedEvent(message, this.getCommandName(message), connection.getDescription(), startTimeNanos, t, this.commandListener);
        }
    }

    private BsonDocument getResponseDocument(RequestMessage curMessage, RequestMessage nextMessage, WriteConcernResult writeConcernResult, WriteConcernException writeConcernException) {
        BsonDocument response = new BsonDocument("ok", new BsonInt32(1));
        if (this.writeConcern.isAcknowledged()) {
            if (writeConcernException == null) {
                this.appendToWriteCommandResponseDocument(curMessage, nextMessage, writeConcernResult, response);
            } else {
                response.put("n", new BsonInt32(0));
                BsonDocument writeErrorDocument = new BsonDocument("index", new BsonInt32(0)).append("code", new BsonInt32(writeConcernException.getErrorCode()));
                if (writeConcernException.getErrorMessage() != null) {
                    writeErrorDocument.append("errmsg", new BsonString(writeConcernException.getErrorMessage()));
                }
                response.put("writeErrors", new BsonArray(Collections.singletonList(writeErrorDocument)));
            }
        }
        return response;
    }

    private boolean shouldAcknowledge(RequestMessage nextMessage) {
        return this.writeConcern.isAcknowledged() || this.isOrdered() && nextMessage != null;
    }

    private BsonDocument createGetLastErrorCommandDocument() {
        BsonDocument command = new BsonDocument("getlasterror", new BsonInt32(1));
        command.putAll(this.writeConcern.asDocument());
        return command;
    }

    protected abstract RequestMessage createRequestMessage(MessageSettings var1);

    protected MongoNamespace getNamespace() {
        return this.namespace;
    }

    protected boolean isOrdered() {
        return this.ordered;
    }

    protected WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    protected abstract Logger getLogger();

    private final class UnacknowledgedWriteResultCallback
    implements SingleResultCallback<Void> {
        private final SingleResultCallback<WriteConcernResult> callback;
        private final RequestMessage message;
        private final RequestMessage nextMessage;
        private final OutputBuffer writtenBuffer;
        private final InternalConnection connection;
        private final long startTimeNanos;

        UnacknowledgedWriteResultCallback(SingleResultCallback<WriteConcernResult> callback, RequestMessage message, RequestMessage nextMessage, OutputBuffer writtenBuffer, InternalConnection connection, long startTimeNanos) {
            this.callback = callback;
            this.message = message;
            this.nextMessage = nextMessage;
            this.connection = connection;
            this.writtenBuffer = writtenBuffer;
            this.startTimeNanos = startTimeNanos;
        }

        @Override
        public void onResult(Void result, Throwable t) {
            this.writtenBuffer.close();
            if (t != null) {
                WriteProtocol.this.sendFailedEvent(this.connection, this.message, true, t, this.startTimeNanos);
                this.callback.onResult(null, t);
            } else {
                WriteProtocol.this.sendSucceededEvent(this.connection, this.message, this.nextMessage, null, this.startTimeNanos);
                if (this.nextMessage != null) {
                    WriteProtocol.this.executeAsync(this.nextMessage, this.connection, this.callback);
                } else {
                    this.callback.onResult(WriteConcernResult.unacknowledged(), null);
                }
            }
        }
    }

    private final class WriteResultCallback
    extends CommandResultBaseCallback<BsonDocument> {
        private final SingleResultCallback<WriteConcernResult> callback;
        private final RequestMessage message;
        private final RequestMessage nextMessage;
        private final InternalConnection connection;
        private final long startTimeNanos;

        public WriteResultCallback(SingleResultCallback<WriteConcernResult> callback, Decoder<BsonDocument> decoder, RequestMessage message, RequestMessage nextMessage, long requestId, InternalConnection connection, long startTimeNanos) {
            super(decoder, requestId, connection.getDescription().getServerAddress());
            this.callback = callback;
            this.message = message;
            this.nextMessage = nextMessage;
            this.connection = connection;
            this.startTimeNanos = startTimeNanos;
        }

        @Override
        protected void callCallback(BsonDocument result, Throwable throwableFromCallback) {
            if (throwableFromCallback != null) {
                WriteProtocol.this.sendFailedEvent(this.connection, this.message, true, throwableFromCallback, this.startTimeNanos);
                this.callback.onResult(null, throwableFromCallback);
            } else {
                try {
                    try {
                        boolean shouldWriteNextMessage;
                        WriteConcernResult writeConcernResult;
                        block12: {
                            writeConcernResult = null;
                            shouldWriteNextMessage = true;
                            try {
                                writeConcernResult = ProtocolHelper.getWriteResult(result, this.connection.getDescription().getServerAddress());
                            }
                            catch (WriteConcernException e) {
                                if (WriteProtocol.this.writeConcern.isAcknowledged()) {
                                    throw e;
                                }
                                if (!WriteProtocol.this.ordered) break block12;
                                shouldWriteNextMessage = false;
                            }
                        }
                        WriteProtocol.this.sendSucceededEvent(this.connection, this.message, this.nextMessage, writeConcernResult, this.startTimeNanos);
                        if (shouldWriteNextMessage && this.nextMessage != null) {
                            WriteProtocol.this.executeAsync(this.nextMessage, this.connection, this.callback);
                        } else {
                            this.callback.onResult(writeConcernResult, null);
                        }
                    }
                    catch (WriteConcernException e) {
                        WriteProtocol.this.sendSucceededEvent(this.connection, this.message, this.nextMessage, e, this.startTimeNanos);
                        throw e;
                    }
                    catch (RuntimeException e) {
                        WriteProtocol.this.sendFailedEvent(this.connection, this.message, true, e, this.startTimeNanos);
                        throw e;
                    }
                }
                catch (Throwable t) {
                    this.callback.onResult(null, t);
                }
            }
        }
    }
}

