/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"time"
	"reflect"
)


// RepositoriesPythonVersionsAPIService RepositoriesPythonVersionsAPI service
type RepositoriesPythonVersionsAPIService service

type RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsDeleteRequest struct {
	ctx context.Context
	ApiService *RepositoriesPythonVersionsAPIService
	pythonPythonRepositoryVersionHref string
}

func (r RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsDeleteRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesPythonPythonVersionsDeleteExecute(r)
}

/*
RepositoriesPythonPythonVersionsDelete Delete a repository version

Trigger an asynchronous task to delete a repository version.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param pythonPythonRepositoryVersionHref
 @return RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsDeleteRequest
*/
func (a *RepositoriesPythonVersionsAPIService) RepositoriesPythonPythonVersionsDelete(ctx context.Context, pythonPythonRepositoryVersionHref string) RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsDeleteRequest {
	return RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsDeleteRequest{
		ApiService: a,
		ctx: ctx,
		pythonPythonRepositoryVersionHref: pythonPythonRepositoryVersionHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesPythonVersionsAPIService) RepositoriesPythonPythonVersionsDeleteExecute(r RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsDeleteRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesPythonVersionsAPIService.RepositoriesPythonPythonVersionsDelete")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{python_python_repository_version_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"python_python_repository_version_href"+"}", parameterValueToString(r.pythonPythonRepositoryVersionHref, "pythonPythonRepositoryVersionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest struct {
	ctx context.Context
	ApiService *RepositoriesPythonVersionsAPIService
	pythonPythonRepositoryHref string
	content *string
	contentIn *string
	limit *int32
	number *int32
	numberGt *int32
	numberGte *int32
	numberLt *int32
	numberLte *int32
	numberRange *[]int32
	offset *int32
	ordering *[]string
	pulpCreated *time.Time
	pulpCreatedGt *time.Time
	pulpCreatedGte *time.Time
	pulpCreatedLt *time.Time
	pulpCreatedLte *time.Time
	pulpCreatedRange *[]time.Time
	pulpHrefIn *[]string
	fields *[]string
	excludeFields *[]string
}

// Content Unit referenced by HREF
func (r RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest) Content(content string) RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest {
	r.content = &content
	return r
}

// Content Unit referenced by HREF
func (r RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest) ContentIn(contentIn string) RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest {
	r.contentIn = &contentIn
	return r
}

// Number of results to return per page.
func (r RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest) Limit(limit int32) RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest {
	r.limit = &limit
	return r
}

// Filter results where number matches value
func (r RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest) Number(number int32) RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest {
	r.number = &number
	return r
}

// Filter results where number is greater than value
func (r RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest) NumberGt(numberGt int32) RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest {
	r.numberGt = &numberGt
	return r
}

// Filter results where number is greater than or equal to value
func (r RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest) NumberGte(numberGte int32) RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest {
	r.numberGte = &numberGte
	return r
}

// Filter results where number is less than value
func (r RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest) NumberLt(numberLt int32) RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest {
	r.numberLt = &numberLt
	return r
}

// Filter results where number is less than or equal to value
func (r RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest) NumberLte(numberLte int32) RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest {
	r.numberLte = &numberLte
	return r
}

// Filter results where number is between two comma separated values
func (r RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest) NumberRange(numberRange []int32) RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest {
	r.numberRange = &numberRange
	return r
}

// The initial index from which to return the results.
func (r RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest) Offset(offset int32) RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;number&#x60; - Number * &#x60;-number&#x60; - Number (descending) * &#x60;complete&#x60; - Complete * &#x60;-complete&#x60; - Complete (descending) * &#x60;info&#x60; - Info * &#x60;-info&#x60; - Info (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest) Ordering(ordering []string) RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest {
	r.ordering = &ordering
	return r
}

// Filter results where pulp_created matches value
func (r RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest) PulpCreated(pulpCreated time.Time) RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest {
	r.pulpCreated = &pulpCreated
	return r
}

// Filter results where pulp_created is greater than value
func (r RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest) PulpCreatedGt(pulpCreatedGt time.Time) RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest {
	r.pulpCreatedGt = &pulpCreatedGt
	return r
}

// Filter results where pulp_created is greater than or equal to value
func (r RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest) PulpCreatedGte(pulpCreatedGte time.Time) RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest {
	r.pulpCreatedGte = &pulpCreatedGte
	return r
}

// Filter results where pulp_created is less than value
func (r RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest) PulpCreatedLt(pulpCreatedLt time.Time) RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest {
	r.pulpCreatedLt = &pulpCreatedLt
	return r
}

// Filter results where pulp_created is less than or equal to value
func (r RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest) PulpCreatedLte(pulpCreatedLte time.Time) RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest {
	r.pulpCreatedLte = &pulpCreatedLte
	return r
}

// Filter results where pulp_created is between two comma separated values
func (r RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest) PulpCreatedRange(pulpCreatedRange []time.Time) RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest {
	r.pulpCreatedRange = &pulpCreatedRange
	return r
}

// Multiple values may be separated by commas.
func (r RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest) PulpHrefIn(pulpHrefIn []string) RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// A list of fields to include in the response.
func (r RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest) Fields(fields []string) RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest) ExcludeFields(excludeFields []string) RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest) Execute() (*PaginatedRepositoryVersionResponseList, *http.Response, error) {
	return r.ApiService.RepositoriesPythonPythonVersionsListExecute(r)
}

/*
RepositoriesPythonPythonVersionsList List repository versions

PythonRepositoryVersion represents a single Python repository version.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param pythonPythonRepositoryHref
 @return RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest
*/
func (a *RepositoriesPythonVersionsAPIService) RepositoriesPythonPythonVersionsList(ctx context.Context, pythonPythonRepositoryHref string) RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest {
	return RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest{
		ApiService: a,
		ctx: ctx,
		pythonPythonRepositoryHref: pythonPythonRepositoryHref,
	}
}

// Execute executes the request
//  @return PaginatedRepositoryVersionResponseList
func (a *RepositoriesPythonVersionsAPIService) RepositoriesPythonPythonVersionsListExecute(r RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsListRequest) (*PaginatedRepositoryVersionResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedRepositoryVersionResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesPythonVersionsAPIService.RepositoriesPythonPythonVersionsList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{python_python_repository_href}versions/"
	localVarPath = strings.Replace(localVarPath, "{"+"python_python_repository_href"+"}", parameterValueToString(r.pythonPythonRepositoryHref, "pythonPythonRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.content != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "content", r.content, "")
	}
	if r.contentIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "content__in", r.contentIn, "")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.number != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "number", r.number, "")
	}
	if r.numberGt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "number__gt", r.numberGt, "")
	}
	if r.numberGte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "number__gte", r.numberGte, "")
	}
	if r.numberLt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "number__lt", r.numberLt, "")
	}
	if r.numberLte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "number__lte", r.numberLte, "")
	}
	if r.numberRange != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "number__range", r.numberRange, "csv")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpCreated != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created", r.pulpCreated, "")
	}
	if r.pulpCreatedGt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created__gt", r.pulpCreatedGt, "")
	}
	if r.pulpCreatedGte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created__gte", r.pulpCreatedGte, "")
	}
	if r.pulpCreatedLt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created__lt", r.pulpCreatedLt, "")
	}
	if r.pulpCreatedLte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created__lte", r.pulpCreatedLte, "")
	}
	if r.pulpCreatedRange != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_created__range", r.pulpCreatedRange, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsReadRequest struct {
	ctx context.Context
	ApiService *RepositoriesPythonVersionsAPIService
	pythonPythonRepositoryVersionHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsReadRequest) Fields(fields []string) RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsReadRequest) ExcludeFields(excludeFields []string) RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsReadRequest) Execute() (*RepositoryVersionResponse, *http.Response, error) {
	return r.ApiService.RepositoriesPythonPythonVersionsReadExecute(r)
}

/*
RepositoriesPythonPythonVersionsRead Inspect a repository version

PythonRepositoryVersion represents a single Python repository version.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param pythonPythonRepositoryVersionHref
 @return RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsReadRequest
*/
func (a *RepositoriesPythonVersionsAPIService) RepositoriesPythonPythonVersionsRead(ctx context.Context, pythonPythonRepositoryVersionHref string) RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsReadRequest {
	return RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsReadRequest{
		ApiService: a,
		ctx: ctx,
		pythonPythonRepositoryVersionHref: pythonPythonRepositoryVersionHref,
	}
}

// Execute executes the request
//  @return RepositoryVersionResponse
func (a *RepositoriesPythonVersionsAPIService) RepositoriesPythonPythonVersionsReadExecute(r RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsReadRequest) (*RepositoryVersionResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *RepositoryVersionResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesPythonVersionsAPIService.RepositoriesPythonPythonVersionsRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{python_python_repository_version_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"python_python_repository_version_href"+"}", parameterValueToString(r.pythonPythonRepositoryVersionHref, "pythonPythonRepositoryVersionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsRepairRequest struct {
	ctx context.Context
	ApiService *RepositoriesPythonVersionsAPIService
	pythonPythonRepositoryVersionHref string
	repair *Repair
}

func (r RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsRepairRequest) Repair(repair Repair) RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsRepairRequest {
	r.repair = &repair
	return r
}

func (r RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsRepairRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesPythonPythonVersionsRepairExecute(r)
}

/*
RepositoriesPythonPythonVersionsRepair Method for RepositoriesPythonPythonVersionsRepair

Trigger an asynchronous task to repair a repository version.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param pythonPythonRepositoryVersionHref
 @return RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsRepairRequest
*/
func (a *RepositoriesPythonVersionsAPIService) RepositoriesPythonPythonVersionsRepair(ctx context.Context, pythonPythonRepositoryVersionHref string) RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsRepairRequest {
	return RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsRepairRequest{
		ApiService: a,
		ctx: ctx,
		pythonPythonRepositoryVersionHref: pythonPythonRepositoryVersionHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesPythonVersionsAPIService) RepositoriesPythonPythonVersionsRepairExecute(r RepositoriesPythonVersionsAPIRepositoriesPythonPythonVersionsRepairRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesPythonVersionsAPIService.RepositoriesPythonPythonVersionsRepair")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{python_python_repository_version_href}repair/"
	localVarPath = strings.Replace(localVarPath, "{"+"python_python_repository_version_href"+"}", parameterValueToString(r.pythonPythonRepositoryVersionHref, "pythonPythonRepositoryVersionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.repair == nil {
		return localVarReturnValue, nil, reportError("repair is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.repair
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
