/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.base;

import com.netscape.certsrv.authentication.AuthCredentials;
import com.netscape.certsrv.authority.IAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.logging.event.AuthEvent;
import com.netscape.certsrv.logging.event.AuthzEvent;
import com.netscape.certsrv.logging.event.RoleAssumeEvent;
import com.netscape.cms.servlet.base.UserInfo;
import com.netscape.cms.servlet.common.CMSFileLoader;
import com.netscape.cms.servlet.common.CMSGateway;
import com.netscape.cms.servlet.common.CMSLoadTemplate;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cms.servlet.common.GenErrorTemplateFiller;
import com.netscape.cms.servlet.common.GenPendingTemplateFiller;
import com.netscape.cms.servlet.common.GenRejectedTemplateFiller;
import com.netscape.cms.servlet.common.GenSuccessTemplateFiller;
import com.netscape.cms.servlet.common.GenSvcPendingTemplateFiller;
import com.netscape.cms.servlet.common.GenUnexpectedErrorTemplateFiller;
import com.netscape.cms.servlet.common.ICMSTemplateFiller;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.apps.CommandQueue;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.authorization.AuthzSubsystem;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestQueue;
import com.netscape.cmscore.request.RequestRepository;
import com.netscape.cmscore.security.JssSubsystem;
import com.netscape.cmscore.usrgrp.Group;
import com.netscape.cmscore.usrgrp.UGSubsystem;
import com.netscape.cmsutil.xml.XMLObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;
import org.dogtagpki.server.authentication.AuthManager;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthorizationConfig;
import org.dogtagpki.server.authorization.AuthzToken;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.CRLExtensions;
import org.mozilla.jss.netscape.security.x509.CRLReasonExtension;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.RevocationReason;
import org.mozilla.jss.netscape.security.x509.RevokedCertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public abstract class CMSServlet
extends HttpServlet {
    public static Logger logger = LoggerFactory.getLogger(CMSServlet.class);
    private static final long serialVersionUID = -3886300199374147160L;
    public static final String SUCCESS = "0";
    public static final String FAILURE = "1";
    public static final String AUTH_FAILURE = "2";
    public static final String PROP_ID = "ID";
    public static final String PROP_AUTHORITY = "authority";
    public static final String PROP_AUTHORITYID = "authorityId";
    public static final String PROP_AUTHMGR = "AuthMgr";
    public static final String PROP_CLIENTAUTH = "GetClientCert";
    public static final String PROP_RESOURCEID = "resourceID";
    public static final String PROP_AUTHZ_MGR = "AuthzMgr";
    public static final String PROP_ACL = "ACLinfo";
    public static final String AUTHZ_MGR_BASIC = "BasicAclAuthz";
    public static final String AUTHZ_MGR_LDAP = "DirAclAuthz";
    private static final String HDR_LANG = "accept-language";
    public static final String PROP_FINAL_ERROR_MSG = "finalErrorMsg";
    public static final String ERROR_MSG_TOKEN = "$ERROR_MSG";
    public static final String FINAL_ERROR_MSG = "<HTML>\n<BODY BGCOLOR=white>\n<P>\nThe Certificate System has encountered an unrecoverable error.\n<P>\nError Message:<BR>\n<I>$ERROR_MSG</I>\n<P>\nPlease contact your local administrator for assistance.\n</BODY>\n</HTML>\n";
    protected static final String PROP_UNAUTHORIZED_TEMPLATE = "unauthorizedTemplate";
    protected static final String UNAUTHORIZED_TEMPLATE = "/GenUnauthorized.template";
    protected static final String PROP_SUCCESS_TEMPLATE = "successTemplate";
    protected static final String SUCCESS_TEMPLATE = "/GenSuccess.template";
    protected static final String PROP_PENDING_TEMPLATE = "pendingTemplate";
    protected static final String PENDING_TEMPLATE = "/GenPending.template";
    protected static final String PROP_SVC_PENDING_TEMPLATE = "svcpendingTemplate";
    protected static final String SVC_PENDING_TEMPLATE = "/GenSvcPending.template";
    protected static final String PROP_REJECTED_TEMPLATE = "rejectedTemplate";
    protected static final String REJECTED_TEMPLATE = "/GenRejected.template";
    protected static final String PROP_ERROR_TEMPLATE = "errorTemplate";
    protected static final String ERROR_TEMPLATE = "/GenError.template";
    protected static final String PROP_EXCEPTION_TEMPLATE = "unexpectedErrorTemplate";
    protected static final String EXCEPTION_TEMPLATE = "/GenUnexpectedError.template";
    private static final String PROP_UNAUTHOR_TEMPLATE_FILLER = "unauthorizedTemplateFiller";
    protected static final String PROP_SUCCESS_TEMPLATE_FILLER = "successTemplateFiller";
    private static final String PROP_ERROR_TEMPLATE_FILLER = "errorTemplateFiller";
    protected static final String PROP_PENDING_TEMPLATE_FILLER = "pendingTemplateFiller";
    private static final String PROP_SVC_PENDING_TEMPLATE_FILLER = "svcpendingTemplateFiller";
    private static final String PROP_REJECTED_TEMPLATE_FILLER = "rejectedTemplateFiller";
    private static final String PROP_EXCEPTION_TEMPLATE_FILLER = "exceptionTemplateFiller";
    protected static final String RA_AGENT_GROUP = "Registration Manager Agents";
    protected static final String CA_AGENT_GROUP = "Certificate Manager Agents";
    protected static final String KRA_AGENT_GROUP = "Data Recovery Manager Agents";
    protected static final String OCSP_AGENT_GROUP = "Online Certificate Status Manager Agents";
    protected static final String TRUSTED_RA_GROUP = "Trusted Managers";
    protected static final String ADMIN_GROUP = "Administrators";
    private static final String PROP_DONT_SAVE_HTTP_PARAMS = "dontSaveHttpParams";
    private static final String[] DONT_SAVE_HTTP_PARAMS = new String[]{"pwd", "password", "passwd", "challengePassword", "confirmChallengePassword"};
    private static final String PROP_SAVE_HTTP_HEADERS = "saveHttpHeaders";
    private static final String[] SAVE_HTTP_HEADERS = new String[]{"accept-language", "user-agent"};
    public static final String PFX_HTTP_HEADER = "HTTP_HEADER";
    public static final String PFX_HTTP_PARAM = "HTTP_PARAM";
    public static final String PFX_AUTH_TOKEN = "AUTH_TOKEN";
    protected static final String AUTHMGR_PARAM = "authenticator";
    public static final String CERT_ATTR = "javax.servlet.request.X509Certificate";
    protected ServletConfig servletConfig;
    protected ServletContext servletContext;
    protected boolean mRenderResult = true;
    protected String mFinalErrorMsg = "<HTML>\n<BODY BGCOLOR=white>\n<P>\nThe Certificate System has encountered an unrecoverable error.\n<P>\nError Message:<BR>\n<I>$ERROR_MSG</I>\n<P>\nPlease contact your local administrator for assistance.\n</BODY>\n</HTML>\n";
    protected Hashtable<Integer, CMSLoadTemplate> mTemplates = new Hashtable();
    private CMSFileLoader mFileLoader = null;
    protected Vector<String> mDontSaveHttpParams = new Vector();
    protected Vector<String> mSaveHttpHeaders = new Vector();
    protected String mId = null;
    protected ConfigStore mConfig;
    protected IAuthority mAuthority = null;
    protected RequestRepository requestRepository;
    protected RequestQueue mRequestQueue;
    private MessageDigest mSHADigest = null;
    protected String mGetClientCert = "false";
    protected String mAuthMgr = null;
    protected AuthzSubsystem mAuthz;
    protected String mAclMethod = null;
    protected String mAuthzResourceName = null;
    protected String mOutputTemplatePath = null;
    private static final String PRESERVED = "preserved";
    public static final String TEMPLATE_NAME = "templateName";
    private static String CMMF_RESPONSE = "cmmfResponse";
    protected static final String IMPORT_CERT = "importCert";
    protected static final String IMPORT_CHAIN = "importCAChain";
    protected static final String IMPORT_CERT_MIME_TYPE = "importCertMimeType";
    protected static final String NS_X509_USER_CERT = "application/x-x509-user-cert";
    protected static final String NS_X509_EMAIL_CERT = "application/x-x509-email-cert";
    public static final String SIMPLE_ENROLLMENT_REQUEST = "application/pkcs10";
    public static final String SIMPLE_ENROLLMENT_RESPONSE = "application/pkcs7-mime";
    public static final String FULL_ENROLLMENT_REQUEST = "application/pkcs7-mime";
    public static final String FULL_ENROLLMENT_RESPONSE = "application/pkcs7-mime";
    public static String FULL_RESPONSE = "fullResponse";

    public static Hashtable<String, String> toHashtable(HttpServletRequest req) {
        Hashtable<String, String> httpReqHash = new Hashtable<String, String>();
        Enumeration names = req.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            httpReqHash.put(name, req.getParameter(name));
        }
        return httpReqHash;
    }

    public CMSEngine getCMSEngine() {
        return (CMSEngine)this.servletContext.getAttribute("engine");
    }

    public String initializeAuthz(ServletConfig sc, AuthzSubsystem authz, String id) throws EBaseException {
        CMSEngine engine = this.getCMSEngine();
        EngineConfig cs = engine.getConfig();
        String srcType = "ldap";
        try {
            AuthorizationConfig authzConfig = cs.getAuthorizationConfig();
            srcType = authzConfig.getSourceType();
        }
        catch (EBaseException e) {
            logger.warn("CMSServlet: " + CMS.getLogMessage("ADMIN_SRVLT_FAIL_SRC_TYPE", new Object[0]));
        }
        String aclMethod = null;
        if (!srcType.equalsIgnoreCase("web.xml")) {
            aclMethod = AUTHZ_MGR_LDAP;
            logger.debug("CMSServlet: " + CMS.getLogMessage("ADMIN_SRVLT_AUTH_LDAP_NOT_XML", id));
            return aclMethod;
        }
        logger.debug("CMSServlet: " + CMS.getLogMessage("ADMIN_SRVLT_AUTHZ_INITED", ""));
        aclMethod = sc.getInitParameter(PROP_AUTHZ_MGR);
        if (aclMethod == null || !aclMethod.equalsIgnoreCase(AUTHZ_MGR_BASIC)) {
            logger.warn("CMSServlet: " + CMS.getLogMessage("ADMIN_SRVLT_PROP_ACL_NOT_SPEC", PROP_AUTHZ_MGR, id, AUTHZ_MGR_LDAP));
            return aclMethod;
        }
        String aclInfo = sc.getInitParameter(PROP_ACL);
        if (aclInfo == null) {
            logger.warn("CMSServlet: " + CMS.getLogMessage("ADMIN_SRVLT_PROP_ACL_NOT_SPEC", PROP_ACL, id, AUTHZ_MGR_LDAP));
            return aclMethod;
        }
        authz.addACLInfo(aclMethod, aclInfo);
        logger.debug("CMSServlet: " + CMS.getLogMessage("ADMIN_SRVLT_AUTHZ_MGR_INIT_DONE", id));
        return aclMethod;
    }

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.servletConfig = sc;
        this.servletContext = sc.getServletContext();
        CMSEngine engine = this.getCMSEngine();
        EngineConfig cs = engine.getConfig();
        this.mAuthz = engine.getAuthzSubsystem();
        this.mId = sc.getInitParameter(PROP_ID);
        try {
            this.mAclMethod = this.initializeAuthz(sc, this.mAuthz, this.mId);
        }
        catch (EBaseException e) {
            logger.error("CMSServlet: " + e.getMessage(), (Throwable)e);
            throw new ServletException("Failed to init authz info from xml config file: " + e.getMessage(), (Throwable)e);
        }
        this.mConfig = cs.getSubStore("cmsgateway", ConfigStore.class);
        this.mFileLoader = new CMSFileLoader();
        this.mGetClientCert = sc.getInitParameter(PROP_CLIENTAUTH);
        this.mAuthMgr = sc.getInitParameter(PROP_AUTHMGR);
        this.mAuthzResourceName = sc.getInitParameter(PROP_RESOURCEID);
        this.mOutputTemplatePath = sc.getInitParameter("templatePath");
        String authority = sc.getInitParameter(PROP_AUTHORITY);
        if (authority == null) {
            authority = sc.getInitParameter(PROP_AUTHORITYID);
        }
        if (authority != null) {
            this.mAuthority = (IAuthority)((Object)engine.getSubsystem(authority));
        }
        this.requestRepository = engine.getRequestRepository();
        if (this.mAuthority != null) {
            this.mRequestQueue = engine.getRequestQueue();
        }
        this.setDefaultTemplates(sc);
        try {
            String eMsg = sc.getInitParameter(PROP_FINAL_ERROR_MSG);
            if (eMsg != null) {
                this.mFinalErrorMsg = eMsg;
            }
            Enumeration<CMSLoadTemplate> templs = this.mTemplates.elements();
            while (templs.hasMoreElements()) {
                ICMSTemplateFiller filler;
                String fillerName;
                CMSLoadTemplate templ = templs.nextElement();
                if (templ == null || templ.mPropName == null) continue;
                String tName = sc.getInitParameter(templ.mPropName);
                if (tName != null) {
                    templ.mTemplateName = tName;
                }
                if ((fillerName = sc.getInitParameter(templ.mFillerPropName)) == null || (filler = this.newFillerObject(fillerName)) == null) continue;
                templ.mFiller = filler;
            }
            this.getDontSaveHttpParams(sc);
            this.getSaveHttpHeaders(sc);
        }
        catch (Exception e) {
            logger.error(CMS.getLogMessage("CMSGW_ERR_CONF_TEMP_PARAMS", e.toString()), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        try {
            this.mSHADigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(CMS.getLogMessage("CMSGW_ERR_CONF_TEMP_PARAMS", e.toString()), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    public String getId() {
        return this.mId;
    }

    public String getAuthMgr() {
        return this.mAuthMgr;
    }

    public boolean isClientCertRequired() {
        return this.mGetClientCert != null && this.mGetClientCert.equals("true");
    }

    public void outputHttpParameters(HttpServletRequest httpReq) {
        logger.debug("CMSServlet:service() uri: " + httpReq.getRequestURI());
        Enumeration paramNames = httpReq.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String pn = (String)paramNames.nextElement();
            String value = CMS.isSensitive(pn) ? "(sensitive)" : httpReq.getParameter(pn);
            logger.debug("CMSServlet::service() param name='{}' value='{}'", (Object)pn, (Object)value);
        }
    }

    public void service(HttpServletRequest httpReq, HttpServletResponse httpResp) throws ServletException, IOException {
        CMSEngine engine = this.getCMSEngine();
        EngineConfig cs = engine.getConfig();
        boolean running_state = engine.isInRunningState();
        if (!running_state) {
            throw new IOException("CS server is not ready to serve.");
        }
        try {
            if (cs.getBoolean("useThreadNaming", false)) {
                String currentName = Thread.currentThread().getName();
                Thread.currentThread().setName(currentName + "-" + httpReq.getServletPath());
            }
        }
        catch (Exception currentName) {
            // empty catch block
        }
        httpReq.setCharacterEncoding("UTF-8");
        if (logger.isDebugEnabled()) {
            this.outputHttpParameters(httpReq);
        }
        logger.debug("CMSServlet: " + this.mId + " start to service.");
        CMSRequest cmsRequest = this.newCMSRequest();
        cmsRequest.setHttpParams(new ArgBlock("http-request-params", CMSServlet.toHashtable(httpReq)));
        cmsRequest.setHttpReq(httpReq);
        cmsRequest.setHttpResp(httpResp);
        cmsRequest.setServletConfig(this.servletConfig);
        cmsRequest.setServletContext(this.servletContext);
        ArgBlock httpArgs = cmsRequest.getHttpParams();
        String authMgr_http = httpArgs.getValueAsString(AUTHMGR_PARAM, null);
        this.mAuthMgr = authMgr_http != null ? authMgr_http : this.servletConfig.getInitParameter(PROP_AUTHMGR);
        CommandQueue iCommandQueue = new CommandQueue();
        try {
            if (!iCommandQueue.registerProcess(cmsRequest, (Servlet)this)) {
                cmsRequest.setStatus(CMSRequest.ERROR);
                this.renderResult(cmsRequest);
                SessionContext.releaseContext();
                return;
            }
            long startTime = new Date().getTime();
            this.process(cmsRequest);
            this.renderResult(cmsRequest);
            Date endDate = new Date();
            long endTime = endDate.getTime();
            logger.debug("CMSServlet: curDate: " + endDate + " id: " + this.mId + " time: " + (endTime - startTime));
            iCommandQueue.unRegisterProccess(cmsRequest, (Object)this);
        }
        catch (EBaseException e) {
            logger.error(((Object)((Object)this)).getClass().getSimpleName() + ": " + e.getMessage(), (Throwable)e);
            iCommandQueue.unRegisterProccess(cmsRequest, (Object)this);
            this.log(e.toString());
            this.renderException(cmsRequest, e);
        }
        catch (Exception e) {
            logger.error(((Object)((Object)this)).getClass().getSimpleName() + ": " + e.getMessage(), (Throwable)e);
            iCommandQueue.unRegisterProccess(cmsRequest, (Object)this);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(os);
            e.printStackTrace(ps);
            this.log(os.toString());
            this.renderFinalError(cmsRequest, e);
        }
        SessionContext.releaseContext();
    }

    protected CMSRequest newCMSRequest() {
        return new CMSRequest();
    }

    protected void process(CMSRequest cmsRequest) throws Exception {
    }

    protected void renderResult(CMSRequest cmsReq) throws IOException {
        if (!this.mRenderResult) {
            return;
        }
        Integer status = cmsReq.getStatus();
        CMSLoadTemplate ltempl = this.mTemplates.get(status);
        if (ltempl == null || ltempl.mTemplateName == null) {
            return;
        }
        ICMSTemplateFiller filler = ltempl.mFiller;
        this.renderTemplate(cmsReq, ltempl.mTemplateName, filler);
    }

    protected void outputArgBlockAsXML(XMLObject xmlObj, Node parent, String argBlockName, ArgBlock argBlock) {
        Node argBlockContainer = xmlObj.createContainer(parent, argBlockName);
        if (argBlock != null) {
            Enumeration<String> names = argBlock.getElements();
            while (names.hasMoreElements()) {
                String name = names.nextElement();
                String val = argBlock.get(name).toString();
                val = val.trim();
                xmlObj.addItemToContainer(argBlockContainer, name, val);
            }
        }
    }

    protected void outputXML(HttpServletResponse httpResp, CMSTemplateParams params) {
        XMLObject xmlObj = null;
        try {
            xmlObj = new XMLObject();
            Node root = xmlObj.createRoot("xml");
            this.outputArgBlockAsXML(xmlObj, root, "header", params.getHeader());
            this.outputArgBlockAsXML(xmlObj, root, "fixed", params.getFixed());
            Enumeration<ArgBlock> records = params.queryRecords();
            Node recordsNode = xmlObj.createContainer(root, "records");
            if (records != null) {
                while (records.hasMoreElements()) {
                    ArgBlock record = records.nextElement();
                    this.outputArgBlockAsXML(xmlObj, recordsNode, "record", record);
                }
            }
            byte[] cb = xmlObj.toByteArray();
            ServletOutputStream os = httpResp.getOutputStream();
            httpResp.setContentType("application/xml");
            httpResp.setContentLength(cb.length);
            os.write(cb);
            os.flush();
        }
        catch (Exception e) {
            logger.warn("Failed in outputing XML: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void renderTemplate(CMSRequest cmsReq, String templateName, ICMSTemplateFiller filler) throws IOException {
        try {
            ArgBlock fixed;
            String preserved;
            String httpTemplateName;
            ArgBlock httpParams = cmsReq.getHttpParams();
            Locale[] locale = new Locale[1];
            CMSTemplate template = this.getTemplate(templateName, cmsReq.getHttpReq(), locale);
            CMSTemplateParams templateParams = null;
            if (filler != null) {
                templateParams = filler.getTemplateParams(cmsReq, this.mAuthority, locale[0], null);
            }
            logger.debug("CMSServlet.java: renderTemplate");
            String xmlOutput = cmsReq.getHttpReq().getParameter("xml");
            if (xmlOutput != null && xmlOutput.equals("true")) {
                logger.debug("CMSServlet.java: xml parameter detected, returning xml");
                this.outputXML(cmsReq.getHttpResp(), templateParams);
                return;
            }
            if (httpParams != null && (httpTemplateName = httpParams.getValueAsString(TEMPLATE_NAME, null)) != null) {
                templateName = httpTemplateName;
            }
            if (templateParams == null) {
                templateParams = new CMSTemplateParams(null, null);
            }
            if (httpParams != null && (preserved = httpParams.getValueAsString(PRESERVED, null)) != null && (fixed = templateParams.getFixed()) != null) {
                fixed.set(PRESERVED, preserved);
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            template.renderOutput(bos, templateParams);
            cmsReq.getHttpResp().setContentType("text/html");
            cmsReq.getHttpResp().setContentLength(bos.size());
            bos.writeTo((OutputStream)cmsReq.getHttpResp().getOutputStream());
        }
        catch (Exception e) {
            logger.error(((Object)((Object)this)).getClass().getSimpleName() + ": " + e.getMessage(), (Throwable)e);
            this.renderException(cmsReq, new ECMSGWException(CMS.getLogMessage("CMSGW_ERROR_DISPLAY_TEMPLATE", new Object[0]), e));
        }
    }

    protected void renderException(CMSRequest cmsReq, EBaseException e) throws IOException {
        try {
            Locale[] locale = new Locale[1];
            CMSLoadTemplate loadTempl = this.mTemplates.get(CMSRequest.EXCEPTION);
            CMSTemplate template = this.getTemplate(loadTempl.mTemplateName, cmsReq.getHttpReq(), locale);
            ICMSTemplateFiller filler = loadTempl.mFiller;
            CMSTemplateParams templateParams = null;
            cmsReq.setStatus(CMSRequest.EXCEPTION);
            if (filler != null) {
                templateParams = filler.getTemplateParams(cmsReq, this.mAuthority, locale[0], (Exception)((Object)e));
            }
            if (templateParams == null) {
                templateParams = new CMSTemplateParams(null, new ArgBlock());
            }
            if (e != null) {
                templateParams.getFixed().set("unexpectedError", e.toString(locale[0]));
            }
            logger.debug("CMSServlet.java: renderTemplate");
            String xmlOutput = cmsReq.getHttpReq().getParameter("xml");
            if (xmlOutput != null && xmlOutput.equals("true")) {
                logger.debug("CMSServlet.java: xml parameter detected, returning xml");
                this.outputXML(cmsReq.getHttpResp(), templateParams);
                return;
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            template.renderOutput(bos, templateParams);
            cmsReq.getHttpResp().setContentType("text/html");
            cmsReq.getHttpResp().setContentLength(bos.size());
            bos.writeTo((OutputStream)cmsReq.getHttpResp().getOutputStream());
        }
        catch (Exception ex) {
            logger.error(((Object)((Object)this)).getClass().getSimpleName() + ": " + ex.getMessage(), (Throwable)ex);
            this.renderFinalError(cmsReq, ex);
        }
    }

    public void renderFinalError(CMSRequest cmsReq, Exception ex) throws IOException {
        HttpServletResponse httpResp = cmsReq.getHttpResp();
        httpResp.setContentType("text/html");
        ServletOutputStream out = httpResp.getOutputStream();
        Object finalErrMsg = this.mFinalErrorMsg;
        int tokenIdx = this.mFinalErrorMsg.indexOf(ERROR_MSG_TOKEN);
        if (tokenIdx != -1) {
            finalErrMsg = this.mFinalErrorMsg.substring(0, tokenIdx) + StringEscapeUtils.escapeHtml4((String)ex.toString()) + this.mFinalErrorMsg.substring(tokenIdx + ERROR_MSG_TOKEN.length());
        }
        out.println((String)finalErrMsg);
    }

    protected static void invalidateSSLSession(HttpServletRequest httpReq) {
    }

    public static AuthCredentials getAuthCreds(AuthManager authMgr, ArgBlock argBlock, X509Certificate clientCert) throws EBaseException {
        String[] reqCreds = authMgr.getRequiredCreds();
        AuthCredentials creds = new AuthCredentials();
        for (int i = 0; i < reqCreds.length; ++i) {
            String reqCred = reqCreds[i];
            if (reqCred.equals("sslClientCert")) {
                creds.set(reqCred, new X509Certificate[]{clientCert});
                continue;
            }
            String value = argBlock.getValueAsString(reqCred);
            creds.set(reqCred, value);
        }
        creds.setArgBlock(argBlock);
        return creds;
    }

    protected X509Certificate getSSLClientCertificate(HttpServletRequest httpReq) throws EBaseException {
        return this.getSSLClientCertificate(httpReq, true);
    }

    protected X509Certificate getSSLClientCertificate(HttpServletRequest httpReq, boolean clientCertRequired) throws EBaseException {
        X509Certificate cert = null;
        logger.info(CMS.getLogMessage("CMSGW_GETTING_SSL_CLIENT_CERT", new Object[0]));
        X509Certificate[] allCerts = (X509Certificate[])httpReq.getAttribute(CERT_ATTR);
        if (allCerts == null || allCerts.length == 0) {
            if (clientCertRequired) {
                throw new EBaseException("You did not provide a valid certificate for this operation");
            }
            return null;
        }
        cert = allCerts[0];
        if (cert == null) {
            logger.error(CMS.getLogMessage("CMSGW_SSL_CL_CERT_FAIL", new Object[0]));
            return null;
        }
        try {
            byte[] certEncoded = cert.getEncoded();
            cert = new X509CertImpl(certEncoded);
        }
        catch (CertificateEncodingException e) {
            logger.error(CMS.getLogMessage("CMSGW_SSL_CL_CERT_FAIL_ENCODE", e.getMessage()), (Throwable)e);
            return null;
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage("CMSGW_SSL_CL_CERT_FAIL_DECODE", e.getMessage()), (Throwable)e);
            return null;
        }
        return cert;
    }

    protected CMSTemplate getTemplate(String templateName, HttpServletRequest httpReq, Locale[] locale) throws EBaseException, IOException {
        if (this.servletConfig == null) {
            logger.error("CMSServlet:getTemplate() - mServletConfig is null!");
            return null;
        }
        String realpath = this.servletContext.getRealPath("/" + templateName);
        if (realpath == null) {
            logger.error(CMS.getLogMessage("CMSGW_NO_FIND_TEMPLATE", templateName));
            throw new ECMSGWException(CMS.getLogMessage("CMSGW_ERROR_DISPLAY_TEMPLATE", new Object[0]));
        }
        File realpathFile = new File(realpath);
        File templateFile = CMSServlet.getLangFile(httpReq, realpathFile, locale);
        String charSet = httpReq.getCharacterEncoding();
        if (charSet == null) {
            charSet = "UTF8";
        }
        return (CMSTemplate)this.mFileLoader.getCMSFile(templateFile, charSet);
    }

    protected void getDontSaveHttpParams(ServletConfig sc) {
        block5: {
            String dontSaveParams = null;
            try {
                for (int i = 0; i < DONT_SAVE_HTTP_PARAMS.length; ++i) {
                    this.mDontSaveHttpParams.addElement(DONT_SAVE_HTTP_PARAMS[i]);
                }
                dontSaveParams = sc.getInitParameter(PROP_DONT_SAVE_HTTP_PARAMS);
                if (dontSaveParams == null) break block5;
                StringTokenizer params = new StringTokenizer(dontSaveParams, ",");
                while (params.hasMoreTokens()) {
                    String param = params.nextToken();
                    this.mDontSaveHttpParams.addElement(param);
                }
            }
            catch (Exception e) {
                logger.warn(CMS.getLogMessage("CMSGW_NO_CONFIG_VALUE", PROP_DONT_SAVE_HTTP_PARAMS, e.toString()), (Throwable)e);
                for (int i = 0; i < DONT_SAVE_HTTP_PARAMS.length; ++i) {
                    this.mDontSaveHttpParams.addElement(DONT_SAVE_HTTP_PARAMS[i]);
                }
            }
        }
    }

    protected void getSaveHttpHeaders(ServletConfig sc) {
        try {
            for (int i = 0; i < SAVE_HTTP_HEADERS.length; ++i) {
                this.mSaveHttpHeaders.addElement(SAVE_HTTP_HEADERS[i]);
            }
            String saveHeaders = sc.getInitParameter(PROP_SAVE_HTTP_HEADERS);
            if (saveHeaders != null) {
                StringTokenizer headers = new StringTokenizer(saveHeaders, ",");
                while (headers.hasMoreTokens()) {
                    String hdr = headers.nextToken();
                    this.mSaveHttpHeaders.addElement(hdr);
                }
            }
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage("CMSGW_NO_CONFIG_VALUE", PROP_SAVE_HTTP_HEADERS, e.toString()), (Throwable)e);
        }
    }

    protected void saveHttpHeaders(HttpServletRequest httpReq, Request req) throws EBaseException {
        Hashtable<String, String> headers = new Hashtable<String, String>();
        Enumeration<String> hdrs = this.mSaveHttpHeaders.elements();
        while (hdrs.hasMoreElements()) {
            String hdr = hdrs.nextElement();
            String val = httpReq.getHeader(hdr);
            if (val == null) continue;
            headers.put(hdr, val);
        }
        req.setExtData("HTTP_HEADERS", headers);
    }

    protected void saveHttpParams(ArgBlock httpParams, Request req) {
        Hashtable<String, String> saveParams = new Hashtable<String, String>();
        Enumeration<String> names = httpParams.elements();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            Enumeration<String> params = this.mDontSaveHttpParams.elements();
            boolean dosave = true;
            while (params.hasMoreElements()) {
                String param = params.nextElement();
                if (!name.equalsIgnoreCase(param)) continue;
                dosave = false;
                break;
            }
            if (!dosave) continue;
            saveParams.put(name, (String)httpParams.get(name));
        }
        req.setExtData("HTTP_PARAMS", saveParams);
    }

    protected ICMSTemplateFiller newFillerObject(String fillerClass) {
        ICMSTemplateFiller filler = null;
        try {
            filler = (ICMSTemplateFiller)Class.forName(fillerClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            logger.error(CMS.getLogMessage("CMSGW_CANT_LOAD_FILLER", fillerClass, e.toString()), (Throwable)e);
            return null;
        }
        return filler;
    }

    protected void setDefaultTemplates(ServletConfig sc) {
        Object successTemplate = null;
        Object errorTemplate = null;
        Object unauthorizedTemplate = null;
        Object pendingTemplate = null;
        Object svcpendingTemplate = null;
        Object rejectedTemplate = null;
        Object unexpectedErrorTemplate = null;
        String gateway = sc.getInitParameter("interface");
        String authority = sc.getInitParameter(PROP_AUTHORITY);
        if (authority == null) {
            authority = sc.getInitParameter(PROP_AUTHORITYID);
        }
        try {
            successTemplate = sc.getInitParameter(PROP_SUCCESS_TEMPLATE);
            if (successTemplate == null) {
                successTemplate = SUCCESS_TEMPLATE;
                if (gateway != null) {
                    successTemplate = "/" + gateway + (String)successTemplate;
                }
            }
            if ((errorTemplate = sc.getInitParameter(PROP_ERROR_TEMPLATE)) == null) {
                errorTemplate = ERROR_TEMPLATE;
                if (gateway != null) {
                    errorTemplate = "/" + gateway + (String)errorTemplate;
                }
            }
            if ((unauthorizedTemplate = sc.getInitParameter(PROP_UNAUTHORIZED_TEMPLATE)) == null) {
                unauthorizedTemplate = UNAUTHORIZED_TEMPLATE;
                if (gateway != null) {
                    unauthorizedTemplate = "/" + gateway + (String)unauthorizedTemplate;
                }
            }
            if ((pendingTemplate = sc.getInitParameter(PROP_PENDING_TEMPLATE)) == null) {
                pendingTemplate = PENDING_TEMPLATE;
                if (gateway != null) {
                    pendingTemplate = "/" + gateway + (String)pendingTemplate;
                }
            }
            if ((svcpendingTemplate = sc.getInitParameter(PROP_SVC_PENDING_TEMPLATE)) == null) {
                svcpendingTemplate = SVC_PENDING_TEMPLATE;
                if (gateway != null) {
                    svcpendingTemplate = "/" + gateway + (String)svcpendingTemplate;
                }
            }
            if ((rejectedTemplate = sc.getInitParameter(PROP_REJECTED_TEMPLATE)) == null) {
                rejectedTemplate = REJECTED_TEMPLATE;
                if (gateway != null) {
                    rejectedTemplate = "/" + gateway + (String)rejectedTemplate;
                }
            }
            if ((unexpectedErrorTemplate = sc.getInitParameter(PROP_EXCEPTION_TEMPLATE)) == null) {
                unexpectedErrorTemplate = EXCEPTION_TEMPLATE;
                if (gateway != null) {
                    unexpectedErrorTemplate = "/" + gateway + (String)unexpectedErrorTemplate;
                }
            }
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage("CMSGW_IMP_INIT_SERV_ERR", e.toString(), this.mId), (Throwable)e);
        }
        this.mTemplates.put(CMSRequest.UNAUTHORIZED, new CMSLoadTemplate(PROP_UNAUTHORIZED_TEMPLATE, PROP_UNAUTHOR_TEMPLATE_FILLER, (String)unauthorizedTemplate, null));
        this.mTemplates.put(CMSRequest.SUCCESS, new CMSLoadTemplate(PROP_SUCCESS_TEMPLATE, PROP_SUCCESS_TEMPLATE_FILLER, (String)successTemplate, new GenSuccessTemplateFiller()));
        this.mTemplates.put(CMSRequest.PENDING, new CMSLoadTemplate(PROP_PENDING_TEMPLATE, PROP_PENDING_TEMPLATE_FILLER, (String)pendingTemplate, new GenPendingTemplateFiller()));
        this.mTemplates.put(CMSRequest.SVC_PENDING, new CMSLoadTemplate(PROP_SVC_PENDING_TEMPLATE, PROP_SVC_PENDING_TEMPLATE_FILLER, (String)svcpendingTemplate, new GenSvcPendingTemplateFiller()));
        this.mTemplates.put(CMSRequest.REJECTED, new CMSLoadTemplate(PROP_REJECTED_TEMPLATE, PROP_REJECTED_TEMPLATE_FILLER, (String)rejectedTemplate, new GenRejectedTemplateFiller()));
        this.mTemplates.put(CMSRequest.ERROR, new CMSLoadTemplate(PROP_ERROR_TEMPLATE, PROP_ERROR_TEMPLATE_FILLER, (String)errorTemplate, new GenErrorTemplateFiller()));
        this.mTemplates.put(CMSRequest.EXCEPTION, new CMSLoadTemplate(PROP_EXCEPTION_TEMPLATE, PROP_EXCEPTION_TEMPLATE_FILLER, (String)unexpectedErrorTemplate, new GenUnexpectedErrorTemplateFiller()));
    }

    public static boolean clientIsNav(HttpServletRequest httpReq) {
        String useragent = httpReq.getHeader("user-agent");
        return useragent.startsWith("Mozilla") && useragent.indexOf("MSIE") == -1;
    }

    public static boolean clientIsMSIE(HttpServletRequest httpReq) {
        String useragent = httpReq.getHeader("user-agent");
        return useragent != null && useragent.indexOf("MSIE") != -1;
    }

    public static boolean doCMMFResponse(ArgBlock httpParams) {
        return httpParams.getValueAsBoolean(CMMF_RESPONSE, false);
    }

    public static boolean doFullResponse(ArgBlock httpParams) {
        return httpParams.getValueAsBoolean(FULL_RESPONSE, false);
    }

    protected static void saveAuthToken(AuthToken token, Request req) {
        if (token != null && req != null) {
            req.setExtData(PFX_AUTH_TOKEN, token);
        }
        if (token != null && req != null) {
            Enumeration<String> e = token.getElements();
            while (e.hasMoreElements()) {
                String n = e.nextElement();
                String[] x1 = token.getInStringArray(n);
                if (x1 != null) {
                    for (int i = 0; i < x1.length; ++i) {
                        logger.debug("Setting AUTH_TOKEN-" + n + "(" + i + ")=" + x1[i]);
                        req.setExtData("AUTH_TOKEN-" + n + "(" + i + ")", x1[i]);
                    }
                    continue;
                }
                String x = token.getInString(n);
                if (x == null) continue;
                logger.debug("Setting AUTH_TOKEN-" + n + "=" + x);
                req.setExtData("AUTH_TOKEN-" + n, x);
            }
        }
    }

    protected AuthToken getAuthToken(Request req) {
        return req.getExtDataInAuthToken(PFX_AUTH_TOKEN);
    }

    protected static boolean connectionIsSSL(HttpServletRequest httpReq) {
        return httpReq.isSecure();
    }

    protected RevokedCertImpl formCRLEntry(BigInteger serialNo, RevocationReason reason) throws EBaseException {
        CRLReasonExtension reasonExt = new CRLReasonExtension(reason);
        CRLExtensions crlentryexts = new CRLExtensions();
        try {
            crlentryexts.set("CRLReason", (Extension)reasonExt);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage("CMSGW_ERR_CRL_REASON", reason.toString(), e.toString()), (Throwable)e);
            throw new ECMSGWException(CMS.getLogMessage("CMSGW_ERROR_SETTING_CRLREASON", new Object[0]), e);
        }
        return new RevokedCertImpl(serialNo, new Date(), crlentryexts);
    }

    protected String hashPassword(String pwd) {
        CMSEngine engine = this.getCMSEngine();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        String salt = jssSubsystem.generateSalt();
        byte[] pwdDigest = this.mSHADigest.digest((salt + pwd).getBytes());
        String b64E = Utils.base64encode((byte[])pwdDigest, (boolean)true);
        return "{SHA-256}" + salt + ";" + b64E;
    }

    public static File getLangFile(HttpServletRequest req, File realpathFile, Locale[] locale) throws IOException {
        File file = null;
        String acceptLang = req.getHeader(HDR_LANG);
        if (acceptLang != null && !acceptLang.equals("")) {
            StringTokenizer tokenizer = new StringTokenizer(acceptLang, ",");
            int numLangs = tokenizer.countTokens();
            if (numLangs > 0) {
                int i;
                String name;
                Object parent = realpathFile.getParent();
                if (parent == null) {
                    parent = "." + File.separatorChar;
                }
                if ((name = realpathFile.getName()) == null) {
                    throw new IOException("file has no name");
                }
                for (i = 0; i < numLangs; ++i) {
                    String lang = null;
                    String token = tokenizer.nextToken();
                    int semicolon = token.indexOf(59);
                    if (semicolon == -1) {
                        lang = token.trim();
                    } else {
                        if (semicolon < 2) continue;
                        lang = token.substring(0, semicolon).trim();
                    }
                    Locale l = CMSServlet.getLocale(lang);
                    if (Locale.getDefault().equals(l)) {
                        locale[0] = l;
                        file = realpathFile;
                        break;
                    }
                    String langfilepath = (String)parent + File.separatorChar + lang + File.separatorChar + name;
                    file = new File(langfilepath);
                    if (!file.exists()) continue;
                    locale[0] = CMSServlet.getLocale(lang);
                    break;
                }
                if (i == numLangs) {
                    file = realpathFile;
                    locale[0] = Locale.getDefault();
                }
            }
        } else {
            file = realpathFile;
            locale[0] = Locale.getDefault();
        }
        return file;
    }

    public static Locale getLocale(String lang) {
        int dash = lang.indexOf(45);
        if (dash == -1) {
            return new Locale(lang, "");
        }
        return new Locale(lang.substring(0, dash), lang.substring(dash + 1));
    }

    public AuthToken authenticate(CMSRequest req) throws EBaseException {
        return this.authenticate(req, this.mAuthMgr);
    }

    public AuthToken authenticate(HttpServletRequest httpReq) throws EBaseException {
        return this.authenticate(httpReq, this.mAuthMgr);
    }

    public AuthToken authenticate(CMSRequest req, String authMgrName) throws EBaseException {
        AuthToken authToken = this.authenticate(req.getHttpReq(), authMgrName);
        CMSServlet.saveAuthToken(authToken, req.getRequest());
        return authToken;
    }

    public AuthToken authenticate(HttpServletRequest httpReq, String authMgrName) throws EBaseException {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = "$Unidentified$";
        String auditAuthMgrID = "$Unidentified$";
        String auditUID = "$Unidentified$";
        try {
            String getClientCert = this.mGetClientCert;
            ArgBlock httpArgs = new ArgBlock(CMSServlet.toHashtable(httpReq));
            SessionContext ctx = SessionContext.getContext();
            String ip = httpReq.getRemoteAddr();
            logger.debug("IP: " + ip);
            if (ip != null) {
                ctx.put((Object)"ipAddress", (Object)ip);
            }
            if (authMgrName != null) {
                logger.debug("AuthMgrName: " + authMgrName);
                ctx.put((Object)"authManagerId", (Object)authMgrName);
            }
            ctx.put((Object)"locale", (Object)this.getLocale(httpReq));
            X509Certificate clientCert = null;
            if (getClientCert != null && getClientCert.equals("true")) {
                logger.debug("CMSServlet: retrieving SSL certificate");
                clientCert = this.getSSLClientCertificate(httpReq);
            }
            if (authMgrName == null) {
                logger.debug("CMSServlet: no authMgrName");
                return null;
            }
            if (clientCert == null) {
                logger.debug("CMSServlet: no client certificate found");
            } else {
                String certUID = clientCert.getSubjectDN().getName();
                logger.debug("CMSServlet: certUID=" + certUID);
                if (certUID != null && !(certUID = certUID.trim()).equals("")) {
                    auditUID = certUID;
                }
            }
            auditAuthMgrID = authMgrName;
            CMSGateway gateway = engine.getCMSGateway();
            AuthToken authToken = gateway.checkAuthManager(httpReq, httpArgs, clientCert, authMgrName);
            if (authToken == null) {
                return null;
            }
            String userid = authToken.getInString("userid");
            logger.debug("CMSServlet: userid=" + userid);
            if (userid != null) {
                ctx.put((Object)"userid", (Object)userid);
            }
            auditSubjectID = this.auditSubjectID();
            auditor.log(AuthEvent.createSuccessEvent(auditSubjectID, auditAuthMgrID));
            return authToken;
        }
        catch (EBaseException eAudit1) {
            auditor.log(AuthEvent.createFailureEvent(auditSubjectID, auditAuthMgrID, auditUID));
            throw eAudit1;
        }
    }

    public AuthzToken authorize(String authzMgrName, String resource, AuthToken authToken, String exp) throws EBaseException {
        AuthzToken authzToken = null;
        logger.debug("CMSServlet.authorize(" + authzMgrName + ", " + resource + ")");
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        String auditGroupID = this.auditGroupID();
        String auditACLResource = resource;
        String auditOperation = "enroll";
        try {
            authzToken = this.mAuthz.authorize(authzMgrName, authToken, exp);
            if (authzToken != null) {
                auditor.log(AuthzEvent.createSuccessEvent(auditSubjectID, auditACLResource, auditOperation));
                auditor.log(RoleAssumeEvent.createSuccessEvent(auditSubjectID, auditGroupID));
            } else {
                auditor.log(AuthzEvent.createFailureEvent(auditSubjectID, auditACLResource, auditOperation));
                auditor.log(RoleAssumeEvent.createFailureEvent(auditSubjectID, auditGroupID));
            }
            return authzToken;
        }
        catch (Exception e) {
            auditor.log(AuthzEvent.createFailureEvent(auditSubjectID, auditACLResource, auditOperation));
            auditor.log(RoleAssumeEvent.createFailureEvent(auditSubjectID, auditGroupID));
            throw new EBaseException(e.toString());
        }
    }

    public AuthzToken authorize(String authzMgrName, AuthToken authToken, String resource, String operation) throws EBaseException {
        logger.debug("CMSServlet.authorize(" + authzMgrName + ")");
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        String auditGroupID = this.auditGroupID();
        String auditID = auditSubjectID;
        String auditACLResource = resource;
        String auditOperation = operation;
        SessionContext auditContext = SessionContext.getExistingContext();
        String authManagerId = null;
        if (auditContext != null && (authManagerId = (String)auditContext.get((Object)"authManagerId")) != null && authManagerId.equals("TokenAuth") && (auditSubjectID.equals("$NonRoleUser$") || auditSubjectID.equals("$Unidentified$"))) {
            logger.debug("CMSServlet: in authorize... TokenAuth auditSubjectID unavailable, changing to auditGroupID");
            auditID = auditGroupID;
        }
        if (auditACLResource != null) {
            auditACLResource = auditACLResource.trim();
        }
        if (auditOperation != null) {
            auditOperation = auditOperation.trim();
        }
        if (authzMgrName == null) {
            return null;
        }
        String roles = this.auditGroups(auditSubjectID);
        try {
            AuthzToken authzTok = this.mAuthz.authorize(authzMgrName, authToken, resource, operation);
            if (authzTok != null) {
                auditor.log(AuthzEvent.createSuccessEvent(auditSubjectID, auditACLResource, auditOperation));
                if (roles != null) {
                    auditor.log(RoleAssumeEvent.createSuccessEvent(auditID, roles));
                }
            } else {
                auditor.log(AuthzEvent.createFailureEvent(auditSubjectID, auditACLResource, auditOperation));
                if (roles != null) {
                    auditor.log(RoleAssumeEvent.createFailureEvent(auditID, roles));
                }
            }
            return authzTok;
        }
        catch (EBaseException eAudit1) {
            auditor.log(AuthzEvent.createFailureEvent(auditSubjectID, auditACLResource, auditOperation));
            if (roles != null) {
                auditor.log(RoleAssumeEvent.createFailureEvent(auditID, roles));
            }
            return null;
        }
        catch (Exception eAudit1) {
            auditor.log(AuthzEvent.createFailureEvent(auditSubjectID, auditACLResource, auditOperation));
            if (roles != null) {
                auditor.log(RoleAssumeEvent.createFailureEvent(auditSubjectID, roles));
            }
            return null;
        }
    }

    protected String auditSubjectID() {
        SessionContext auditContext = SessionContext.getExistingContext();
        if (auditContext == null) {
            return "$Unidentified$";
        }
        String subjectID = (String)auditContext.get((Object)"userid");
        if (subjectID == null) {
            return "$NonRoleUser$";
        }
        return subjectID.trim();
    }

    protected String auditGroupID() {
        logger.debug("CMSServlet: in auditGroupID");
        String groupID = null;
        SessionContext auditContext = SessionContext.getExistingContext();
        if (auditContext != null) {
            groupID = (String)auditContext.get((Object)"groupid");
            logger.debug("CMSServlet auditGroupID: groupID: " + groupID);
            groupID = groupID != null ? groupID.trim() : "$NonRoleUser$";
        } else {
            groupID = "$Unidentified$";
        }
        return groupID;
    }

    private String auditGroups(String SubjectID) {
        if (SubjectID == null || SubjectID.equals("$Unidentified$")) {
            return null;
        }
        CMSEngine engine = this.getCMSEngine();
        UGSubsystem mUG = engine.getUGSubsystem();
        Enumeration<Group> groups = null;
        try {
            groups = mUG.findGroups("*");
        }
        catch (Exception e) {
            return null;
        }
        StringBuffer membersString = new StringBuffer();
        while (groups.hasMoreElements()) {
            Group group = groups.nextElement();
            if (!group.isMember(SubjectID)) continue;
            if (membersString.length() != 0) {
                membersString.append(", ");
            }
            membersString.append(group.getGroupID());
        }
        if (membersString.length() == 0) {
            return null;
        }
        return membersString.toString();
    }

    protected Locale getLocale(HttpServletRequest req) {
        Locale locale = null;
        String lang = req.getHeader(HDR_LANG);
        locale = lang == null ? Locale.getDefault() : new Locale(UserInfo.getUserLanguage(lang), UserInfo.getUserCountry(lang));
        return locale;
    }

    protected void outputResult(HttpServletResponse httpResp, String contentType, byte[] content) {
        try {
            ServletOutputStream os = httpResp.getOutputStream();
            httpResp.setContentType(contentType);
            httpResp.setContentLength(content.length);
            os.write(content);
            os.flush();
        }
        catch (IOException e) {
            logger.warn(CMS.getLogMessage("CMSGW_ERR_BAD_SERV_OUT_STREAM", "", e.toString()), (Throwable)e);
            return;
        }
    }

    protected void outputError(HttpServletResponse httpResp, String errorString) {
        this.outputError(httpResp, FAILURE, errorString, null);
    }

    protected void outputError(HttpServletResponse httpResp, String errorString, String requestId) {
        this.outputError(httpResp, FAILURE, errorString, null);
    }

    protected void outputError(HttpServletResponse httpResp, String status, String errorString, String requestId) {
        XMLObject xmlObj = null;
        try {
            xmlObj = new XMLObject();
            Node root = xmlObj.createRoot("XMLResponse");
            xmlObj.addItemToContainer(root, "Status", status);
            xmlObj.addItemToContainer(root, "Error", errorString);
            if (requestId != null) {
                xmlObj.addItemToContainer(root, "RequestId", requestId);
            }
            byte[] cb = xmlObj.toByteArray();
            ServletOutputStream os = httpResp.getOutputStream();
            httpResp.setContentType("application/xml");
            httpResp.setContentLength(cb.length);
            os.write(cb);
            os.flush();
        }
        catch (Exception ee) {
            logger.warn(CMS.getLogMessage("CMSGW_ERR_BAD_SERV_OUT_STREAM", "", ee.toString()), (Throwable)ee);
        }
    }
}

