/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.base;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStorage;
import com.netscape.cmscore.base.ConfigStore;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.mozilla.jss.netscape.security.util.Utils;

public class FileConfigStorage
extends ConfigStorage {
    private File mFile;

    public FileConfigStorage(String fileName) throws Exception {
        this.mFile = new File(fileName);
    }

    public File getFile() {
        return this.mFile;
    }

    @Override
    public void load(ConfigStore config) throws Exception {
        if (!this.mFile.exists()) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_NO_CONFIG_FILE", this.mFile.getPath()));
        }
        try (FileInputStream fi = new FileInputStream(this.mFile);
             BufferedInputStream bis = new BufferedInputStream(fi);){
            config.load(bis);
        }
    }

    @Override
    public void commit(ConfigStore config, boolean createBackup) throws EBaseException {
        block15: {
            if (createBackup) {
                File newName = new File(this.mFile.getPath() + "." + Long.toString(System.currentTimeMillis()));
                try {
                    if (Utils.isNT()) {
                        Utils.exec((String)("copy " + this.mFile.getAbsolutePath().replace('/', '\\') + " " + newName.getAbsolutePath().replace('/', '\\')));
                    } else {
                        Utils.exec((String)("cp -p " + this.mFile.getAbsolutePath() + " " + newName.getAbsolutePath()));
                    }
                    if (newName.exists()) {
                        if (!Utils.isNT()) {
                            Utils.exec((String)("chmod 00660 " + newName.getAbsolutePath()));
                        }
                        break block15;
                    }
                    throw new EBaseException("backup copy failed");
                }
                catch (EBaseException e) {
                    throw new EBaseException("backup copy failed");
                }
            }
        }
        try (FileOutputStream out = new FileOutputStream(this.mFile);){
            config.store(out);
            if (!Utils.isNT()) {
                Utils.exec((String)("chmod 00660 " + this.mFile.getCanonicalPath()));
            }
        }
        catch (Exception e) {
            throw new EBaseException("Unable to save configuration: " + e.getMessage(), (Throwable)e);
        }
    }
}

