/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.connector;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.connector.Connector;
import com.netscape.certsrv.connector.ConnectorConfig;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.connector.HttpConnFactory;
import com.netscape.cmscore.connector.HttpConnection;
import com.netscape.cmscore.connector.HttpPKIMessage;
import com.netscape.cmscore.connector.RemoteAuthority;
import com.netscape.cmscore.connector.Resender;
import com.netscape.cmscore.request.Request;
import com.netscape.cmsutil.http.HttpResponse;
import com.netscape.cmsutil.http.JssSSLSocketFactory;
import com.netscape.cmsutil.net.ISocketFactory;
import java.util.Vector;
import org.mozilla.jss.ssl.SSLSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnector
extends Connector {
    public static Logger logger = LoggerFactory.getLogger(HttpConnector.class);
    protected String nickname;
    protected String clientCiphers;
    protected RemoteAuthority mDest;
    protected int resendInterval;
    protected ConnectorConfig config;
    protected ISocketFactory mFactory = null;
    protected HttpConnection mConn;
    private Resender mResender;
    private int mTimeout;
    private HttpConnFactory mConnFactory = null;

    public HttpConnector(String nickName, String clientCiphers, RemoteAuthority dest, int resendInterval, ConnectorConfig config) throws EBaseException {
        this(nickName, clientCiphers, dest, resendInterval, config, 0);
    }

    public HttpConnector(String nickName, String clientCiphers, RemoteAuthority dest, int resendInterval, ConnectorConfig config, int timeout) throws EBaseException {
        this.nickname = nickName;
        this.clientCiphers = clientCiphers;
        this.mDest = dest;
        this.resendInterval = resendInterval;
        this.config = config;
        this.mTimeout = timeout;
    }

    @Override
    public void init() throws EBaseException {
        logger.info("HttpConnector: Initializing HttpConnector");
        this.mFactory = new JssSSLSocketFactory(this.nickname, this.clientCiphers);
        JssSSLSocketFactory factory = (JssSSLSocketFactory)this.mFactory;
        factory.addSocketListener((SSLSocketListener)this.engine.getClientSocketListener());
        int minConns = this.config.getMinHttpConns();
        logger.debug("HttpConnector: minHttpConns: " + minConns);
        int maxConns = this.config.getMaxHttpConns();
        logger.debug("HttpConnector: maxHttpConns: " + maxConns);
        try {
            this.mConnFactory = new HttpConnFactory(minConns, maxConns, this.mDest, this.nickname, this.clientCiphers, this.mTimeout);
            this.mConnFactory.setCMSEngine(this.engine);
            this.mConnFactory.init();
        }
        catch (EBaseException e) {
            logger.warn("HttpConnector: Unble to create new HttpConnFactory: " + e.getMessage(), (Throwable)e);
        }
        if (this.resendInterval >= 0) {
            this.mResender = new Resender(this.nickname, this.clientCiphers, this.mDest, this.resendInterval);
            this.mResender.setCMSEngine(this.engine);
            this.mResender.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse send(String op, String msg) throws EBaseException {
        logger.debug("HttpConnector: send(): begins");
        HttpResponse resp = null;
        HttpConnection curConn = null;
        if (op == null) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_ATTRIBUTE", "HttpConnector.send(): op null"));
        }
        String uri = this.mDest.getURI(op);
        if (uri == null) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_ATTRIBUTE", "HttpConnector.send(): cannot find uri for op"));
        }
        try {
            curConn = this.mConnFactory.getConn();
            curConn.setRequestURI(uri);
            resp = curConn.send(msg);
        }
        catch (EBaseException e) {
            logger.warn("HttpConnector: send(): " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (curConn != null) {
                this.mConnFactory.returnConn(curConn);
            }
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean send(Request r) throws EBaseException {
        RequestStatus replyStatus;
        HttpPKIMessage replymsg;
        HttpConnection curConn;
        block16: {
            block15: {
                curConn = null;
                HttpPKIMessage tomsg = new HttpPKIMessage();
                replymsg = null;
                tomsg.fromRequest(r);
                logger.debug("Before synch");
                curConn = this.mConnFactory.getConn();
                logger.debug("HttpConnector.send " + curConn);
                replymsg = (HttpPKIMessage)curConn.send(tomsg);
                if (replymsg != null) break block15;
                logger.warn("HttpConncter. replymsg is null");
                boolean bl = false;
                if (curConn != null) {
                    this.mConnFactory.returnConn(curConn);
                }
                return bl;
            }
            logger.debug("HttpConncter.send has been called");
            replyStatus = RequestStatus.valueOf((String)replymsg.reqStatus);
            int index = replymsg.reqId.lastIndexOf(58);
            RequestId replyRequestId = new RequestId(replymsg.reqId.substring(index + 1));
            logger.debug("reply request id " + replyRequestId);
            r.setExtData("remoteReqID", replyRequestId.toString());
            logger.debug("reply request type " + r.getRequestType());
            logger.debug("reply status " + replyStatus);
            if (r.getRequestType().equals("getRevocationInfo") || replyStatus != RequestStatus.BEGIN && replyStatus != RequestStatus.PENDING && replyStatus != RequestStatus.SVC_PENDING && replyStatus != RequestStatus.APPROVED) break block16;
            logger.debug("HttpConn:  remote request id still pending " + r.getRequestId() + " state " + replyStatus);
            if (this.mResender != null) {
                this.mResender.addRequest(r);
            }
            boolean bl = false;
            if (curConn != null) {
                this.mConnFactory.returnConn(curConn);
            }
            return bl;
        }
        try {
            replymsg.toRequest(r);
            if (replyStatus == RequestStatus.REJECTED || replyStatus == RequestStatus.CANCELED) {
                logger.debug("remote request id " + r.getRequestId() + " was rejected or cancelled.");
                r.setExtData("remoteStatus", replyStatus.toString());
                r.setExtData("Result", Request.RES_ERROR);
                r.setExtData("Error", new EBaseException(CMS.getUserMessage("CMS_BASE_REMOTE_AUTHORITY_ERROR", new String[0])));
                Vector<String> policyErrors = r.getExtDataInStringVector("errors");
                if (policyErrors != null && policyErrors.size() > 0) {
                    r.setExtData("serviceErrors", policyErrors);
                }
            }
            logger.debug("remote request id " + r.getRequestId() + " was completed");
            boolean bl = true;
            if (curConn != null) {
                this.mConnFactory.returnConn(curConn);
            }
            return bl;
        }
        catch (EBaseException e) {
            try {
                logger.error("HttpConn: error sending request to cert: " + e.getMessage(), (Throwable)e);
                if (!r.getRequestType().equals("getRevocationInfo") && this.mResender != null) {
                    this.mResender.addRequest(r);
                }
                boolean bl = false;
                if (curConn != null) {
                    this.mConnFactory.returnConn(curConn);
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (curConn != null) {
                    this.mConnFactory.returnConn(curConn);
                }
                throw throwable;
            }
        }
    }

    @Override
    public void start() {
        logger.debug("Starting HttpConnector resender thread");
        if (this.mResender != null) {
            this.mResender.start("HttpConnector");
        }
    }

    @Override
    public void stop() {
        logger.debug("Stopping HttpConnector resender thread");
        if (this.mResender != null) {
            this.mResender.stop();
        }
    }
}

