/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.connector;

import com.netscape.certsrv.connector.IHttpPKIMessage;
import com.netscape.cmscore.connector.RequestTransfer;
import com.netscape.cmscore.request.Request;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpPKIMessage
implements IHttpPKIMessage {
    private static final long serialVersionUID = -3378261119472034953L;
    public static Logger logger = LoggerFactory.getLogger(HttpPKIMessage.class);
    public String reqType = "";
    public String reqId = "";
    protected String reqStatus = "";
    protected String reqRealm = "";
    protected Vector<Object> mNameVals = new Vector();

    @Override
    public String getReqStatus() {
        return this.reqStatus;
    }

    @Override
    public String getReqType() {
        return this.reqType;
    }

    @Override
    public String getReqId() {
        return this.reqId;
    }

    @Override
    public String getReqRealm() {
        return this.reqRealm;
    }

    @Override
    public void fromRequest(Request r) {
        String[] attrs;
        this.reqType = r.getRequestType();
        this.reqId = r.getRequestId().toString();
        this.reqStatus = r.getRequestStatus().toString();
        this.reqRealm = r.getRealm();
        logger.debug("HttpPKIMessage.fromRequest: requestId=" + r.getRequestId().toString() + " requestStatus=" + this.reqStatus + " instance=" + r);
        String[] names = attrs = RequestTransfer.getTransferAttributes(r);
        Object value = null;
        for (int i = 0; i < attrs.length; ++i) {
            String key = names[i];
            value = r.isSimpleExtDataValue(key) ? r.getExtDataInString(key) : r.getExtDataInHashtable(key);
            if (value == null) continue;
            this.mNameVals.addElement(key);
            this.mNameVals.addElement(value);
        }
    }

    @Override
    public void toRequest(Request r) {
        this.reqStatus = r.getRequestStatus().toString();
        logger.debug("HttpPKMessage.toRequest: requestStatus=" + this.reqStatus);
        Enumeration<Object> enum1 = this.mNameVals.elements();
        while (enum1.hasMoreElements()) {
            String key = (String)enum1.nextElement();
            try {
                Object value = enum1.nextElement();
                if (value instanceof String) {
                    r.setExtData(key, (String)value);
                    continue;
                }
                if (value instanceof Hashtable) {
                    r.setExtData(key, (Hashtable)value);
                    continue;
                }
                logger.warn("HttpPKIMessage.toRequest(): key: " + key + " has unexpected type " + value.getClass().toString());
            }
            catch (NoSuchElementException e) {
                logger.warn("Incorrect pairing of name/value for " + key);
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        logger.debug("writeObject");
        out.writeObject(this.reqType);
        logger.trace("read object req type " + this.reqType);
        out.writeObject(this.reqId);
        logger.trace("read object req id " + this.reqId);
        out.writeObject(this.reqStatus);
        logger.trace("read object req source status " + this.reqStatus);
        out.writeObject(this.reqRealm);
        logger.trace("read object req realm " + this.reqRealm);
        Enumeration<Object> enum1 = this.mNameVals.elements();
        while (enum1.hasMoreElements()) {
            Object key = null;
            Object val = null;
            key = enum1.nextElement();
            try {
                val = enum1.nextElement();
                ObjectOutputStream os = new ObjectOutputStream(new ByteArrayOutputStream());
                os.writeObject(key);
                os.writeObject(val);
                out.writeObject(key);
                out.writeObject(val);
            }
            catch (Exception e) {
                logger.warn("HttpPKIMessage:skipped key=" + key.getClass().getName());
                if (val == null) {
                    logger.warn("HttpPKIMessage:skipped val= null");
                    continue;
                }
                logger.warn("HttpPKIMessage:skipped val=" + val.getClass().getName());
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, OptionalDataException {
        this.reqType = (String)in.readObject();
        this.reqId = (String)in.readObject();
        this.reqStatus = (String)in.readObject();
        this.reqRealm = (String)in.readObject();
        this.mNameVals = new Vector();
        Object keyorval = null;
        try {
            boolean iskey = true;
            while (true) {
                boolean skipped;
                block10: {
                    skipped = false;
                    try {
                        keyorval = in.readObject();
                    }
                    catch (OptionalDataException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        int s;
                        logger.warn("skipped attribute in request e=" + e);
                        if (iskey || (s = this.mNameVals.size()) <= 0) break block10;
                        this.mNameVals.removeElementAt(s - 1);
                        skipped = true;
                        keyorval = "";
                    }
                }
                if (iskey) {
                    logger.trace("read key " + keyorval);
                    iskey = false;
                } else {
                    logger.trace("read val " + keyorval);
                    iskey = true;
                }
                logger.trace("read " + keyorval);
                if (skipped) continue;
                if (keyorval != null) {
                    this.mNameVals.addElement(keyorval);
                    continue;
                }
                break;
            }
        }
        catch (OptionalDataException e) {
            if (e.eof) {
                logger.trace("end of stream");
            }
            logger.trace(" " + e.length);
            throw e;
        }
    }
}

