/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.request;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.request.AgentApprovals;
import com.netscape.certsrv.request.IPolicy;
import com.netscape.certsrv.request.IService;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cms.request.RequestScheduler;
import com.netscape.cmscore.dbs.DBSSession;
import com.netscape.cmscore.dbs.DBSearchResults;
import com.netscape.cmscore.dbs.DBSubsystem;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestList;
import com.netscape.cmscore.request.RequestNotifier;
import com.netscape.cmscore.request.RequestRepository;
import com.netscape.cmscore.request.SearchEnumeration;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestQueue {
    public static Logger logger = LoggerFactory.getLogger(RequestQueue.class);
    public static final String REQUEST_VERSION = "1.0.0";
    IPolicy mPolicy;
    IService mService;
    RequestNotifier mNotify;
    RequestNotifier mPendingNotify;
    RequestScheduler mRequestScheduler;
    protected DBSubsystem dbSubsystem;
    protected String mBaseDN;
    protected RequestRepository requestRepository;

    public RequestQueue(DBSubsystem dbSubsystem, RequestRepository requestRepository, IPolicy policy, IService service, RequestNotifier notifier, RequestNotifier pendingNotifier) throws EBaseException {
        this.mPolicy = policy;
        this.mService = service;
        this.mNotify = notifier;
        this.mPendingNotify = pendingNotifier;
        this.dbSubsystem = dbSubsystem;
        this.requestRepository = requestRepository;
        this.mBaseDN = requestRepository.getBaseDN();
    }

    public RequestScheduler getRequestScheduler() {
        return this.mRequestScheduler;
    }

    public void setRequestScheduler(RequestScheduler scheduler) {
        this.mRequestScheduler = scheduler;
    }

    public Request cloneRequest(Request request) throws EBaseException {
        RequestStatus requestStatus = request.getRequestStatus();
        if (requestStatus == RequestStatus.BEGIN) {
            throw new EBaseException("Invalid Status");
        }
        String requestType = request.getRequestType();
        Request clone = this.requestRepository.createRequest(requestType);
        clone.copyContents(request);
        clone.setExtData("dbStatus", "NOT_UPDATED");
        return clone;
    }

    public Request findRequest(RequestId id) throws EBaseException {
        return this.requestRepository.readRequest(id);
    }

    protected String getUserIdentity() {
        SessionContext s = SessionContext.getContext();
        return (String)s.get((Object)"userid");
    }

    protected void stateEngine(Request r) throws EBaseException {
        boolean complete = false;
        while (!complete) {
            RequestStatus rs = r.getRequestStatus();
            if (rs == RequestStatus.BEGIN) {
                PolicyResult pr = PolicyResult.ACCEPTED;
                if (this.mPolicy != null) {
                    pr = this.mPolicy.apply(r);
                }
                if (pr == PolicyResult.ACCEPTED) {
                    r.setRequestStatus(RequestStatus.APPROVED);
                } else if (pr == PolicyResult.DEFERRED) {
                    r.setRequestStatus(RequestStatus.PENDING);
                } else {
                    r.setRequestStatus(RequestStatus.REJECTED);
                }
                if (pr == PolicyResult.ACCEPTED) continue;
                this.requestRepository.updateRequest(r);
                continue;
            }
            if (rs == RequestStatus.PENDING) {
                if (this.mPendingNotify != null) {
                    this.mPendingNotify.notify(r);
                }
                complete = true;
                continue;
            }
            if (rs == RequestStatus.APPROVED) {
                boolean svcComplete = this.mService.serviceRequest(r);
                if (svcComplete) {
                    r.setRequestStatus(RequestStatus.COMPLETE);
                } else {
                    r.setRequestStatus(RequestStatus.SVC_PENDING);
                }
                this.requestRepository.updateRequest(r);
                continue;
            }
            if (rs == RequestStatus.SVC_PENDING) {
                complete = true;
                continue;
            }
            if (rs == RequestStatus.CANCELED) {
                if (this.mNotify != null) {
                    this.mNotify.notify(r);
                }
                complete = true;
                continue;
            }
            if (rs == RequestStatus.REJECTED) {
                if (this.mNotify != null) {
                    this.mNotify.notify(r);
                }
                complete = true;
                continue;
            }
            if (rs != RequestStatus.COMPLETE) continue;
            if (this.mNotify != null) {
                this.mNotify.notify(r);
            }
            complete = true;
        }
    }

    public void markRequestPending(Request request) throws EBaseException {
        RequestStatus rs = request.getRequestStatus();
        if (rs != RequestStatus.BEGIN) {
            throw new EBaseException("Invalid request status: " + rs);
        }
        request.setRequestStatus(RequestStatus.PENDING);
        this.requestRepository.updateRequest(request);
        this.stateEngine(request);
    }

    public Request cloneAndMarkPending(Request r) throws EBaseException {
        Request clone = this.cloneRequest(r);
        this.markRequestPending(clone);
        return clone;
    }

    public void cancelRequest(Request request) throws EBaseException {
        request.setRequestStatus(RequestStatus.CANCELED);
        this.requestRepository.updateRequest(request);
        this.stateEngine(request);
    }

    public void rejectRequest(Request request) throws EBaseException {
        RequestStatus rs = request.getRequestStatus();
        if (rs != RequestStatus.PENDING) {
            throw new EBaseException("Invalid request status: " + rs);
        }
        request.setRequestStatus(RequestStatus.REJECTED);
        this.requestRepository.updateRequest(request);
        this.stateEngine(request);
    }

    public void approveRequest(Request request) throws EBaseException {
        String agentName;
        RequestStatus rs = request.getRequestStatus();
        if (rs != RequestStatus.PENDING) {
            throw new EBaseException("Invalid request status: " + rs);
        }
        Vector<String> list = request.getExtDataInStringVector(AgentApprovals.class.getName());
        AgentApprovals aas = AgentApprovals.fromStringVector(list);
        if (aas == null) {
            aas = new AgentApprovals();
        }
        if ((agentName = this.getUserIdentity()) == null) {
            throw new EBaseException("Missing agent information");
        }
        aas.addApproval(agentName);
        request.setExtData(AgentApprovals.class.getName(), aas.toStringVector());
        PolicyResult pr = this.mPolicy.apply(request);
        if (pr == PolicyResult.ACCEPTED) {
            request.setRequestStatus(RequestStatus.APPROVED);
        } else if (pr == PolicyResult.DEFERRED || pr == PolicyResult.REJECTED) {
            // empty if block
        }
        this.requestRepository.updateRequest(request);
        this.stateEngine(request);
    }

    public void markAsServiced(Request request) throws EBaseException {
        request.setRequestStatus(RequestStatus.COMPLETE);
        this.requestRepository.updateRequest(request);
        if (this.mNotify != null) {
            this.mNotify.notify(request);
        }
    }

    public RequestId findRequestBySourceId(String id) {
        RequestList irl = this.findRequestsBySourceId(id);
        if (irl == null) {
            return null;
        }
        return irl.nextRequestId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestList findRequestsBySourceId(String id) {
        DBSearchResults results = null;
        DBSSession dbs = null;
        String filter = "(requestSourceId=" + id + ")";
        try {
            dbs = this.dbSubsystem.createSession();
            results = dbs.search(this.mBaseDN, filter);
        }
        catch (EBaseException e) {
            logger.error("Error in Ldap Request searching code: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (dbs != null) {
                try {
                    dbs.close();
                }
                catch (EBaseException eBaseException) {}
            }
        }
        if (results == null || !results.hasMoreElements()) {
            return null;
        }
        return new SearchEnumeration(results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Enumeration<RequestId> getRawList() {
        DBSearchResults results = null;
        DBSSession dbs = null;
        try {
            dbs = this.dbSubsystem.createSession();
            results = dbs.search(this.mBaseDN, "(requestId=*)");
        }
        catch (EBaseException e) {
            logger.warn("RequestQueue: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (dbs != null) {
                try {
                    dbs.close();
                }
                catch (EBaseException eBaseException) {}
            }
        }
        if (results == null) {
            return null;
        }
        return new SearchEnumeration(results);
    }

    protected void setModificationTime(Request request, Date date) {
        request.mModificationTime = date;
    }

    protected void setCreationTime(Request request, Date date) {
        request.mCreationTime = date;
    }

    public RequestList listRequests() {
        return new RequestList(this.getRawList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestList listRequestsByStatus(RequestStatus s) {
        DBSearchResults results = null;
        DBSSession dbs = null;
        try {
            String f1 = "(requestState=" + s + ")";
            String f2 = "(requestId=*)";
            f1 = "(&" + f1 + f2 + ")";
            dbs = this.dbSubsystem.createSession();
            results = dbs.search(this.mBaseDN, f1);
        }
        catch (EBaseException eBaseException) {
        }
        finally {
            if (dbs != null) {
                try {
                    dbs.close();
                }
                catch (EBaseException eBaseException) {}
            }
        }
        if (results == null) {
            return null;
        }
        return new SearchEnumeration(results);
    }

    static void listRecordAttrs(String s, Hashtable<String, Object> h) {
        System.err.println(s);
        Enumeration<String> e = h.keys();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            System.err.println("Attr: " + name + " Value: " + h.get(name));
        }
    }

    public void recoverWillBlock() {
        RequestList list = this.listRequestsByStatus(RequestStatus.APPROVED);
        if (list == null) {
            return;
        }
        while (list.hasMoreElements()) {
            RequestId requestID = list.nextRequestId();
            try {
                Request request = this.requestRepository.readRequest(requestID);
                if (request.getRequestStatus() == RequestStatus.APPROVED) {
                    this.stateEngine(request);
                }
                this.releaseRequest(request);
            }
            catch (EBaseException e) {
                logger.warn("RequestQueue: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public RequestNotifier getPendingNotify() {
        return this.mPendingNotify;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(Request r) throws EBaseException {
        RequestScheduler scheduler = this.getRequestScheduler();
        if (scheduler != null) {
            scheduler.requestIn(r);
        }
        try {
            RequestStatus rs = r.getRequestStatus();
            if (rs != RequestStatus.BEGIN) {
                throw new EBaseException("Invalid Status");
            }
            this.stateEngine(r);
        }
        finally {
            if (scheduler != null) {
                scheduler.requestOut(r);
            }
        }
    }

    protected void logChange(Request request) {
    }

    public final void releaseRequest(Request request) {
    }
}

