/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.ocsp;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.security.SigningUnit;
import com.netscape.certsrv.security.SigningUnitConfig;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmsutil.crypto.CryptoUtil;
import com.netscape.ocsp.EOCSPException;
import java.security.cert.CertificateException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NoSuchTokenException;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.Signature;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OCSPSigningUnit
extends SigningUnit {
    public static Logger logger = LoggerFactory.getLogger(OCSPSigningUnit.class);

    public void updateConfig(String nickname, String tokenname) {
        this.mConfig.setCertNickname(nickname);
        this.mConfig.setTokenName(tokenname);
    }

    public void init(SigningUnitConfig config) throws EBaseException {
        logger.debug("OCSPSigningUnit.init(" + config.getName() + ")");
        this.mConfig = config;
        String tokenname = null;
        try {
            this.mManager = CryptoManager.getInstance();
            this.mNickname = config.getCertNickname();
            tokenname = config.getTokenName();
            this.mToken = CryptoUtil.getKeyStorageToken((String)tokenname);
            if (!CryptoUtil.isInternalToken((String)tokenname)) {
                this.mNickname = tokenname + ":" + this.mNickname;
                this.setNewNickName(this.mNickname);
            }
            logger.debug("SigningUnit: Loading certificate " + this.mNickname);
            this.mCert = this.mManager.findCertByNickname(this.mNickname);
            logger.debug("SigningUnit: certificate serial number: " + this.mCert.getSerialNumber());
            this.buildCertChain();
            this.mCertImpl = new X509CertImpl(this.mCert.getEncoded());
            logger.debug("SigningUnit: Loading private key");
            this.mPrivk = this.mManager.findPrivKeyByCert(this.mCert);
            String privateKeyID = "0x" + Utils.HexEncode((byte[])this.mPrivk.getUniqueID());
            logger.debug("SigningUnit: private key ID: " + privateKeyID);
            this.mPubk = this.mCert.getPublicKey();
            this.mDefSigningAlgname = config.getDefaultSigningAlgorithm();
            this.mDefSigningAlgorithm = this.checkSigningAlgorithmFromName(this.mDefSigningAlgname);
            logger.debug("SigningUnit: signing algorithm: " + this.mDefSigningAlgorithm);
            this.mInited = true;
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_OCSP_CONVERT_X509", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            throw new EOCSPException(CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{e.toString()}), e);
        }
        catch (NotInitializedException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_OCSP_SIGNING", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new EOCSPException(CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{e.toString()}), (Exception)((Object)e));
        }
        catch (NoSuchTokenException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_OCSP_TOKEN_NOT_FOUND", (Object[])new Object[]{tokenname, e.toString()}), (Throwable)e);
            throw new EOCSPException(CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{e.toString()}), (Exception)((Object)e));
        }
        catch (ObjectNotFoundException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_OCSP_OBJECT_NOT_FOUND", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new EOCSPException(CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{e.toString()}), (Exception)((Object)e));
        }
        catch (TokenException e) {
            logger.error(CMS.getLogMessage((String)"OPERATION_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new EOCSPException(CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{e.toString()}), (Exception)((Object)e));
        }
    }

    public byte[] sign(byte[] data, String algname) throws Exception {
        if (!this.mInited) {
            throw new EBaseException("OCSPSigningUnit not initialized!");
        }
        SignatureAlgorithm signAlg = this.mDefSigningAlgorithm;
        if (algname != null) {
            signAlg = this.checkSigningAlgorithmFromName(algname);
        }
        logger.info("OCSPSigningUnit: Getting algorithm context for " + algname + " " + signAlg);
        Signature signer = this.mToken.getSignatureContext(signAlg);
        signer.initSign(this.mPrivk);
        signer.update(data);
        logger.info("OCSPSigningUnit: Signing OCSP response");
        return signer.sign();
    }

    public boolean verify(byte[] data, byte[] signature, String algname) throws Exception {
        if (!this.mInited) {
            throw new EBaseException("OCSPSigningUnit not initialized!");
        }
        SignatureAlgorithm signAlg = Cert.mapAlgorithmToJss((String)algname);
        if (signAlg == null) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_OCSP_SIGN_ALG_NOT_SUPPORTED", (Object[])new Object[]{algname}));
            throw new EOCSPException(CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{""}));
        }
        Signature signer = this.mToken.getSignatureContext(signAlg);
        signer.initVerify(this.mPubk);
        signer.update(data);
        return signer.verify(signature);
    }
}

