/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.kra;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.apps.CMS;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.pkix.cms.EncryptedContentInfo;
import org.mozilla.jss.pkix.cms.EnvelopedData;
import org.mozilla.jss.pkix.cms.RecipientInfo;
import org.mozilla.jss.pkix.crmf.EncryptedKey;
import org.mozilla.jss.pkix.crmf.EncryptedValue;
import org.mozilla.jss.pkix.crmf.PKIArchiveOptions;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ArchiveOptions {
    public static Logger logger = LoggerFactory.getLogger(ArchiveOptions.class);
    private String mSymmAlgOID;
    private byte[] mSymmAlgParams;
    private byte[] mEncSymmKey;
    private byte[] mEncValue;

    public ArchiveOptions(PKIArchiveOptions opts) throws EBaseException {
        block7: {
            this.mSymmAlgOID = null;
            this.mSymmAlgParams = null;
            this.mEncSymmKey = null;
            this.mEncValue = null;
            try {
                EncryptedKey key = opts.getEncryptedKey();
                ANY enveloped_val = null;
                EncryptedValue val = null;
                AlgorithmIdentifier symmAlg = null;
                if (key.getType() == EncryptedKey.ENVELOPED_DATA) {
                    logger.debug("ArchiveOptions: ArchiveOptions() EncryptedKey type= ENVELOPED_DATA");
                    enveloped_val = key.getEnvelopedData();
                    byte[] env_b = enveloped_val.getEncoded();
                    EnvelopedData.Template env_template = new EnvelopedData.Template();
                    EnvelopedData env_data = (EnvelopedData)env_template.decode((InputStream)new ByteArrayInputStream(env_b));
                    EncryptedContentInfo eCI = env_data.getEncryptedContentInfo();
                    symmAlg = eCI.getContentEncryptionAlgorithm();
                    this.mSymmAlgOID = symmAlg.getOID().toString();
                    this.mSymmAlgParams = ((OCTET_STRING)((ANY)symmAlg.getParameters()).decodeWith((ASN1Template)OCTET_STRING.getTemplate())).toByteArray();
                    SET recipients = env_data.getRecipientInfos();
                    if (recipients.size() <= 0) {
                        logger.error("ArchiveOptions: ArchiveOptions() - missing recipient information ");
                        throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTRIBUTE", (String[])new String[]{"[PKIArchiveOptions] missing recipient information "}));
                    }
                    RecipientInfo ri = (RecipientInfo)recipients.elementAt(0);
                    OCTET_STRING key_o = ri.getEncryptedKey();
                    this.mEncSymmKey = key_o.toByteArray();
                    OCTET_STRING oString = eCI.getEncryptedContent();
                    BIT_STRING encVal = new BIT_STRING(oString.toByteArray(), 0);
                    this.mEncValue = encVal.getBits();
                    logger.debug("ArchiveOptions: ArchiveOptions() EncryptedKey type= ENVELOPED_DATA done");
                    break block7;
                }
                if (key.getType() == EncryptedKey.ENCRYPTED_VALUE) {
                    logger.debug("ArchiveOptions: ArchiveOptions() EncryptedKey type= ENCRYPTED_VALUE");
                    val = key.getEncryptedValue();
                    symmAlg = val.getSymmAlg();
                    this.mSymmAlgOID = symmAlg.getOID().toString();
                    this.mSymmAlgParams = ((OCTET_STRING)((ANY)symmAlg.getParameters()).decodeWith((ASN1Template)OCTET_STRING.getTemplate())).toByteArray();
                    BIT_STRING encSymmKey = val.getEncSymmKey();
                    this.mEncSymmKey = encSymmKey.getBits();
                    BIT_STRING encVal = val.getEncValue();
                    this.mEncValue = encVal.getBits();
                    logger.debug("ArchiveOptions: ArchiveOptions() EncryptedKey type= ENCRYPTED_VALUE done");
                    break block7;
                }
                logger.error("ArchiveOptions: ArchiveOptions() invalid EncryptedKey type");
                throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTRIBUTE", (String[])new String[]{"[PKIArchiveOptions] type " + key.getType()}));
            }
            catch (InvalidBERException e) {
                logger.error("ArchiveOptions: ArchiveOptions(): " + e.getMessage(), (Throwable)e);
                throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTRIBUTE", (String[])new String[]{"[PKIArchiveOptions]" + e.toString()}));
            }
            catch (IOException e) {
                logger.error("ArchiveOptions: ArchiveOptions(): " + e.getMessage(), (Throwable)e);
                throw new EBaseException("ArchiveOptions() exception caught: " + e.toString());
            }
            catch (Exception e) {
                logger.error("ArchiveOptions: ArchiveOptions(): " + e.getMessage(), (Throwable)e);
                throw new EBaseException("ArchiveOptions() exception caught: " + e.toString());
            }
        }
    }

    public static ArchiveOptions toArchiveOptions(byte[] options) throws EBaseException {
        ByteArrayInputStream bis = new ByteArrayInputStream(options);
        PKIArchiveOptions archOpts = null;
        try {
            archOpts = (PKIArchiveOptions)new PKIArchiveOptions.Template().decode((InputStream)bis);
        }
        catch (Exception e) {
            throw new EBaseException("Failed to decode input PKIArchiveOptions.");
        }
        return new ArchiveOptions(archOpts);
    }

    public String getSymmAlgOID() {
        return this.mSymmAlgOID;
    }

    public byte[] getSymmAlgParams() {
        return this.mSymmAlgParams;
    }

    public byte[] getEncSymmKey() {
        return this.mEncSymmKey;
    }

    public byte[] getEncValue() {
        return this.mEncValue;
    }
}

