/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.kra;

import com.netscape.certsrv.authority.IAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.request.IPolicy;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import com.netscape.kra.KeyRecoveryAuthority;
import org.dogtagpki.legacy.core.policy.GenericPolicyProcessor;
import org.dogtagpki.legacy.kra.KRAPolicyConfig;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KRAPolicy
implements IPolicy {
    public static Logger logger = LoggerFactory.getLogger(KRAPolicy.class);
    KRAPolicyConfig mConfig;
    KeyRecoveryAuthority mKRA = null;
    public GenericPolicyProcessor mPolicies;

    public void init(KeyRecoveryAuthority owner, KRAPolicyConfig config) throws EBaseException {
        this.mKRA = owner;
        this.mConfig = config;
        this.mPolicies = new GenericPolicyProcessor(false);
        this.mPolicies.setCMSEngine(owner.getCMSEngine());
        this.mPolicies.init((IAuthority)this.mKRA, (ConfigStore)this.mConfig);
    }

    public IPolicyProcessor getPolicyProcessor() {
        return this.mPolicies;
    }

    public PolicyResult apply(Request r) {
        logger.debug("KRA applies policies");
        PolicyResult result = this.mPolicies.apply(r);
        if (result.equals(PolicyResult.DEFERRED)) {
            logger.debug("KRA policies return DEFERRED");
            return PolicyResult.REJECTED;
        }
        logger.debug("KRA policies return ACCEPTED");
        return this.mPolicies.apply(r);
    }
}

