/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.KeyGenInfo;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.CertRequestProcessedEvent;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.cert.ImportCertsTemplateFiller;
import com.netscape.cms.servlet.common.CAServlet;
import com.netscape.cms.servlet.common.CMSGateway;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cms.servlet.common.ICMSTemplateFiller;
import com.netscape.cms.servlet.processors.CMCProcessor;
import com.netscape.cms.servlet.processors.CRMFProcessor;
import com.netscape.cms.servlet.processors.KeyGenProcessor;
import com.netscape.cms.servlet.processors.PKCS10Processor;
import com.netscape.cms.servlet.processors.PKIProcessor;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.cert.CertUtils;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertRecordList;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.request.CertRequestRepository;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.usrgrp.Group;
import com.netscape.cmscore.usrgrp.UGSubsystem;
import com.netscape.cmscore.usrgrp.User;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtag.util.cert.CertUtil;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.netscape.security.extensions.CertInfo;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertificateAlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertificateX509Key;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="caenrollment", urlPatterns={"/enrollment"}, initParams={@WebInitParam(name="GetClientCert", value="false"), @WebInitParam(name="successTemplate", value="/ca/EnrollSuccess.template"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="ca"), @WebInitParam(name="interface", value="ee"), @WebInitParam(name="ID", value="caenrollment"), @WebInitParam(name="resourceID", value="certServer.ee.request.enrollment")})
public class EnrollServlet
extends CAServlet {
    public static Logger logger = LoggerFactory.getLogger(EnrollServlet.class);
    private static final long serialVersionUID = -6983729702665630013L;
    public static final String ADMIN_ENROLL_SERVLET_ID = "caadminEnroll";
    public static final String ENROLL_SUCCESS_TEMPLATE = "EnrollSuccess.template";
    public static final String OLD_CERT_TYPE = "csrCertType";
    public static final String CERT_TYPE = "certType";
    public static final String REQUEST_FORMAT = "reqFormat";
    public static final String REQUEST_FORMAT_PKCS10 = "PKCS10";
    public static final String REQUEST_FORMAT_CMC = "CMC";
    public static final String REQUEST_CONTENT = "requestContent";
    public static final String SUBJECT_KEYGEN_INFO = "subjectKeyGenInfo";
    public static final String PKCS10_REQUEST = "pkcs10Request";
    public static final String CMC_REQUEST = "cmcRequest";
    public static final String CRMF_REQUEST = "CRMFRequest";
    public static final String SUBJECT_NAME = "subject";
    public static final String CRMF_REQID = "crmfReqId";
    public static final String CHALLENGE_PASSWORD = "challengePhrase";
    private static final String CERT_AUTH_DUAL = "dual";
    private static final String CERT_AUTH_ENCRYPTION = "encryption";
    private static final String CERT_AUTH_SINGLE = "single";
    private static final String CLIENT_ISSUER = "clientIssuer";
    private String mEnrollSuccessTemplate = null;
    private ICMSTemplateFiller mEnrollSuccessFiller = new ImportCertsTemplateFiller();
    CertificateAuthority mCa;
    CertificateRepository mRepository;
    private boolean enforcePop = false;
    private String auditServiceID = "$Unidentified$";
    private static final String ADMIN_CA_ENROLLMENT_SERVLET = "caadminEnroll";
    private static final String AGENT_CA_BULK_ENROLLMENT_SERVLET = "cabulkissuance";
    private static final String AGENT_RA_BULK_ENROLLMENT_SERVLET = "rabulkissuance";
    private static final String EE_CA_CERT_BASED_ENROLLMENT_SERVLET = "cacertbasedenrollment";
    private static final String EE_CA_ENROLLMENT_SERVLET = "caenrollment";
    private static final String EE_RA_CERT_BASED_ENROLLMENT_SERVLET = "racertbasedenrollment";
    private static final String EE_RA_ENROLLMENT_SERVLET = "raenrollment";
    private static final String[] SIGNED_AUDIT_AUTOMATED_REJECTION_REASON = new String[]{"automated non-profile cert request rejection:  unable to render OLD_CERT_TYPE response", "automated non-profile cert request rejection:  unable to complete handleEnrollAuditLog() method", "automated non-profile cert request rejection:  unable to render success template", "automated non-profile cert request rejection:  indeterminate reason for inability to process cert request due to an EBaseException"};
    private boolean mIsTestBed;

    public void init(ServletConfig sc) throws ServletException {
        CAEngine engine;
        block10: {
            super.init(sc);
            logger.debug("EnrollServlet: In Enroll Servlet init!");
            engine = CAEngine.getInstance();
            CAEngineConfig configStore = engine.getConfig();
            try {
                String PKI_Subsystem = configStore.getString("subsystem.0.id", null);
                if (!PKI_Subsystem.trim().equalsIgnoreCase("ca")) break block10;
                String policyStatus = PKI_Subsystem.trim().toLowerCase() + ".Policy.enable";
                if (configStore.getBoolean(policyStatus, true)) {
                    logger.debug("EnrollServlet::init Certificate Policy Framework (deprecated) is ENABLED");
                    break block10;
                }
                logger.debug("EnrollServlet::init Certificate Policy Framework (deprecated) is DISABLED");
                return;
            }
            catch (EBaseException e) {
                throw new ServletException("EnrollServlet::init - EBaseException:  Unable to initialize Certificate Policy Framework (deprecated)");
            }
        }
        this.mTemplates.remove(CMSRequest.SUCCESS);
        try {
            ICMSTemplateFiller filler;
            String fillername;
            String id = sc.getInitParameter("ID");
            if (id != null) {
                this.auditServiceID = !this.auditServiceID.equals("caadminEnroll") && !this.auditServiceID.equals(AGENT_CA_BULK_ENROLLMENT_SERVLET) && !this.auditServiceID.equals(AGENT_RA_BULK_ENROLLMENT_SERVLET) && !this.auditServiceID.equals(EE_CA_CERT_BASED_ENROLLMENT_SERVLET) && !this.auditServiceID.equals(EE_CA_ENROLLMENT_SERVLET) && !this.auditServiceID.equals(EE_RA_CERT_BASED_ENROLLMENT_SERVLET) && !this.auditServiceID.equals(EE_RA_ENROLLMENT_SERVLET) ? "$Unidentified$" : id.trim();
            }
            this.mEnrollSuccessTemplate = sc.getInitParameter("successTemplate");
            if (this.mEnrollSuccessTemplate == null) {
                this.mEnrollSuccessTemplate = ENROLL_SUCCESS_TEMPLATE;
            }
            if ((fillername = sc.getInitParameter("successTemplateFiller")) != null && (filler = this.newFillerObject(fillername)) != null) {
                this.mEnrollSuccessFiller = filler;
            }
            this.mCa = engine.getCA();
            this.init_testbed_hack(this.mConfig);
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"CMSGW_IMP_INIT_SERV_ERR", (Object[])new Object[]{e.toString(), this.mId}), (Throwable)e);
        }
    }

    public boolean getEnforcePop() {
        return this.enforcePop;
    }

    protected void process(CMSRequest cmsReq) throws EBaseException {
        CMSEngine engine = this.getCMSEngine();
        CMSGateway gateway = engine.getCMSGateway();
        if (this.mId.equals("caadminEnroll") && !gateway.getEnableAdminEnroll()) {
            logger.error(CMS.getLogMessage((String)"ADMIN_SRVLT_ENROLL_ACCESS_AFTER_SETUP", (Object[])new Object[0]));
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_REDIRECTING_ADMINENROLL_ERROR", (String[])new String[]{"Attempt to access adminEnroll after already setup."}));
        }
        this.processX509(cmsReq);
    }

    private boolean getCertAuthEnrollStatus(ArgBlock httpParams) {
        boolean certAuthEnroll = false;
        String certAuthEnrollOn = httpParams.getValueAsString("certauthEnroll", null);
        if (certAuthEnrollOn != null && certAuthEnrollOn.equals("on")) {
            certAuthEnroll = true;
            logger.debug("EnrollServlet: certAuthEnroll is on");
        }
        return certAuthEnroll;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String getCertAuthEnrollType(ArgBlock httpParams, boolean certAuthEnroll) throws EBaseException {
        String certauthEnrollType = null;
        if (!certAuthEnroll) return certauthEnrollType;
        certauthEnrollType = httpParams.getValueAsString("certauthEnrollType", null);
        if (certauthEnrollType == null) {
            logger.error(CMS.getLogMessage((String)"MSGW_MISSING_CERTAUTH_ENROLL_TYPE", (Object[])new Object[0]));
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_MISSING_CERTAUTH_ENROLL_TYPE", (String[])new String[0]));
        }
        if (certauthEnrollType.equals(CERT_AUTH_DUAL)) {
            logger.debug("EnrollServlet: certauthEnrollType is dual");
            return certauthEnrollType;
        }
        if (certauthEnrollType.equals(CERT_AUTH_ENCRYPTION)) {
            logger.debug("EnrollServlet: certauthEnrollType is encryption");
            return certauthEnrollType;
        }
        if (certauthEnrollType.equals(CERT_AUTH_SINGLE)) {
            logger.debug("EnrollServlet: certauthEnrollType is single");
            return certauthEnrollType;
        }
        logger.error(CMS.getLogMessage((String)"CMSGW_INVALID_CERTAUTH_ENROLL_TYPE_1", (Object[])new Object[]{certauthEnrollType}));
        throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_INVALID_CERTAUTH_ENROLL_TYPE", (String[])new String[0]));
    }

    private boolean checkClientCertSigningOnly(X509Certificate sslClientCert) throws EBaseException {
        if (!CertUtils.isSigningCert((X509CertImpl)((X509CertImpl)sslClientCert)) || CertUtils.isSigningCert((X509CertImpl)((X509CertImpl)sslClientCert)) && CertUtils.isEncryptionCert((X509CertImpl)((X509CertImpl)sslClientCert))) {
            logger.error(CMS.getLogMessage((String)"CMSGW_INVALID_CERT_TYPE", (Object[])new Object[0]));
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_INVALID_CERT_TYPE", (String[])new String[0]));
        }
        return true;
    }

    private X509CertInfo[] handleCertAuthDual(X509CertInfo certInfo, AuthToken authToken, X509Certificate sslClientCert, CertificateAuthority mCa, String certBasedOldSubjectDN, BigInteger certBasedOldSerialNum) throws EBaseException {
        logger.debug("EnrollServlet: In handleCertAuthDual!");
        if (mCa == null) {
            logger.error(CMS.getLogMessage((String)"CMSGW_NOT_A_CA", (Object[])new Object[0]));
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_NOT_A_CA", (String[])new String[0]));
        }
        CAEngine engine = CAEngine.getInstance();
        CertificateRepository cr = engine.getCertificateRepository();
        try {
            this.checkClientCertSigningOnly(sslClientCert);
        }
        catch (ECMSGWException e) {
            throw new ECMSGWException(e.toString());
        }
        X509Key key = null;
        key = (X509Key)sslClientCert.getPublicKey();
        try {
            certInfo.set("key", (Object)new CertificateX509Key(key));
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_FAILED_SET_KEY_FROM_CERT_AUTH_ENROLL_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_SET_KEY_FROM_CERT_AUTH_ENROLL_FAILED", (String[])new String[]{e.toString()}), (Exception)e);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_FAILED_SET_KEY_FROM_CERT_AUTH_ENROLL_IO", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_SET_KEY_FROM_CERT_AUTH_ENROLL_FAILED", (String[])new String[]{e.toString()}), (Exception)e);
        }
        String filter = "(&(x509cert.subject=" + certBasedOldSubjectDN + ")(!(x509cert.serialNumber=" + certBasedOldSerialNum + "))(certStatus=VALID))";
        CertRecordList list = cr.findCertRecordsInList(filter, null, 10);
        int size = list.getSize();
        Enumeration en = list.getCertRecords(0, size - 1);
        logger.debug("EnrollServlet: signing cert filter " + filter);
        if (en.hasMoreElements()) {
            CertInfo encCertInfo = new CertInfo();
            X509CertInfo[] cInfoArray = new X509CertInfo[]{certInfo, encCertInfo};
            int i = 1;
            boolean encCertFound = false;
            while (en.hasMoreElements()) {
                CertRecord record = (CertRecord)en.nextElement();
                X509CertImpl cert = record.getCertificate();
                if (!CertUtils.isEncryptionCert((X509CertImpl)cert) || CertUtils.isEncryptionCert((X509CertImpl)cert) && CertUtils.isSigningCert((X509CertImpl)cert)) {
                    logger.debug("EnrollServlet: Not encryption only cert, will try next one.");
                    continue;
                }
                key = (X509Key)cert.getPublicKey();
                logger.debug("EnrollServlet: Found key for encryption cert.");
                encCertFound = true;
                try {
                    encCertInfo = (X509CertInfo)cert.get("x509.info");
                }
                catch (CertificateParsingException ex) {
                    logger.error(CMS.getLogMessage((String)"CMSGW_MISSING_CERTINFO_ENCRYPT_CERT", (Object[])new Object[0]), (Throwable)ex);
                    throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_MISSING_CERTINFO", (String[])new String[0]), (Exception)ex);
                }
                try {
                    encCertInfo.set("key", (Object)new CertificateX509Key(key));
                }
                catch (CertificateException e) {
                    logger.error(CMS.getLogMessage((String)"CMSGW_FAILED_SET_KEY_FROM_CERT_AUTH_ENROLL_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
                    throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_SET_KEY_FROM_CERT_AUTH_ENROLL_FAILED", (String[])new String[]{e.toString()}), (Exception)e);
                }
                catch (IOException e) {
                    logger.error(CMS.getLogMessage((String)"CMSGW_FAILED_SET_KEY_FROM_CERT_AUTH_ENROLL_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
                    throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_SET_KEY_FROM_CERT_AUTH_ENROLL_FAILED", (String[])new String[]{e.toString()}), (Exception)e);
                }
                logger.debug("EnrollServlet: About to fillCertInfoFromAuthToken!");
                PKIProcessor.fillCertInfoFromAuthToken((X509CertInfo)encCertInfo, (AuthToken)authToken);
                cInfoArray[i++] = encCertInfo;
                break;
            }
            if (!encCertFound) {
                logger.warn("EnrollServlet: Leaving because Enc Cert not found.");
                return null;
            }
            logger.debug("EnrollServlet: returning cInfoArray of length " + cInfoArray.length);
            return cInfoArray;
        }
        logger.warn("EnrollServlet: pairing encryption cert not found!");
        return null;
    }

    private boolean handleEnrollAuditLog(Request req, CMSRequest cmsReq, String authMgr, AuthToken authToken, X509CertInfo certInfo, long startTime) throws EBaseException {
        Object initiative = null;
        String agentID = null;
        if (authToken == null) {
            initiative = "fromUser";
        } else {
            agentID = authToken.getInString("userid");
            initiative = "fromAgent agentID: " + agentID;
        }
        RequestStatus status = req.getRequestStatus();
        if (status != RequestStatus.COMPLETE) {
            cmsReq.setIRequestStatus();
            try {
                if (status == RequestStatus.REJECTED) {
                    Vector messages = req.getExtDataInStringVector("errors");
                    if (messages != null) {
                        Enumeration msgs = messages.elements();
                        StringBuffer wholeMsg = new StringBuffer();
                        while (msgs.hasMoreElements()) {
                            wholeMsg.append("\n");
                            wholeMsg.append((String)msgs.nextElement());
                        }
                        logger.info("Enrollment request reqID {} {} authenticated by {} is {}. DN requested: {} {}", new Object[]{req.getRequestId().toHexString(), initiative, authMgr, status.toString(), certInfo.get(SUBJECT_NAME), " violation: " + wholeMsg});
                    } else {
                        logger.info("Enrollment request reqID {} {} authenticated by {} is {}. DN requested: {} {}", new Object[]{req.getRequestId().toHexString(), initiative, authMgr, status.toString(), certInfo.get(SUBJECT_NAME), ""});
                    }
                } else {
                    long endTime = new Date().getTime();
                    logger.info("Enrollment request reqID {} {} authenticated by {} is {}. DN requested: {} {}", new Object[]{req.getRequestId().toHexString(), initiative, authMgr, status.toString(), certInfo.get(SUBJECT_NAME) + " time: " + (endTime - startTime), ""});
                }
            }
            catch (IOException e) {
                logger.warn(CMS.getLogMessage((String)"CMSGW_CANT_GET_CERT_SUBJ_AUDITING", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            catch (CertificateException e) {
                logger.warn(CMS.getLogMessage((String)"CMSGW_CANT_GET_CERT_SUBJ_AUDITING", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            return false;
        }
        Integer result = req.getExtDataInInteger("Result");
        if (result.equals(Request.RES_ERROR)) {
            cmsReq.setStatus(CMSRequest.ERROR);
            cmsReq.setError(req.getExtDataInString("Error"));
            String[] svcErrors = req.getExtDataInStringArray("serviceErrors");
            if (svcErrors != null && svcErrors.length > 0) {
                for (int i = 0; i < svcErrors.length; ++i) {
                    String err = svcErrors[i];
                    if (err == null) continue;
                    cmsReq.setErrorDescription(err);
                    try {
                        logger.info("Enrollment request reqID {} {} authenticated by {} is {}. DN requested: {} {}", new Object[]{req.getRequestId().toHexString(), initiative, authMgr, "completed with error: " + err, certInfo.get(SUBJECT_NAME), ""});
                        continue;
                    }
                    catch (IOException e) {
                        logger.warn(CMS.getLogMessage((String)"CMSGW_CANT_GET_CERT_SUBJ_AUDITING", (Object[])new Object[]{e.toString()}), (Throwable)e);
                        continue;
                    }
                    catch (CertificateException e) {
                        logger.warn(CMS.getLogMessage((String)"CMSGW_CANT_GET_CERT_SUBJ_AUDITING", (Object[])new Object[]{e.toString()}), (Throwable)e);
                    }
                }
            }
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processX509(CMSRequest cmsReq) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig configStore = engine.getConfig();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        String auditRequesterID = "$Unidentified$";
        String auditCertificateSubjectName = "<null>";
        String id = null;
        long startTime = 0L;
        ArgBlock httpParams = null;
        HttpServletRequest httpReq = null;
        AuthToken authToken = null;
        AuthzToken authzToken = null;
        Request req = null;
        CertInfo certInfo = null;
        this.enforcePop = configStore.getBoolean("enrollment.enforcePop", false);
        logger.debug("EnrollServlet: enforcePop " + this.enforcePop);
        try {
            X509CertInfo[] certInfoArray;
            String challengePassword;
            block78: {
                byte[] crmf;
                byte[] cmc;
                PKCS10 pkcs10;
                KeyGenInfo keyGenInfo;
                block79: {
                    X509Certificate sslClientCert;
                    String certauthEnrollType;
                    block80: {
                        startTime = new Date().getTime();
                        httpParams = cmsReq.getHttpParams();
                        httpReq = cmsReq.getHttpReq();
                        if (this.mAuthMgr != null) {
                            authToken = this.authenticate(cmsReq);
                        }
                        try {
                            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "submit");
                        }
                        catch (EAuthzAccessDenied e) {
                            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
                        }
                        catch (Exception e) {
                            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
                        }
                        if (authzToken == null) {
                            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
                            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_NON_PROFILE_CERT_REQUEST_5", (Object[])new Object[]{auditSubjectID, "Failure", auditRequesterID, this.auditServiceID, auditCertificateSubjectName});
                            auditor.log(auditMessage);
                            return;
                        }
                        CertRequestRepository requestRepository = engine.getCertRequestRepository();
                        req = requestRepository.createRequest("enrollment");
                        if (req != null && (id = req.getRequestId().toHexString()) != null) {
                            auditRequesterID = id.trim();
                        }
                        try {
                            if (configStore.getBoolean("useThreadNaming", false)) {
                                String currentName = Thread.currentThread().getName();
                                Thread.currentThread().setName(currentName + "-request-" + req.getRequestId().toString() + "-" + new Date().getTime());
                            }
                        }
                        catch (Exception currentName) {
                            // empty catch block
                        }
                        boolean certAuthEnroll = false;
                        certauthEnrollType = null;
                        certAuthEnroll = this.getCertAuthEnrollStatus(httpParams);
                        try {
                            if (certAuthEnroll) {
                                certauthEnrollType = this.getCertAuthEnrollType(httpParams, certAuthEnroll);
                            }
                        }
                        catch (ECMSGWException e) {
                            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_NON_PROFILE_CERT_REQUEST_5", (Object[])new Object[]{auditSubjectID, "Failure", auditRequesterID, this.auditServiceID, auditCertificateSubjectName});
                            auditor.log(auditMessage);
                            throw new ECMSGWException(e.toString());
                        }
                        logger.debug("EnrollServlet: In EnrollServlet.processX509!");
                        logger.debug("EnrollServlet: certAuthEnroll " + certAuthEnroll);
                        logger.debug("EnrollServlet: certauthEnrollType " + certauthEnrollType);
                        challengePassword = httpParams.getValueAsString("challengePassword", "");
                        cmsReq.setRequest(req);
                        this.saveHttpHeaders(httpReq, req);
                        this.saveHttpParams(httpParams, req);
                        sslClientCert = null;
                        String certBasedOldSubjectDN = null;
                        BigInteger certBasedOldSerialNum = null;
                        certInfo = null;
                        if (certAuthEnroll) {
                            sslClientCert = this.getSSLClientCertificate(httpReq);
                            if (sslClientCert == null) {
                                logger.error(CMS.getLogMessage((String)"CMSGW_MISSING_SSL_CLIENT_CERT", (Object[])new Object[0]));
                                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_NON_PROFILE_CERT_REQUEST_5", (Object[])new Object[]{auditSubjectID, "Failure", auditRequesterID, this.auditServiceID, auditCertificateSubjectName});
                                auditor.log(auditMessage);
                                throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_MISSING_SSL_CLIENT_CERT", (String[])new String[0]));
                            }
                            certBasedOldSubjectDN = sslClientCert.getSubjectDN().toString();
                            certBasedOldSerialNum = sslClientCert.getSerialNumber();
                            logger.debug("EnrollServlet: certBasedOldSubjectDN " + certBasedOldSubjectDN);
                            logger.debug("EnrollServlet: certBasedOldSerialNum " + certBasedOldSerialNum);
                            if (certBasedOldSubjectDN != null) {
                                auditCertificateSubjectName = certBasedOldSubjectDN.trim();
                            }
                            try {
                                certInfo = (X509CertInfo)((X509CertImpl)sslClientCert).get("x509.info");
                            }
                            catch (CertificateParsingException ex) {
                                logger.error(CMS.getLogMessage((String)"CMSGW_MISSING_CERTINFO", (Object[])new Object[0]), (Throwable)ex);
                                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_NON_PROFILE_CERT_REQUEST_5", (Object[])new Object[]{auditSubjectID, "Failure", auditRequesterID, this.auditServiceID, auditCertificateSubjectName});
                                auditor.log(auditMessage);
                                throw new ECMSGWException(CMS.getUserMessage((Locale)this.getLocale(httpReq), (String)"CMS_GW_MISSING_CERTINFO", (String[])new String[0]));
                            }
                        } else {
                            logger.debug("EnrollServlet: No CertAuthEnroll.");
                            certInfo = new CertInfo();
                        }
                        certInfoArray = new X509CertInfo[]{certInfo};
                        String authMgr = "noAuthManager";
                        if (authToken != null) {
                            authMgr = authToken.getInString("authMgrInstName");
                            logger.info("EnrollServlet: Enrollment request was authenticated by " + authToken.getInString("authMgrInstName"));
                            PKIProcessor.fillCertInfoFromAuthToken((X509CertInfo)certInfo, (AuthToken)authToken);
                            EnrollServlet.saveAuthToken((AuthToken)authToken, (Request)req);
                        }
                        logger.debug("EnrollServlet: Enroll authMgr " + authMgr);
                        if (certAuthEnroll && authToken == null) {
                            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_PROCESS_ENROLL_NO_AUTH", (Object[])new Object[0]));
                            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_NON_PROFILE_CERT_REQUEST_5", (Object[])new Object[]{auditSubjectID, "Failure", auditRequesterID, this.auditServiceID, auditCertificateSubjectName});
                            auditor.log(auditMessage);
                            return;
                        }
                        keyGenInfo = httpParams.getValueAsKeyGenInfo(SUBJECT_KEYGEN_INFO, null);
                        pkcs10 = null;
                        String certType = httpParams.getValueAsString(OLD_CERT_TYPE, null);
                        logger.debug("EnrollServlet: certType " + certType);
                        if (certType == null) {
                            certType = httpParams.getValueAsString(CERT_TYPE, "client");
                            logger.debug("EnrollServlet: certType " + certType);
                        } else {
                            req.setExtData("HTTP_PARAMS", CERT_TYPE, certType);
                        }
                        if (certType.equals("client")) {
                            String p10b64 = httpParams.getValueAsString(PKCS10_REQUEST, null);
                            if (p10b64 != null) {
                                try {
                                    byte[] bytes = Utils.base64decode((String)p10b64);
                                    pkcs10 = new PKCS10(bytes);
                                }
                                catch (Exception e) {
                                    pkcs10 = httpParams.getValueAsPKCS10(PKCS10_REQUEST, false, null);
                                }
                            }
                        } else {
                            try {
                                pkcs10 = httpParams.getValueAsPKCS10(PKCS10_REQUEST, false, null);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        String cmcBase64 = httpParams.getValueAsString(CMC_REQUEST, null);
                        logger.debug("EnrollServlet: CMC: " + cmcBase64);
                        cmc = null;
                        if (cmcBase64 != null && !cmcBase64.isBlank()) {
                            cmc = CertUtil.parseCSR((String)cmcBase64);
                        }
                        String crmfBase64 = httpParams.getValueAsString(CRMF_REQUEST, null);
                        logger.debug("EnrollServlet: CRMF: " + crmfBase64);
                        crmf = null;
                        if (crmfBase64 != null && !crmfBase64.isBlank()) {
                            crmf = Utils.base64decode((String)crmfBase64);
                        }
                        if (!certAuthEnroll) break block79;
                        PKIProcessor.fillCertInfoFromAuthToken((X509CertInfo)certInfo, (AuthToken)authToken);
                        if (!certauthEnrollType.equals(CERT_AUTH_DUAL)) break block80;
                        logger.debug("EnrollServlet: Attempting CERT_AUTH_DUAL");
                        boolean gotEncCert = false;
                        X509CertInfo[] cInfoArray = null;
                        try {
                            cInfoArray = this.handleCertAuthDual((X509CertInfo)certInfo, authToken, sslClientCert, this.mCa, certBasedOldSubjectDN, certBasedOldSerialNum);
                        }
                        catch (ECMSGWException e) {
                            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_NON_PROFILE_CERT_REQUEST_5", (Object[])new Object[]{auditSubjectID, "Failure", auditRequesterID, this.auditServiceID, auditCertificateSubjectName});
                            auditor.log(auditMessage);
                            throw new ECMSGWException(e.toString());
                        }
                        if (cInfoArray != null && cInfoArray.length != 0) {
                            logger.debug("EnrollServlet: cInfoArray Length " + cInfoArray.length);
                            certInfoArray = cInfoArray;
                            gotEncCert = true;
                        }
                        if (!gotEncCert) {
                            logger.error(CMS.getLogMessage((String)"CMSGW_ENCRYPTION_CERT_NOT_FOUND", (Object[])new Object[0]));
                            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_NON_PROFILE_CERT_REQUEST_5", (Object[])new Object[]{auditSubjectID, "Failure", auditRequesterID, this.auditServiceID, auditCertificateSubjectName});
                            auditor.log(auditMessage);
                            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_ENCRYPTION_CERT_NOT_FOUND", (String[])new String[0]));
                        }
                        break block78;
                    }
                    if (certauthEnrollType.equals(CERT_AUTH_ENCRYPTION)) {
                        try {
                            this.checkClientCertSigningOnly(sslClientCert);
                        }
                        catch (ECMSGWException e) {
                            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_NON_PROFILE_CERT_REQUEST_5", (Object[])new Object[]{auditSubjectID, "Failure", auditRequesterID, this.auditServiceID, auditCertificateSubjectName});
                            auditor.log(auditMessage);
                            throw new ECMSGWException(e.toString());
                        }
                        if (keyGenInfo != null) {
                            KeyGenProcessor keyGenProc = new KeyGenProcessor(cmsReq, (CMSServlet)this);
                            keyGenProc.setCMSEngine((CMSEngine)engine);
                            keyGenProc.fillCertInfo(null, (X509CertInfo)certInfo, authToken, httpParams);
                            req.setExtData(CLIENT_ISSUER, sslClientCert.getIssuerDN().toString());
                            logger.debug("EnrollServlet: sslClientCert issuerDN = " + sslClientCert.getIssuerDN().toString());
                            break block78;
                        } else {
                            if (crmf == null) {
                                logger.error(CMS.getLogMessage((String)"CMSGW_CANT_PROCESS_ENROLL_REQ", (Object[])new Object[0]) + CMS.getLogMessage((String)"CMSGW_MISSING_KEYGEN_INFO", (Object[])new Object[0]));
                                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_NON_PROFILE_CERT_REQUEST_5", (Object[])new Object[]{auditSubjectID, "Failure", auditRequesterID, this.auditServiceID, auditCertificateSubjectName});
                                auditor.log(auditMessage);
                                throw new ECMSGWException(CMS.getUserMessage((Locale)this.getLocale(httpReq), (String)"CMS_GW_MISSING_KEYGEN_INFO", (String[])new String[0]));
                            }
                            CRMFProcessor crmfProc = new CRMFProcessor(cmsReq, (CMSServlet)this, this.enforcePop);
                            crmfProc.setCMSEngine((CMSEngine)engine);
                            certInfoArray = crmfProc.fillCertInfoArray(crmf, authToken, httpParams, req);
                            req.setExtData(CLIENT_ISSUER, sslClientCert.getIssuerDN().toString());
                            logger.debug("EnrollServlet: sslClientCert issuerDN = " + sslClientCert.getIssuerDN().toString());
                        }
                        break block78;
                    } else if (certauthEnrollType.equals(CERT_AUTH_SINGLE)) {
                        if (keyGenInfo != null) {
                            KeyGenProcessor keyGenProc = new KeyGenProcessor(cmsReq, (CMSServlet)this);
                            keyGenProc.fillCertInfo(null, (X509CertInfo)certInfo, authToken, httpParams);
                        } else if (pkcs10 != null) {
                            PKCS10Processor pkcs10Proc = new PKCS10Processor(cmsReq, (CMSServlet)this);
                            pkcs10Proc.setCMSEngine((CMSEngine)engine);
                            pkcs10Proc.fillCertInfo(pkcs10, (X509CertInfo)certInfo, authToken, httpParams);
                        } else if (cmc != null) {
                            CMCProcessor cmcProc = new CMCProcessor(cmsReq, (CMSServlet)this, this.enforcePop);
                            cmcProc.setCMSEngine((CMSEngine)engine);
                            certInfoArray = cmcProc.fillCertInfoArray(cmc, authToken, httpParams, req);
                        } else {
                            if (crmf == null) {
                                logger.error(CMS.getLogMessage((String)"CMSGW_CANT_PROCESS_ENROLL_REQ", (Object[])new Object[0]) + CMS.getLogMessage((String)"CMSGW_MISSING_KEYGEN_INFO", (Object[])new Object[0]));
                                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_NON_PROFILE_CERT_REQUEST_5", (Object[])new Object[]{auditSubjectID, "Failure", auditRequesterID, this.auditServiceID, auditCertificateSubjectName});
                                auditor.log(auditMessage);
                                throw new ECMSGWException(CMS.getUserMessage((Locale)this.getLocale(httpReq), (String)"CMS_GW_MISSING_KEYGEN_INFO", (String[])new String[0]));
                            }
                            CRMFProcessor crmfProc = new CRMFProcessor(cmsReq, (CMSServlet)this, this.enforcePop);
                            certInfoArray = crmfProc.fillCertInfoArray(crmf, authToken, httpParams, req);
                        }
                        req.setExtData(CLIENT_ISSUER, sslClientCert.getIssuerDN().toString());
                    }
                    break block78;
                }
                if (keyGenInfo != null) {
                    logger.debug("EnrollServlet: Trying KeyGen with no cert auth.");
                    KeyGenProcessor keyGenProc = new KeyGenProcessor(cmsReq, (CMSServlet)this);
                    keyGenProc.fillCertInfo(null, (X509CertInfo)certInfo, authToken, httpParams);
                } else if (pkcs10 != null) {
                    logger.debug("EnrollServlet: Trying PKCS10 with no cert auth.");
                    PKCS10Processor pkcs10Proc = new PKCS10Processor(cmsReq, (CMSServlet)this);
                    pkcs10Proc.fillCertInfo(pkcs10, (X509CertInfo)certInfo, authToken, httpParams);
                } else if (cmc != null) {
                    logger.debug("EnrollServlet: Trying CMC with no cert auth.");
                    CMCProcessor cmcProc = new CMCProcessor(cmsReq, (CMSServlet)this, this.enforcePop);
                    certInfoArray = cmcProc.fillCertInfoArray(cmc, authToken, httpParams, req);
                } else {
                    if (crmf == null) {
                        logger.error(CMS.getLogMessage((String)"CMSGW_CANT_PROCESS_ENROLL_REQ", (Object[])new Object[0]) + CMS.getLogMessage((String)"CMSGW_MISSING_KEYGEN_INFO", (Object[])new Object[0]));
                        auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_NON_PROFILE_CERT_REQUEST_5", (Object[])new Object[]{auditSubjectID, "Failure", auditRequesterID, this.auditServiceID, auditCertificateSubjectName});
                        auditor.log(auditMessage);
                        throw new ECMSGWException(CMS.getUserMessage((Locale)this.getLocale(httpReq), (String)"CMS_GW_MISSING_KEYGEN_INFO", (String[])new String[0]));
                    }
                    logger.debug("EnrollServlet: Trying CRMF with no cert auth.");
                    CRMFProcessor crmfProc = new CRMFProcessor(cmsReq, (CMSServlet)this, this.enforcePop);
                    certInfoArray = crmfProc.fillCertInfoArray(crmf, authToken, httpParams, req);
                }
            }
            try {
                CertificateAuthority caSub = engine.getCA();
                if (certInfoArray != null && caSub != null) {
                    for (int ix = 0; ix < certInfoArray.length; ++ix) {
                        X509CertInfo ci = certInfoArray[ix];
                        String defaultSig = caSub.getDefaultAlgorithm();
                        AlgorithmId algid = AlgorithmId.get((String)defaultSig);
                        ci.set("algorithmID", (Object)new CertificateAlgorithmId(algid));
                    }
                }
            }
            catch (Exception e) {
                logger.warn("ErrorServlet: Failed to set signing alg to certinfo: " + e.getMessage(), (Throwable)e);
            }
            req.setExtData("CERT_INFO", certInfoArray);
            if (challengePassword != null && !challengePassword.equals("")) {
                String pwd = this.hashPassword(challengePassword);
                req.setExtData(CHALLENGE_PASSWORD, pwd);
            }
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_NON_PROFILE_CERT_REQUEST_5", (Object[])new Object[]{auditSubjectID, "Success", auditRequesterID, this.auditServiceID, auditCertificateSubjectName});
            auditor.log(auditMessage);
        }
        catch (EBaseException eAudit1) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_NON_PROFILE_CERT_REQUEST_5", (Object[])new Object[]{auditSubjectID, "Failure", auditRequesterID, this.auditServiceID, auditCertificateSubjectName});
            auditor.log(auditMessage);
            throw eAudit1;
        }
        X509CertImpl[] issuedCerts = null;
        try {
            this.mRequestQueue.processRequest(req);
            if (httpParams.getValueAsString(OLD_CERT_TYPE, null) != null) {
                try {
                    this.renderServerEnrollResult(cmsReq);
                    cmsReq.setStatus(CMSRequest.SUCCESS);
                    issuedCerts = cmsReq.getRequest().getExtDataInCertArray("issuedCerts");
                    int i = 0;
                    while (i < issuedCerts.length) {
                        auditor.log((LogEvent)CertRequestProcessedEvent.createSuccessEvent((String)auditSubjectID, (String)auditRequesterID, (String)"certificate", (X509CertImpl)issuedCerts[i]));
                        ++i;
                    }
                    return;
                }
                catch (Exception ex) {
                    cmsReq.setStatus(CMSRequest.ERROR);
                    auditor.log((LogEvent)CertRequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (String)"rejectReason", (String)SIGNED_AUDIT_AUTOMATED_REJECTION_REASON[0]));
                }
                return;
            }
            boolean completed = this.handleEnrollAuditLog(req, cmsReq, this.mAuthMgr, authToken, (X509CertInfo)certInfo, startTime);
            if (!completed) {
                auditor.log((LogEvent)CertRequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (String)"rejectReason", (String)SIGNED_AUDIT_AUTOMATED_REJECTION_REASON[1]));
                return;
            }
            cmsReq.setStatus(CMSRequest.SUCCESS);
            issuedCerts = req.getExtDataInCertArray("issuedCerts");
            Object initiative = null;
            if (authToken == null) {
                initiative = "fromUser";
            } else {
                String agentID = authToken.getInString("userid");
                initiative = "fromAgent agentID: " + agentID;
            }
            long endTime = new Date().getTime();
            logger.info("Enrollment request reqID {} {} authenticated by {} is {}. DN requested: {} {}", new Object[]{req.getRequestId().toHexString(), initiative, this.mAuthMgr, "completed", issuedCerts[0].getSubjectDN(), "cert issued serial number: 0x" + issuedCerts[0].getSerialNumber().toString(16) + " time: " + (endTime - startTime)});
            this.checkAdminEnroll(cmsReq, issuedCerts);
            if (this.checkImportCertToNav(cmsReq.getHttpResp(), httpParams, issuedCerts[0])) {
                cmsReq.setStatus(CMSRequest.SUCCESS);
                int i = 0;
                while (i < issuedCerts.length) {
                    auditor.log((LogEvent)CertRequestProcessedEvent.createSuccessEvent((String)auditSubjectID, (String)auditRequesterID, (String)"certificate", (X509CertImpl)issuedCerts[i]));
                    ++i;
                }
                return;
            }
            try {
                cmsReq.setResult((Object)issuedCerts);
                this.renderTemplate(cmsReq, this.mEnrollSuccessTemplate, this.mEnrollSuccessFiller);
                cmsReq.setStatus(CMSRequest.SUCCESS);
                int i = 0;
                while (i < issuedCerts.length) {
                    auditor.log((LogEvent)CertRequestProcessedEvent.createSuccessEvent((String)auditSubjectID, (String)auditRequesterID, (String)"certificate", (X509CertImpl)issuedCerts[i]));
                    ++i;
                }
                return;
            }
            catch (IOException e) {
                logger.error(CMS.getLogMessage((String)"CMSGW_TEMP_REND_ERR", (Object[])new Object[]{this.mEnrollSuccessFiller.toString(), e.toString()}), (Throwable)e);
                auditor.log((LogEvent)CertRequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (String)"rejectReason", (String)SIGNED_AUDIT_AUTOMATED_REJECTION_REASON[2]));
                throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_RETURNING_RESULT_ERROR", (String[])new String[0]), (Exception)e);
            }
        }
        catch (EBaseException eAudit1) {
            auditor.log((LogEvent)CertRequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (String)"rejectReason", (String)SIGNED_AUDIT_AUTOMATED_REJECTION_REASON[3]));
            throw eAudit1;
        }
    }

    protected void checkAdminEnroll(CMSRequest cmsReq, X509CertImpl[] issuedCerts) throws EBaseException {
        CMSEngine engine = this.getCMSEngine();
        CMSGateway gateway = engine.getCMSGateway();
        if (this.mAuthMgr != null && this.mAuthMgr.equals("passwdUserDBAuthMgr")) {
            this.addAdminAgent(cmsReq, issuedCerts);
            gateway.disableAdminEnroll();
        }
    }

    protected void addAdminAgent(CMSRequest cmsReq, X509CertImpl[] issuedCerts) throws EBaseException {
        String userid = cmsReq.getHttpParams().getValueAsString("uid");
        CAEngine engine = CAEngine.getInstance();
        UGSubsystem ug = engine.getUGSubsystem();
        User adminuser = ug.createUser(userid);
        adminuser.setX509Certificates((X509Certificate[])issuedCerts);
        ug.addUserCert(userid, (X509Certificate)issuedCerts[0]);
        Group agentGroup = ug.getGroupFromName("Certificate Manager Agents");
        if (agentGroup != null) {
            if (!agentGroup.isMember(userid)) {
                agentGroup.addMemberName(userid);
                ug.modifyGroup(agentGroup);
                logger.info("Admin UID: {} added User UID: {} to group: {}", new Object[]{userid, userid, "Certificate Manager Agents"});
            }
        } else {
            String msg = "Cannot add admin to the Certificate Manager Agents group: Group does not exist.";
            logger.error("EnrollServlet: " + msg);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_ADDING_ADMIN_ERROR", (String[])new String[0]));
        }
    }

    protected void renderServerEnrollResult(CMSRequest cmsReq) throws Exception {
        HttpServletResponse httpResp = cmsReq.getHttpResp();
        httpResp.setContentType("text/html");
        ServletOutputStream out = null;
        out = httpResp.getOutputStream();
        out.println("<HTML>");
        out.println("<TITLE>");
        out.println("Server Enrollment");
        out.println("</TITLE>");
        if (cmsReq.getRequest().getRequestStatus().equals((Object)RequestStatus.COMPLETE)) {
            out.println("<H1>");
            out.println("SUCCESS");
            out.println("</H1>");
            out.println("Your request is submitted and approved. Please cut and paste the certificate into your server.");
            out.println("<P>");
            out.println("Request Creation Time: ");
            out.println(cmsReq.getRequest().getCreationTime().toString());
            out.println("<P>");
            out.println("Request Status: ");
            out.println(cmsReq.getStatus().toString());
            out.println("<P>");
            out.println("Request ID: ");
            out.println(cmsReq.getRequest().getRequestId().toString());
            out.println("<P>");
            out.println("Certificate: ");
            out.println("<P>");
            out.println("<PRE>");
            X509CertImpl[] certs = cmsReq.getRequest().getExtDataInCertArray("issuedCerts");
            out.println(CertUtil.toPEM((X509Certificate)certs[0]));
            out.println("</PRE>");
            out.println("<P>");
            out.println("<!HTTP_OUTPUT REQUEST_CREATION_TIME=" + cmsReq.getRequest().getCreationTime().toString() + ">");
            out.println("<!HTTP_OUTPUT REQUEST_STATUS=" + cmsReq.getStatus().toString() + ">");
            out.println("<!HTTP_OUTPUT REQUEST_ID=" + cmsReq.getRequest().getRequestId().toString() + ">");
            out.println("<!HTTP_OUTPUT X509_CERTIFICATE=" + CertUtil.toPEM((X509Certificate)certs[0]) + ">");
        } else if (cmsReq.getRequest().getRequestStatus().equals((Object)RequestStatus.PENDING)) {
            out.println("<H1>");
            out.println("PENDING");
            out.println("</H1>");
            out.println("Your request is submitted. You can check on the status of your request with an authorized agent or local administrator by referring to the request ID.");
            out.println("<P>");
            out.println("Request Creation Time: ");
            out.println(cmsReq.getRequest().getCreationTime().toString());
            out.println("<P>");
            out.println("Request Status: ");
            out.println(cmsReq.getStatus().toString());
            out.println("<P>");
            out.println("Request ID: ");
            out.println(cmsReq.getRequest().getRequestId().toString());
            out.println("<P>");
            out.println("<!HTTP_OUTPUT REQUEST_CREATION_TIME=" + cmsReq.getRequest().getCreationTime().toString() + ">");
            out.println("<!HTTP_OUTPUT REQUEST_STATUS=" + cmsReq.getStatus().toString() + ">");
            out.println("<!HTTP_OUTPUT REQUEST_ID=" + cmsReq.getRequest().getRequestId().toString() + ">");
        } else {
            out.println("<H1>");
            out.println("ERROR");
            out.println("</H1>");
            out.println("<!INFO>");
            out.println("Please consult your local administrator for assistance.");
            out.println("<!/INFO>");
            out.println("<P>");
            out.println("Request Status: ");
            out.println(cmsReq.getStatus().toString());
            out.println("<P>");
            out.println("Error: ");
            out.println(cmsReq.getError());
            out.println("<P>");
            out.println("<!HTTP_OUTPUT REQUEST_STATUS=" + cmsReq.getStatus().toString() + ">");
            out.println("<!HTTP_OUTPUT ERROR=" + cmsReq.getError() + ">");
        }
        out.println("</HTML>");
    }

    private void init_testbed_hack(ConfigStore config) throws EBaseException {
        this.mIsTestBed = config.getBoolean("isTestBed", true);
    }
}

