/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.extensions;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Vector;
import org.dogtagpki.legacy.policy.EPolicyException;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.CertificateX509Key;
import org.mozilla.jss.netscape.security.x509.KeyIdentifier;
import org.mozilla.jss.netscape.security.x509.SubjectKeyIdentifierExtension;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectKeyIdentifierExt
extends APolicyRule
implements IEnrollmentPolicy,
IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(SubjectKeyIdentifierExt.class);
    protected static final String PROP_CRITICAL = "critical";
    protected static final String PROP_KEYID_TYPE = "keyIdentifierType";
    protected static final String PROP_REQATTR_NAME = "requestAttrName";
    protected static final String KEYID_TYPE_SHA1 = "SHA1";
    protected static final String KEYID_TYPE_TYPEFIELD = "TypeField";
    protected static final String KEYID_TYPE_SPKISHA1 = "SpkiSHA1";
    protected static final String KEYID_TYPE_REQATTR = "RequestAttribute";
    protected static final boolean DEF_CRITICAL = false;
    protected static final String DEF_KEYID_TYPE = "SHA1";
    protected static final String DEF_REQATTR_NAME = "KeyIdentifier";
    protected boolean mEnabled = false;
    protected ConfigStore mConfig;
    protected boolean mCritical = false;
    protected String mKeyIdType = "SHA1";
    protected String mReqAttrName = "KeyIdentifier";
    protected Vector<String> mInstanceParams = new Vector();
    protected static Vector<String> mDefaultParams = new Vector();

    public SubjectKeyIdentifierExt() {
        this.NAME = "SubjectKeyIdentifierExt";
        this.DESC = "Adds Subject Key Idenifier Extension to certs";
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EBaseException {
        this.mConfig = config;
        this.mEnabled = this.mConfig.getBoolean("enable", false);
        this.mCritical = this.mConfig.getBoolean(PROP_CRITICAL, false);
        this.mKeyIdType = this.mConfig.getString(PROP_KEYID_TYPE, "SHA1");
        if (this.mKeyIdType.equalsIgnoreCase("SHA1")) {
            this.mKeyIdType = "SHA1";
        } else if (this.mKeyIdType.equalsIgnoreCase(KEYID_TYPE_TYPEFIELD)) {
            this.mKeyIdType = KEYID_TYPE_TYPEFIELD;
        } else if (this.mKeyIdType.equalsIgnoreCase(KEYID_TYPE_SPKISHA1)) {
            this.mKeyIdType = KEYID_TYPE_SPKISHA1;
        } else {
            logger.error(CMS.getLogMessage((String)"KRA_UNKNOWN_KEY_ID_TYPE", (Object[])new Object[]{this.mKeyIdType}));
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTR_VALUE", (String[])new String[]{PROP_KEYID_TYPE, "value must be one of SHA1, TypeField, SpkiSHA1"}));
        }
        this.mInstanceParams.addElement("critical=" + this.mCritical);
        this.mInstanceParams.addElement("keyIdentifierType=" + this.mKeyIdType);
    }

    public PolicyResult apply(Request req) {
        X509CertInfo[] ci = req.getExtDataInCertInfoArray("CERT_INFO");
        if (ci == null || ci[0] == null) {
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_CERT_INFO", (String[])new String[0]), this.NAME);
            return PolicyResult.REJECTED;
        }
        for (int i = 0; i < ci.length; ++i) {
            PolicyResult certRes = this.applyCert(req, ci[i]);
            if (certRes != PolicyResult.REJECTED) continue;
            return certRes;
        }
        return PolicyResult.ACCEPTED;
    }

    public PolicyResult applyCert(Request req, X509CertInfo certInfo) {
        try {
            SubjectKeyIdentifierExtension subjectKeyIdExt = null;
            CertificateExtensions extensions = (CertificateExtensions)certInfo.get("extensions");
            try {
                if (extensions != null) {
                    subjectKeyIdExt = (SubjectKeyIdentifierExtension)extensions.get("SubjectKeyIdentifier");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (subjectKeyIdExt != null) {
                if (this.agentApproved(req)) {
                    logger.debug("SubjectKeyIdentifierExt: agent approved request id " + req.getRequestId() + " already has subject key id extension with value " + subjectKeyIdExt);
                    return PolicyResult.ACCEPTED;
                }
                logger.debug("SubjectKeyIdentifierExt: request id from user " + req.getRequestId() + " had subject key identifier - deleted to be replaced");
                extensions.delete("SubjectKeyIdentifier");
            }
            KeyIdentifier keyId = null;
            try {
                keyId = this.formKeyIdentifier(certInfo, req);
            }
            catch (EBaseException e) {
                this.setPolicyException(req, e);
                return PolicyResult.REJECTED;
            }
            subjectKeyIdExt = new SubjectKeyIdentifierExtension(this.mCritical, keyId.getIdentifier());
            if (extensions == null) {
                certInfo.set("version", (Object)new CertificateVersion(2));
                extensions = new CertificateExtensions();
                certInfo.set("extensions", (Object)extensions);
            }
            extensions.set("SubjectKeyIdentifier", (Object)subjectKeyIdExt);
            logger.debug("SubjectKeyIdentifierExt: added subject key id ext to request " + req.getRequestId());
            return PolicyResult.ACCEPTED;
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"POLICY_UNEXPECTED_POLICY_ERROR,NAME", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, e.getMessage());
            return PolicyResult.REJECTED;
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage((String)"CA_CERT_INFO_ERROR", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, "Certificate Info Error");
            return PolicyResult.REJECTED;
        }
    }

    protected KeyIdentifier formKeyIdentifier(X509CertInfo certInfo, Request req) throws EBaseException {
        KeyIdentifier keyId = null;
        if (this.mKeyIdType == "SHA1") {
            keyId = this.formSHA1KeyId(certInfo);
        } else if (this.mKeyIdType == KEYID_TYPE_TYPEFIELD) {
            keyId = this.formTypeFieldKeyId(certInfo);
        } else if (this.mKeyIdType == KEYID_TYPE_SPKISHA1) {
            keyId = this.formSpkiSHA1KeyId(certInfo);
        } else {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTR_VALUE", (String[])new String[]{this.mKeyIdType, "Unknown Key Identifier type."}));
        }
        return keyId;
    }

    protected KeyIdentifier formTypeFieldKeyId(X509CertInfo certInfo) throws EBaseException {
        KeyIdentifier keyId = null;
        X509Key key = null;
        try {
            CertificateX509Key certKey = (CertificateX509Key)certInfo.get("key");
            if (certKey == null) {
                logger.error(CMS.getLogMessage((String)"POLICY_MISSING_KEY_1", (Object[])new Object[]{this.NAME}));
                throw new EPolicyException(CMS.getUserMessage((String)"CMS_POLICY_MISSING_KEY", (String[])new String[]{this.NAME}));
            }
            key = (X509Key)certKey.get("value");
            if (key == null) {
                logger.error(CMS.getLogMessage((String)"POLICY_MISSING_KEY_1", (Object[])new Object[]{this.NAME}));
                throw new EPolicyException(CMS.getUserMessage((String)"CMS_POLICY_MISSING_KEY", (String[])new String[]{this.NAME}));
            }
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"POLICY_ERROR_GET_KEY_FROM_CERT", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new EPolicyException(CMS.getUserMessage((String)"CMS_POLICY_SUBJECT_KEY_ID_ERROR", (String[])new String[]{this.NAME}), (Exception)e);
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage((String)"POLICY_ERROR_GET_KEY_FROM_CERT", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new EPolicyException(CMS.getUserMessage((String)"CMS_POLICY_SUBJECT_KEY_ID_ERROR", (String[])new String[]{this.NAME}));
        }
        try {
            byte[] octetString = new byte[8];
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(key.getKey());
            byte[] hash = md.digest();
            System.arraycopy(hash, hash.length - 8, octetString, 0, 8);
            octetString[0] = (byte)(octetString[0] & (0x8F & octetString[0]));
            keyId = new KeyIdentifier(octetString);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(CMS.getLogMessage((String)"POLICY_ERROR_SUBJECT_KEY_ID_1", (Object[])new Object[]{this.NAME}), (Throwable)e);
            throw new EPolicyException(CMS.getUserMessage((String)"CMS_POLICY_SUBJECT_KEY_ID_ERROR", (String[])new String[]{this.NAME}), (Exception)e);
        }
        return keyId;
    }

    public Vector<String> getInstanceParams() {
        return this.mInstanceParams;
    }

    public Vector<String> getDefaultParams() {
        return mDefaultParams;
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"critical;boolean;RFC 2459 recommendation: MUST NOT be marked critical.", "keyIdentifierType;choice(SHA1,TypeField,SpkiSHA1);Method to derive the Key Identifier.", "HELP_TOKEN;configuration-policyrules-subjectkeyidentifier", "HELP_TEXT;Adds the Subject Key Identifier extension. See RFC 2459 (4.2.1.2)"};
        return params;
    }

    static {
        mDefaultParams.addElement("critical=false");
        mDefaultParams.addElement("keyIdentifierType=SHA1");
    }
}

