/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.json;

import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONFormattedAccessLogFields;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONObject;
import java.io.Serializable;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JSONOperationPurposeRequestControl
implements Serializable {
    private static final long serialVersionUID = 7062571568593641747L;
    @NotNull
    private final JSONObject controlObject;
    @Nullable
    private final String applicationName;
    @Nullable
    private final String applicationVersion;
    @Nullable
    private final String codeLocation;
    @Nullable
    private final String requestPurpose;

    public JSONOperationPurposeRequestControl(@NotNull JSONObject controlObject) {
        this.controlObject = controlObject;
        this.applicationName = controlObject.getFieldAsString(JSONFormattedAccessLogFields.OPERATION_PURPOSE_APPLICATION_NAME.getFieldName());
        this.applicationVersion = controlObject.getFieldAsString(JSONFormattedAccessLogFields.OPERATION_PURPOSE_APPLICATION_VERSION.getFieldName());
        this.codeLocation = controlObject.getFieldAsString(JSONFormattedAccessLogFields.OPERATION_PURPOSE_CODE_LOCATION.getFieldName());
        this.requestPurpose = controlObject.getFieldAsString(JSONFormattedAccessLogFields.OPERATION_PURPOSE_REQUEST_PURPOSE.getFieldName());
    }

    @NotNull
    public JSONObject getControlObject() {
        return this.controlObject;
    }

    @Nullable
    public String getApplicationName() {
        return this.applicationName;
    }

    @Nullable
    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    @Nullable
    public String getCodeLocation() {
        return this.codeLocation;
    }

    @Nullable
    public String getRequestPurpose() {
        return this.requestPurpose;
    }

    @NotNull
    public String toString() {
        return this.controlObject.toSingleLineString();
    }
}

