/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.scm.svn;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.scm.BlameCommand;
import org.sonar.api.batch.scm.ScmProvider;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.scm.svn.ChangedLinesComputer;
import org.sonar.plugins.scm.svn.SvnBlameCommand;
import org.sonar.plugins.scm.svn.SvnConfiguration;
import org.sonar.plugins.scm.svn.SvnPlugin;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SvnScmProvider
extends ScmProvider {
    private static final Logger LOG = Loggers.get(SvnScmProvider.class);
    private final SvnConfiguration configuration;
    private final SvnBlameCommand blameCommand;

    public SvnScmProvider(SvnConfiguration configuration, SvnBlameCommand blameCommand) {
        this.configuration = configuration;
        this.blameCommand = blameCommand;
    }

    public String key() {
        return "svn";
    }

    public boolean supports(File baseDir) {
        for (File folder = baseDir; folder != null; folder = folder.getParentFile()) {
            if (!new File(folder, ".svn").exists()) continue;
            return true;
        }
        return false;
    }

    public BlameCommand blameCommand() {
        return this.blameCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public Set<Path> branchChangedFiles(String targetBranchName, Path rootBaseDir) {
        SVNClientManager clientManager = null;
        try {
            clientManager = SvnPlugin.newSvnClientManager(this.configuration);
            Set<Path> set = SvnScmProvider.computeChangedPaths(rootBaseDir, clientManager);
            return set;
        }
        catch (SVNException e) {
            LOG.warn(e.getMessage());
        }
        finally {
            if (clientManager != null) {
                try {
                    clientManager.dispose();
                }
                catch (Exception e) {
                    LOG.warn("Unable to dispose SVN ClientManager", (Throwable)e);
                }
            }
        }
        return null;
    }

    private static Set<Path> computeChangedPaths(Path rootBaseDir, SVNClientManager clientManager) throws SVNException {
        SVNWCClient wcClient = clientManager.getWCClient();
        SVNInfo svnInfo = wcClient.doInfo(rootBaseDir.toFile(), null);
        String base = "/" + Paths.get(svnInfo.getRepositoryRootURL().getPath(), new String[0]).relativize(Paths.get(svnInfo.getURL().getPath(), new String[0]));
        HashSet<Path> paths = new HashSet<Path>();
        HashSet removed = new HashSet();
        SVNLogClient svnLogClient = clientManager.getLogClient();
        svnLogClient.doLog(new File[]{rootBaseDir.toFile()}, null, null, null, true, true, 0L, svnLogEntry -> {
            for (SVNLogEntryPath entry : svnLogEntry.getChangedPaths().values()) {
                if (!entry.getKind().equals(SVNNodeKind.FILE)) continue;
                Path path = rootBaseDir.resolve(Paths.get(base, new String[0]).relativize(Paths.get(entry.getPath(), new String[0])));
                if (SvnScmProvider.isModified(entry)) {
                    if (removed.contains(path)) continue;
                    paths.add(path);
                    continue;
                }
                if (entry.getType() != 'D') continue;
                removed.add(path);
            }
        });
        return paths;
    }

    private static boolean isModified(SVNLogEntryPath entry) {
        return entry.getType() == 'A' || entry.getType() == 'M';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public Map<Path, Set<Integer>> branchChangedLines(String targetBranchName, Path rootBaseDir, Set<Path> changedFiles) {
        SVNClientManager clientManager = null;
        try {
            clientManager = SvnPlugin.newSvnClientManager(this.configuration);
            SVNLogClient svnLogClient = clientManager.getLogClient();
            long[] revisionCounter = new long[]{0L};
            svnLogClient.doLog(new File[]{rootBaseDir.toFile()}, null, null, null, true, true, 0L, svnLogEntry -> {
                revisionCounter[0] = svnLogEntry.getRevision();
            });
            long startRev = revisionCounter[0];
            SVNDiffClient svnDiffClient = clientManager.getDiffClient();
            File path = rootBaseDir.toFile();
            ChangedLinesComputer computer = this.newChangedLinesComputer(changedFiles);
            svnDiffClient.doDiff(path, SVNRevision.create(startRev), path, SVNRevision.WORKING, SVNDepth.INFINITY, false, computer.receiver(), null);
            Map<Path, Set<Integer>> map = computer.changedLines();
            return map;
        }
        catch (Exception e) {
            LOG.warn("Failed to get changed lines from Subversion", (Throwable)e);
        }
        finally {
            if (clientManager != null) {
                try {
                    clientManager.dispose();
                }
                catch (Exception e) {
                    LOG.warn("Unable to dispose SVN ClientManager", (Throwable)e);
                }
            }
        }
        return null;
    }

    ChangedLinesComputer newChangedLinesComputer(Set<Path> changedFiles) {
        return new ChangedLinesComputer(changedFiles);
    }
}

