/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.report;

import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.AbstractProjectOrModule;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.scanner.protocol.output.ScannerReportWriter;
import org.sonar.scanner.report.ReportPublisherStep;
import org.sonar.scanner.scan.filesystem.InputComponentStore;

public class ComponentsPublisher
implements ReportPublisherStep {
    private final InputComponentStore inputComponentStore;
    private final DefaultInputProject project;

    public ComponentsPublisher(DefaultInputProject project, InputComponentStore inputComponentStore) {
        this.project = project;
        this.inputComponentStore = inputComponentStore;
    }

    @Override
    public void publish(ScannerReportWriter writer) {
        ScannerReport.Component.Builder projectBuilder = this.prepareProjectBuilder();
        ScannerReport.Component.Builder fileBuilder = ScannerReport.Component.newBuilder();
        for (DefaultInputFile file : this.inputComponentStore.allFilesToPublish()) {
            projectBuilder.addChildRef(file.scannerId());
            fileBuilder.clear();
            fileBuilder.setRef(file.scannerId());
            fileBuilder.setType(ScannerReport.Component.ComponentType.FILE);
            fileBuilder.setIsTest(file.type() == InputFile.Type.TEST);
            fileBuilder.setLines(file.lines());
            fileBuilder.setStatus(ComponentsPublisher.convert(file.status()));
            String lang = ComponentsPublisher.getLanguageKey(file);
            if (lang != null) {
                fileBuilder.setLanguage(lang);
            }
            fileBuilder.setProjectRelativePath(file.getProjectRelativePath());
            writer.writeComponent(fileBuilder.build());
        }
        writer.writeComponent(projectBuilder.build());
    }

    private ScannerReport.Component.Builder prepareProjectBuilder() {
        String description;
        ScannerReport.Component.Builder projectBuilder = ScannerReport.Component.newBuilder();
        projectBuilder.setRef(this.project.scannerId());
        projectBuilder.setType(ScannerReport.Component.ComponentType.PROJECT);
        projectBuilder.setKey(this.project.key());
        String name = ComponentsPublisher.getName(this.project);
        if (name != null) {
            projectBuilder.setName(name);
        }
        if ((description = ComponentsPublisher.getDescription(this.project)) != null) {
            projectBuilder.setDescription(description);
        }
        ComponentsPublisher.writeLinks(this.project, projectBuilder);
        return projectBuilder;
    }

    private static ScannerReport.Component.FileStatus convert(InputFile.Status status) {
        switch (status) {
            case ADDED: {
                return ScannerReport.Component.FileStatus.ADDED;
            }
            case CHANGED: {
                return ScannerReport.Component.FileStatus.CHANGED;
            }
            case SAME: {
                return ScannerReport.Component.FileStatus.SAME;
            }
        }
        throw new IllegalArgumentException("Unexpected status: " + (Object)((Object)status));
    }

    private static void writeLinks(DefaultInputProject project, ScannerReport.Component.Builder builder) {
        ScannerReport.ComponentLink.Builder linkBuilder = ScannerReport.ComponentLink.newBuilder();
        ComponentsPublisher.writeProjectLink(builder, project.properties(), linkBuilder, "sonar.links.homepage", ScannerReport.ComponentLink.ComponentLinkType.HOME);
        ComponentsPublisher.writeProjectLink(builder, project.properties(), linkBuilder, "sonar.links.ci", ScannerReport.ComponentLink.ComponentLinkType.CI);
        ComponentsPublisher.writeProjectLink(builder, project.properties(), linkBuilder, "sonar.links.issue", ScannerReport.ComponentLink.ComponentLinkType.ISSUE);
        ComponentsPublisher.writeProjectLink(builder, project.properties(), linkBuilder, "sonar.links.scm", ScannerReport.ComponentLink.ComponentLinkType.SCM);
    }

    private static void writeProjectLink(ScannerReport.Component.Builder componentBuilder, Map<String, String> properties, ScannerReport.ComponentLink.Builder linkBuilder, String linkProp, ScannerReport.ComponentLink.ComponentLinkType linkType) {
        String link = properties.get(linkProp);
        if (StringUtils.isNotBlank(link)) {
            linkBuilder.setType(linkType);
            linkBuilder.setHref(link);
            componentBuilder.addLink(linkBuilder.build());
            linkBuilder.clear();
        }
    }

    @CheckForNull
    private static String getLanguageKey(InputFile file) {
        return file.language();
    }

    @CheckForNull
    private static String getName(AbstractProjectOrModule module) {
        if (StringUtils.isNotEmpty(module.definition().getBranch())) {
            return module.definition().getName() + " " + module.definition().getBranch();
        }
        return module.definition().getOriginalName();
    }

    @CheckForNull
    private static String getDescription(AbstractProjectOrModule module) {
        return module.definition().getDescription();
    }
}

