/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.internal.ActiveRulesBuilder;
import org.sonar.api.batch.rule.internal.NewActiveRule;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scanner.rule.ActiveRulesLoader;
import org.sonar.scanner.rule.LoadedActiveRule;
import org.sonar.scanner.rule.QProfile;
import org.sonar.scanner.rule.QualityProfiles;

public class ActiveRulesProvider
extends ProviderAdapter {
    private static final Logger LOG = Loggers.get(ActiveRulesProvider.class);
    private static final String LOG_MSG = "Load active rules";
    private ActiveRules singleton = null;

    public ActiveRules provide(ActiveRulesLoader loader, QualityProfiles qProfiles) {
        if (this.singleton == null) {
            Profiler profiler = Profiler.create(LOG).startInfo(LOG_MSG);
            this.singleton = ActiveRulesProvider.load(loader, qProfiles);
            profiler.stopInfo();
        }
        return this.singleton;
    }

    private static ActiveRules load(ActiveRulesLoader loader, QualityProfiles qProfiles) {
        Collection<String> qProfileKeys = ActiveRulesProvider.getKeys(qProfiles);
        HashSet<RuleKey> loadedRulesKey = new HashSet<RuleKey>();
        ActiveRulesBuilder builder = new ActiveRulesBuilder();
        for (String qProfileKey : qProfileKeys) {
            List<LoadedActiveRule> qProfileRules = ActiveRulesProvider.load(loader, qProfileKey);
            for (LoadedActiveRule r : qProfileRules) {
                if (loadedRulesKey.contains(r.getRuleKey())) continue;
                loadedRulesKey.add(r.getRuleKey());
                builder.addRule(ActiveRulesProvider.transform(r, qProfileKey));
            }
        }
        return builder.build();
    }

    private static NewActiveRule transform(LoadedActiveRule activeRule, String qProfileKey) {
        NewActiveRule.Builder builder = new NewActiveRule.Builder();
        builder.setRuleKey(activeRule.getRuleKey()).setName(activeRule.getName()).setSeverity(activeRule.getSeverity()).setCreatedAt(activeRule.getCreatedAt()).setUpdatedAt(activeRule.getUpdatedAt()).setLanguage(activeRule.getLanguage()).setInternalKey(activeRule.getInternalKey()).setTemplateRuleKey(activeRule.getTemplateRuleKey()).setQProfileKey(qProfileKey);
        if (activeRule.getParams() != null) {
            for (Map.Entry<String, String> params : activeRule.getParams().entrySet()) {
                builder.setParam(params.getKey(), params.getValue());
            }
        }
        return builder.build();
    }

    private static List<LoadedActiveRule> load(ActiveRulesLoader loader, String qProfileKey) {
        return loader.load(qProfileKey);
    }

    private static Collection<String> getKeys(QualityProfiles qProfiles) {
        ArrayList<String> keys = new ArrayList<String>(qProfiles.findAll().size());
        for (QProfile qp : qProfiles.findAll()) {
            keys.add(qp.getKey());
        }
        return keys;
    }
}

