/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import org.sonar.api.SonarEdition;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.FileMetadata;
import org.sonar.api.batch.fs.internal.InputModuleHierarchy;
import org.sonar.api.batch.fs.internal.SensorStrategy;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.resources.Languages;
import org.sonar.api.resources.ResourceTypes;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.config.ScannerProperties;
import org.sonar.core.extension.CoreExtensionsInstaller;
import org.sonar.core.metric.ScannerMetrics;
import org.sonar.core.platform.ComponentContainer;
import org.sonar.scanner.DefaultFileLinesContextFactory;
import org.sonar.scanner.ProjectInfo;
import org.sonar.scanner.analysis.AnalysisTempFolderProvider;
import org.sonar.scanner.analysis.DefaultAnalysisMode;
import org.sonar.scanner.bootstrap.ExtensionInstaller;
import org.sonar.scanner.bootstrap.ExtensionMatcher;
import org.sonar.scanner.bootstrap.ExtensionUtils;
import org.sonar.scanner.bootstrap.GlobalAnalysisMode;
import org.sonar.scanner.bootstrap.MetricProvider;
import org.sonar.scanner.bootstrap.PostJobExtensionDictionnary;
import org.sonar.scanner.bootstrap.ProcessedScannerProperties;
import org.sonar.scanner.ci.CiConfigurationProvider;
import org.sonar.scanner.ci.vendors.AppVeyor;
import org.sonar.scanner.ci.vendors.AzureDevops;
import org.sonar.scanner.ci.vendors.BitbucketPipelines;
import org.sonar.scanner.ci.vendors.Buildkite;
import org.sonar.scanner.ci.vendors.CircleCi;
import org.sonar.scanner.ci.vendors.CirrusCi;
import org.sonar.scanner.ci.vendors.DroneCi;
import org.sonar.scanner.ci.vendors.GithubActions;
import org.sonar.scanner.ci.vendors.GitlabCi;
import org.sonar.scanner.ci.vendors.Jenkins;
import org.sonar.scanner.ci.vendors.SemaphoreCi;
import org.sonar.scanner.ci.vendors.TravisCi;
import org.sonar.scanner.cpd.CpdExecutor;
import org.sonar.scanner.cpd.CpdSettings;
import org.sonar.scanner.cpd.index.SonarCpdBlockIndex;
import org.sonar.scanner.deprecated.test.TestPlanBuilder;
import org.sonar.scanner.deprecated.test.TestableBuilder;
import org.sonar.scanner.issue.IssueFilters;
import org.sonar.scanner.issue.IssuePublisher;
import org.sonar.scanner.issue.ignore.EnforceIssuesFilter;
import org.sonar.scanner.issue.ignore.IgnoreIssuesFilter;
import org.sonar.scanner.issue.ignore.pattern.IssueExclusionPatternInitializer;
import org.sonar.scanner.issue.ignore.pattern.IssueInclusionPatternInitializer;
import org.sonar.scanner.issue.ignore.scanner.IssueExclusionsLoader;
import org.sonar.scanner.mediumtest.AnalysisObservers;
import org.sonar.scanner.notifications.DefaultAnalysisWarnings;
import org.sonar.scanner.postjob.DefaultPostJobContext;
import org.sonar.scanner.postjob.PostJobOptimizer;
import org.sonar.scanner.postjob.PostJobsExecutor;
import org.sonar.scanner.report.ActiveRulesPublisher;
import org.sonar.scanner.report.AnalysisContextReportPublisher;
import org.sonar.scanner.report.AnalysisWarningsPublisher;
import org.sonar.scanner.report.ChangedLinesPublisher;
import org.sonar.scanner.report.ComponentsPublisher;
import org.sonar.scanner.report.ContextPropertiesPublisher;
import org.sonar.scanner.report.MetadataPublisher;
import org.sonar.scanner.report.ReportPublisher;
import org.sonar.scanner.report.SourcePublisher;
import org.sonar.scanner.report.TestExecutionPublisher;
import org.sonar.scanner.repository.ContextPropertiesCache;
import org.sonar.scanner.repository.DefaultProjectRepositoriesLoader;
import org.sonar.scanner.repository.DefaultQualityProfileLoader;
import org.sonar.scanner.repository.ProjectRepositoriesLoader;
import org.sonar.scanner.repository.ProjectRepositoriesSupplier;
import org.sonar.scanner.repository.QualityProfileLoader;
import org.sonar.scanner.repository.QualityProfilesProvider;
import org.sonar.scanner.repository.language.DefaultLanguagesRepository;
import org.sonar.scanner.repository.settings.DefaultProjectSettingsLoader;
import org.sonar.scanner.repository.settings.ProjectSettingsLoader;
import org.sonar.scanner.rule.ActiveRulesLoader;
import org.sonar.scanner.rule.ActiveRulesProvider;
import org.sonar.scanner.rule.DefaultActiveRulesLoader;
import org.sonar.scanner.rule.DefaultRulesLoader;
import org.sonar.scanner.rule.QProfileVerifier;
import org.sonar.scanner.rule.RulesLoader;
import org.sonar.scanner.rule.RulesProvider;
import org.sonar.scanner.scan.ExternalProjectKeyAndOrganizationProvider;
import org.sonar.scanner.scan.InputModuleHierarchyProvider;
import org.sonar.scanner.scan.InputProjectProvider;
import org.sonar.scanner.scan.ModuleIndexer;
import org.sonar.scanner.scan.ModuleScanContainer;
import org.sonar.scanner.scan.MutableProjectReactorProvider;
import org.sonar.scanner.scan.MutableProjectSettings;
import org.sonar.scanner.scan.ProjectBuildersExecutor;
import org.sonar.scanner.scan.ProjectConfigurationProvider;
import org.sonar.scanner.scan.ProjectLock;
import org.sonar.scanner.scan.ProjectReactorBuilder;
import org.sonar.scanner.scan.ProjectReactorValidator;
import org.sonar.scanner.scan.ProjectServerSettingsProvider;
import org.sonar.scanner.scan.ScanProperties;
import org.sonar.scanner.scan.WorkDirectoriesInitializer;
import org.sonar.scanner.scan.branch.BranchConfiguration;
import org.sonar.scanner.scan.branch.BranchConfigurationProvider;
import org.sonar.scanner.scan.branch.BranchType;
import org.sonar.scanner.scan.branch.ProjectBranchesProvider;
import org.sonar.scanner.scan.branch.ProjectPullRequestsProvider;
import org.sonar.scanner.scan.filesystem.DefaultProjectFileSystem;
import org.sonar.scanner.scan.filesystem.FileIndexer;
import org.sonar.scanner.scan.filesystem.InputComponentStore;
import org.sonar.scanner.scan.filesystem.LanguageDetection;
import org.sonar.scanner.scan.filesystem.MetadataGenerator;
import org.sonar.scanner.scan.filesystem.ProjectCoverageAndDuplicationExclusions;
import org.sonar.scanner.scan.filesystem.ProjectExclusionFilters;
import org.sonar.scanner.scan.filesystem.ProjectFileIndexer;
import org.sonar.scanner.scan.filesystem.ScannerComponentIdGenerator;
import org.sonar.scanner.scan.filesystem.StatusDetection;
import org.sonar.scanner.scan.measure.DefaultMetricFinder;
import org.sonar.scanner.scm.ScmChangedFilesProvider;
import org.sonar.scanner.scm.ScmConfiguration;
import org.sonar.scanner.scm.ScmPublisher;
import org.sonar.scanner.scm.ScmRevisionImpl;
import org.sonar.scanner.sensor.DefaultSensorStorage;
import org.sonar.scanner.sensor.ProjectSensorContext;
import org.sonar.scanner.sensor.ProjectSensorExtensionDictionnary;
import org.sonar.scanner.sensor.ProjectSensorOptimizer;
import org.sonar.scanner.sensor.ProjectSensorsExecutor;

public class ProjectScanContainer
extends ComponentContainer {
    private static final Logger LOG = Loggers.get(ProjectScanContainer.class);

    public ProjectScanContainer(ComponentContainer globalContainer) {
        super(globalContainer);
    }

    @Override
    protected void doBeforeStart() {
        this.addScannerExtensions();
        this.addScannerComponents();
        ProjectLock lock = this.getComponentByType(ProjectLock.class);
        lock.tryLock();
        this.getComponentByType(WorkDirectoriesInitializer.class).execute();
    }

    private void addScannerComponents() {
        this.add(new ExternalProjectKeyAndOrganizationProvider(), ProcessedScannerProperties.class, ScanProperties.class, ProjectReactorBuilder.class, WorkDirectoriesInitializer.class, new MutableProjectReactorProvider(), ProjectBuildersExecutor.class, ProjectLock.class, ResourceTypes.class, ProjectReactorValidator.class, MetricProvider.class, ProjectInfo.class, new RulesProvider(), new BranchConfigurationProvider(), new ProjectBranchesProvider(), new ProjectPullRequestsProvider(), DefaultAnalysisMode.class, ProjectRepositoriesSupplier.class, new ProjectServerSettingsProvider(), new AnalysisTempFolderProvider(), ModuleIndexer.class, InputComponentStore.class, PathResolver.class, new InputProjectProvider(), new InputModuleHierarchyProvider(), ScannerComponentIdGenerator.class, new ScmChangedFilesProvider(), StatusDetection.class, LanguageDetection.class, MetadataGenerator.class, FileMetadata.class, FileIndexer.class, ProjectFileIndexer.class, ProjectExclusionFilters.class, new ActiveRulesProvider(), new QualityProfilesProvider(), CheckFactory.class, QProfileVerifier.class, NoSonarFilter.class, IssueFilters.class, IssuePublisher.class, DefaultMetricFinder.class, TestPlanBuilder.class, TestableBuilder.class, Languages.class, DefaultLanguagesRepository.class, IssueInclusionPatternInitializer.class, IssueExclusionPatternInitializer.class, IssueExclusionsLoader.class, EnforceIssuesFilter.class, IgnoreIssuesFilter.class, ContextPropertiesCache.class, ContextPropertiesPublisher.class, DefaultAnalysisWarnings.class, SensorStrategy.class, MutableProjectSettings.class, ScannerProperties.class, new ProjectConfigurationProvider(), ProjectCoverageAndDuplicationExclusions.class, ScannerMetrics.class, ReportPublisher.class, AnalysisContextReportPublisher.class, MetadataPublisher.class, ActiveRulesPublisher.class, AnalysisWarningsPublisher.class, ComponentsPublisher.class, TestExecutionPublisher.class, SourcePublisher.class, ChangedLinesPublisher.class, CpdExecutor.class, CpdSettings.class, SonarCpdBlockIndex.class, PostJobsExecutor.class, PostJobOptimizer.class, DefaultPostJobContext.class, PostJobExtensionDictionnary.class, ScmConfiguration.class, ScmPublisher.class, ScmRevisionImpl.class, DefaultSensorStorage.class, DefaultFileLinesContextFactory.class, ProjectSensorContext.class, ProjectSensorOptimizer.class, ProjectSensorsExecutor.class, ProjectSensorExtensionDictionnary.class, DefaultProjectFileSystem.class, new CiConfigurationProvider(), AppVeyor.class, AzureDevops.class, BitbucketPipelines.class, Buildkite.class, CircleCi.class, CirrusCi.class, DroneCi.class, GithubActions.class, GitlabCi.class, Jenkins.class, SemaphoreCi.class, TravisCi.class, AnalysisObservers.class);
        this.addIfMissing(DefaultProjectSettingsLoader.class, ProjectSettingsLoader.class);
        this.addIfMissing(DefaultRulesLoader.class, RulesLoader.class);
        this.addIfMissing(DefaultActiveRulesLoader.class, ActiveRulesLoader.class);
        this.addIfMissing(DefaultQualityProfileLoader.class, QualityProfileLoader.class);
        this.addIfMissing(DefaultProjectRepositoriesLoader.class, ProjectRepositoriesLoader.class);
    }

    private void addScannerExtensions() {
        this.getComponentByType(CoreExtensionsInstaller.class).install(this, CoreExtensionsInstaller.noExtensionFilter(), extension -> ProjectScanContainer.getScannerProjectExtensionsFilter().accept(extension));
        this.getComponentByType(ExtensionInstaller.class).install(this, ProjectScanContainer.getScannerProjectExtensionsFilter());
    }

    @VisibleForTesting
    static ExtensionMatcher getScannerProjectExtensionsFilter() {
        return extension -> {
            if (ExtensionUtils.isDeprecatedScannerSide(extension)) {
                return ExtensionUtils.isInstantiationStrategy(extension, "PER_BATCH");
            }
            return ExtensionUtils.isScannerSide(extension);
        };
    }

    @Override
    protected void doAfterStart() {
        GlobalAnalysisMode analysisMode = this.getComponentByType(GlobalAnalysisMode.class);
        InputModuleHierarchy tree = this.getComponentByType(InputModuleHierarchy.class);
        ScanProperties properties = this.getComponentByType(ScanProperties.class);
        SonarRuntime sonarRuntime = this.getComponentByType(SonarRuntime.class);
        properties.validate();
        properties.organizationKey().ifPresent(k -> LOG.info("Organization key: {}", k));
        if (sonarRuntime.getEdition() == SonarEdition.SONARCLOUD) {
            String branch = tree.root().definition().getBranch();
            if (branch != null) {
                LOG.info("Branch key: {}", (Object)branch);
                LOG.warn("The use of \"sonar.branch\" is deprecated and replaced by \"{}\". See {}.", (Object)"sonar.branch.name", (Object)"https://redirect.sonarsource.com/doc/branches.html");
            }
        } else {
            properties.get("sonar.branch").ifPresent(deprecatedBranch -> {
                throw MessageException.of("The 'sonar.branch' parameter is no longer supported. You should stop using it. Branch analysis is available in Developer Edition and above. See https://redirect.sonarsource.com/editions/developer.html for more information.");
            });
        }
        BranchConfiguration branchConfig = this.getComponentByType(BranchConfiguration.class);
        if (branchConfig.branchType() == BranchType.PULL_REQUEST) {
            LOG.info("Pull request {} for merge into {} from {}", branchConfig.pullRequestKey(), ProjectScanContainer.pullRequestBaseToDisplayName(branchConfig.targetBranchName()), branchConfig.branchName());
        } else if (branchConfig.branchName() != null) {
            LOG.info("Branch name: {}, type: {}", (Object)branchConfig.branchName(), (Object)ProjectScanContainer.branchTypeToDisplayName(branchConfig.branchType()));
        }
        this.getComponentByType(ProjectFileIndexer.class).index();
        this.getComponentByType(QProfileVerifier.class).execute();
        this.scanRecursively(tree, tree.root());
        LOG.info("------------- Run sensors on project");
        this.getComponentByType(ProjectSensorsExecutor.class).execute();
        this.getComponentByType(ScmPublisher.class).publish();
        this.getComponentByType(CpdExecutor.class).execute();
        this.getComponentByType(ReportPublisher.class).execute();
        this.getComponentByType(PostJobsExecutor.class).execute();
        if (analysisMode.isMediumTest()) {
            this.getComponentByType(AnalysisObservers.class).notifyEndOfScanTask();
        }
    }

    private static String pullRequestBaseToDisplayName(@Nullable String pullRequestBase) {
        return pullRequestBase != null ? pullRequestBase : "default branch";
    }

    private static String branchTypeToDisplayName(BranchType branchType) {
        switch (branchType) {
            case LONG: {
                return "long living";
            }
            case SHORT: {
                return "short living";
            }
        }
        throw new UnsupportedOperationException("unknown branch type: " + (Object)((Object)branchType));
    }

    private void scanRecursively(InputModuleHierarchy tree, DefaultInputModule module) {
        for (DefaultInputModule child : tree.children(module)) {
            this.scanRecursively(tree, child);
        }
        LOG.info("------------- Run sensors on module {}", (Object)module.definition().getName());
        this.scan(module);
    }

    @VisibleForTesting
    void scan(DefaultInputModule module) {
        new ModuleScanContainer(this, module).execute();
    }
}

