/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.check.Rule;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.SyntacticEquivalence;
import org.sonar.uast.UastNode;
import org.sonar.uast.helpers.CaseLike;
import org.sonar.uast.helpers.IfLike;
import org.sonar.uast.helpers.SwitchLike;

@Rule(key="S3923")
public class AllBranchesAreIdenticalCheck
extends Check {
    private static final String MESSAGE = "Remove this conditional structure or edit its code blocks so that they're not all the same.";
    private Set<UastNode> visitedIfs = new HashSet<UastNode>();

    public AllBranchesAreIdenticalCheck() {
        super(UastNode.Kind.IF, UastNode.Kind.SWITCH);
    }

    @Override
    public void enterFile(InputFile inputFile) {
        this.visitedIfs.clear();
    }

    @Override
    public void visitNode(UastNode node) {
        this.handleIf(node);
        this.handleSwitch(node);
    }

    private void handleSwitch(UastNode node) {
        SwitchLike switchLike = SwitchLike.from(node);
        if (switchLike == null) {
            return;
        }
        List<UastNode> caseNodes = switchLike.caseNodes();
        if (caseNodes.size() < 2) {
            return;
        }
        UastNode firstCase = CaseLike.from(caseNodes.get(0)).body();
        if (caseNodes.stream().noneMatch(UastNode.Kind.DEFAULT_CASE)) {
            return;
        }
        boolean allEquivalent = caseNodes.stream().skip(1L).map(caseNode -> CaseLike.from(caseNode).body()).allMatch(body -> SyntacticEquivalence.areEquivalent(firstCase, body));
        if (allEquivalent) {
            this.reportIssue(switchLike.switchKeyword(), MESSAGE);
        }
    }

    private void handleIf(UastNode node) {
        IfLike ifLike = IfLike.from(node);
        if (ifLike == null || this.visitedIfs.contains(node)) {
            return;
        }
        IfLike.ElseLike elseLike = ifLike.elseLike();
        boolean allSame = true;
        for (IfLike elseIf = ifLike.elseIf(); elseIf != null; elseIf = elseIf.elseIf()) {
            this.visitedIfs.add(elseIf.node());
            if (!SyntacticEquivalence.areEquivalent(ifLike.thenNode(), elseIf.thenNode())) {
                allSame = false;
            }
            elseLike = elseIf.elseLike();
        }
        if (elseLike == null) {
            return;
        }
        boolean bl = allSame = allSame && SyntacticEquivalence.areEquivalent(ifLike.thenNode(), elseLike.elseNode());
        if (allSame) {
            this.reportIssue(ifLike.ifKeyword(), MESSAGE);
        }
    }
}

