/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import org.sonar.check.Rule;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.SyntacticEquivalence;
import org.sonar.uast.UastNode;
import org.sonar.uast.helpers.AssignmentLike;

@Rule(key="S1656")
public class NoSelfAssignmentCheck
extends Check {
    public NoSelfAssignmentCheck() {
        super(AssignmentLike.KIND);
    }

    @Override
    public void visitNode(UastNode node) {
        AssignmentLike assignment = AssignmentLike.from(node);
        if (assignment != null && node.isNot(UastNode.Kind.VARIABLE_DECLARATION, UastNode.Kind.COMPOUND_ASSIGNMENT) && SyntacticEquivalence.areEquivalent(assignment.target(), assignment.value())) {
            this.reportIssue(node, "Remove this self assignment");
        }
    }
}

