/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.plugin;

import org.sonar.api.Plugin;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.utils.Version;
import org.sonar.go.plugin.GoExclusionsFileFilter;
import org.sonar.go.plugin.GoLanguage;
import org.sonar.go.plugin.GoRulesDefinition;
import org.sonar.go.plugin.GoSensor;
import org.sonar.go.plugin.GoTestSensor;
import org.sonar.go.plugin.SonarWayProfile;
import org.sonar.go.plugin.externalreport.GoLintReportSensor;
import org.sonar.go.plugin.externalreport.GoMetaLinterReportSensor;
import org.sonar.go.plugin.externalreport.GoVetReportSensor;

public class GoPlugin
implements Plugin {
    static final String RESOURCE_FOLDER = "org/sonar/l10n/go/rules/go";
    public static final String EXCLUSIONS_KEY = "sonar.go.exclusions";
    public static final String EXCLUSIONS_DEFAULT_VALUE = "**/vendor/**";
    private static final String GO_CATEGORY = "Go";
    private static final String GENERAL_SUBCATEGORY = "General";
    private static final String TEST_COVERAGE_SUBCATEGORY = "Test and Coverage";
    private static final String EXTERNAL_LINTER_SUBCATEGORY = "Popular Rule Engines";

    public void define(Plugin.Context context) {
        boolean externalIssuesSupported = context.getSonarQubeVersion().isGreaterThanOrEqual(Version.create((int)7, (int)2));
        context.addExtensions(GoLanguage.class, GoSensor.class, new Object[]{GoTestSensor.class, new GoRulesDefinition(externalIssuesSupported), SonarWayProfile.class, GoExclusionsFileFilter.class, GoVetReportSensor.class, GoLintReportSensor.class, GoMetaLinterReportSensor.class, PropertyDefinition.builder((String)"sonar.go.file.suffixes").index(10).name("File Suffixes").description("List of suffixes for files to analyze.").category(GO_CATEGORY).subCategory(GENERAL_SUBCATEGORY).onQualifiers("TRK", new String[0]).defaultValue(".go").multiValues(true).build(), PropertyDefinition.builder((String)EXCLUSIONS_KEY).index(11).defaultValue(EXCLUSIONS_DEFAULT_VALUE).name("Go Exclusions").description("List of file path patterns to be excluded from analysis of Go files.").category(GO_CATEGORY).subCategory(GENERAL_SUBCATEGORY).onQualifiers("BRC", new String[]{"TRK"}).multiValues(true).build(), PropertyDefinition.builder((String)"sonar.go.tests.reportPaths").index(19).name("Path to test execution report(s)").description("Path to test execution reports generated by Go with '-json' key, available since go1.10 (e.g.: go test -json > test-report.out).").category(GO_CATEGORY).subCategory(TEST_COVERAGE_SUBCATEGORY).onQualifiers("TRK", new String[0]).multiValues(true).build(), PropertyDefinition.builder((String)"sonar.go.coverage.reportPaths").index(20).name("Path to coverage report(s)").description("Path to coverage reports generated by Go (e.g.: go test -coverprofile=coverage.out), ant patterns relative to project root are supported.").category(GO_CATEGORY).subCategory(TEST_COVERAGE_SUBCATEGORY).onQualifiers("TRK", new String[0]).multiValues(true).build()});
        if (externalIssuesSupported) {
            context.addExtensions((Object)PropertyDefinition.builder((String)"sonar.go.govet.reportPaths").index(30).name("\"go vet\" Report Files").description("Paths (absolute or relative) to the files with \"go vet\" issues.").category(GO_CATEGORY).subCategory(EXTERNAL_LINTER_SUBCATEGORY).onQualifiers("TRK", new String[0]).defaultValue("").multiValues(true).build(), (Object)PropertyDefinition.builder((String)"sonar.go.golint.reportPaths").index(31).name("Golint Report Files").description("Paths (absolute or relative) to the files with Golint issues.").category(GO_CATEGORY).subCategory(EXTERNAL_LINTER_SUBCATEGORY).onQualifiers("TRK", new String[0]).defaultValue("").multiValues(true).build(), new Object[]{PropertyDefinition.builder((String)"sonar.go.gometalinter.reportPaths").index(32).name("GoMetaLinter Report Files").description("Paths (absolute or relative) to the files with GoMetaLinter issues.").category(GO_CATEGORY).subCategory(EXTERNAL_LINTER_SUBCATEGORY).onQualifiers("TRK", new String[0]).defaultValue("").multiValues(true).build()});
        }
    }
}

